/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.answering.resultset.impl;

import it.unibz.inf.ontop.answering.logging.QueryLogger;
import it.unibz.inf.ontop.answering.resultset.OntopBinding;
import it.unibz.inf.ontop.answering.resultset.impl.AbstractTupleResultSet;
import it.unibz.inf.ontop.answering.resultset.impl.OntopBindingImpl;
import it.unibz.inf.ontop.answering.resultset.impl.OntopConnectionCloseable;
import it.unibz.inf.ontop.answering.resultset.impl.SQLOntopBindingSet;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSortedSet;
import it.unibz.inf.ontop.com.google.common.collect.UnmodifiableIterator;
import it.unibz.inf.ontop.exception.OntopConnectionException;
import it.unibz.inf.ontop.exception.OntopResultConversionException;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.model.atom.DistinctVariableOnlyDataAtom;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.RDFConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import javax.annotation.Nullable;

public class JDBCTupleResultSet
extends AbstractTupleResultSet {
    private final ImmutableSortedSet<Variable> sqlSignature;
    private final ImmutableMap<Variable, DBTermType> sqlTypeMap;
    private final ImmutableSubstitution<ImmutableTerm> sparqlVar2Term;
    private final SubstitutionFactory substitutionFactory;
    private final TermFactory termFactory;

    public JDBCTupleResultSet(ResultSet rs, ImmutableSortedSet<Variable> sqlSignature, ImmutableMap<Variable, DBTermType> sqlTypeMap, ConstructionNode constructionNode, DistinctVariableOnlyDataAtom answerAtom, QueryLogger queryLogger, @Nullable OntopConnectionCloseable statementClosingCB, TermFactory termFactory, SubstitutionFactory substitutionFactory) {
        super(rs, (ImmutableList<Variable>)answerAtom.getArguments(), queryLogger, statementClosingCB);
        this.sqlSignature = sqlSignature;
        this.sqlTypeMap = sqlTypeMap;
        this.substitutionFactory = substitutionFactory;
        this.termFactory = termFactory;
        this.sparqlVar2Term = constructionNode.getSubstitution();
    }

    @Override
    protected SQLOntopBindingSet readCurrentRow() throws OntopConnectionException, OntopResultConversionException {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        UnmodifiableIterator it = this.sqlSignature.iterator();
        try {
            for (int i = 1; i <= this.sqlSignature.size(); ++i) {
                Variable var = (Variable)it.next();
                builder.put((Object)var, (Object)this.convertToConstant(this.rs.getString(i), (DBTermType)this.sqlTypeMap.get((Object)var)));
            }
        }
        catch (SQLException e) {
            throw this.buildConnectionException(e);
        }
        try {
            return new SQLOntopBindingSet(this.computeBindingMap((ImmutableSubstitution<Constant>)this.substitutionFactory.getSubstitution(builder.build())));
        }
        catch (Exception e) {
            throw new OntopResultConversionException(e);
        }
    }

    private Constant convertToConstant(@Nullable String jdbcValue, DBTermType termType) {
        if (jdbcValue == null) {
            return this.termFactory.getNullConstant();
        }
        return this.termFactory.getDBConstant(jdbcValue, termType);
    }

    private OntopBinding[] computeBindingMap(ImmutableSubstitution<Constant> sqlVar2Constant) {
        ImmutableSubstitution composition = sqlVar2Constant.composeWith(this.sparqlVar2Term);
        return (OntopBinding[])this.signature.stream().map(v -> this.getBinding((Variable)v, (ImmutableSubstitution<ImmutableTerm>)composition)).filter(Optional::isPresent).map(Optional::get).toArray(OntopBinding[]::new);
    }

    private Optional<OntopBinding> getBinding(Variable v, ImmutableSubstitution<ImmutableTerm> composition) {
        Optional<RDFConstant> constant = this.evaluate(composition.apply((ImmutableTerm)v));
        return constant.map(rdfConstant -> new OntopBindingImpl(v, rdfConstant));
    }

    private Optional<RDFConstant> evaluate(ImmutableTerm term) {
        ImmutableTerm simplifiedTerm = term.simplify();
        if (simplifiedTerm instanceof Constant) {
            if (simplifiedTerm instanceof RDFConstant) {
                return Optional.of((RDFConstant)simplifiedTerm);
            }
            Constant constant = (Constant)simplifiedTerm;
            if (constant.isNull()) {
                return Optional.empty();
            }
            if (constant instanceof DBConstant) {
                throw new SQLOntopBindingSet.InvalidConstantTypeInResultException(constant + "is a DB constant. But a binding cannot have a DB constant as value");
            }
            throw new SQLOntopBindingSet.InvalidConstantTypeInResultException("Unexpected constant type for " + constant);
        }
        throw new SQLOntopBindingSet.InvalidTermAsResultException(simplifiedTerm);
    }
}

