/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.answering.resultset.impl;

import it.unibz.inf.ontop.answering.logging.QueryLogger;
import it.unibz.inf.ontop.answering.resultset.OntopBindingSet;
import it.unibz.inf.ontop.answering.resultset.TupleResultSet;
import it.unibz.inf.ontop.answering.resultset.impl.OntopConnectionCloseable;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.exception.OntopConnectionException;
import it.unibz.inf.ontop.exception.OntopResultConversionException;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;

public abstract class AbstractTupleResultSet
implements TupleResultSet {
    protected final ResultSet rs;
    protected final ImmutableList<Variable> signature;
    private final QueryLogger queryLogger;
    @Nullable
    private final OntopConnectionCloseable statementClosingCB;
    private boolean lastCalledIsHasNext = false;
    private boolean foundNextElement = true;
    private long rowCount = 0L;

    AbstractTupleResultSet(ResultSet rs, ImmutableList<Variable> signature, QueryLogger queryLogger, @Nullable OntopConnectionCloseable statementClosingCB) {
        this.rs = rs;
        this.signature = signature;
        this.queryLogger = queryLogger;
        this.statementClosingCB = statementClosingCB;
    }

    public int getColumnCount() {
        return this.signature.size();
    }

    public int getFetchSize() throws OntopConnectionException {
        try {
            return this.rs.getFetchSize();
        }
        catch (Exception e) {
            throw this.buildConnectionException(e);
        }
    }

    public ImmutableList<String> getSignature() {
        return (ImmutableList)this.signature.stream().map(Variable::getName).collect(ImmutableCollectors.toList());
    }

    public OntopBindingSet next() throws OntopConnectionException, OntopResultConversionException {
        if (!this.lastCalledIsHasNext) {
            try {
                this.foundNextElement = this.moveCursor();
            }
            catch (Exception e) {
                throw this.buildConnectionException(e);
            }
        }
        this.lastCalledIsHasNext = false;
        if (!this.foundNextElement) {
            throw new NoSuchElementException("No next OntopBindingSet in this TupleResultSet");
        }
        return this.readCurrentRow();
    }

    public boolean hasNext() throws OntopConnectionException {
        if (!this.lastCalledIsHasNext) {
            this.lastCalledIsHasNext = true;
            try {
                this.foundNextElement = this.moveCursor();
                if (this.foundNextElement) {
                    ++this.rowCount;
                }
            }
            catch (Exception e) {
                throw this.buildConnectionException(e);
            }
        }
        if (!this.foundNextElement) {
            this.queryLogger.declareLastResultRetrievedAndSerialize(this.rowCount);
            this.close();
        }
        return this.foundNextElement;
    }

    protected boolean moveCursor() throws SQLException, OntopConnectionException {
        return this.rs.next();
    }

    public void close() throws OntopConnectionException {
        try {
            this.rs.close();
            if (this.statementClosingCB != null) {
                this.statementClosingCB.close();
            }
        }
        catch (Exception e) {
            throw this.buildConnectionException(e);
        }
    }

    public boolean isConnectionAlive() throws OntopConnectionException {
        try {
            return !this.rs.isClosed();
        }
        catch (SQLException e) {
            throw this.buildConnectionException(e);
        }
    }

    protected abstract OntopBindingSet readCurrentRow() throws OntopConnectionException, OntopResultConversionException;

    protected OntopConnectionException buildConnectionException(Exception e) {
        this.queryLogger.declareConnectionException(e);
        return new OntopConnectionException(e);
    }
}

