/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.answering.connection.impl;

import it.unibz.inf.ontop.answering.connection.JDBCStatementFinalizer;
import it.unibz.inf.ontop.answering.connection.impl.QuestStatement;
import it.unibz.inf.ontop.answering.logging.QueryLogger;
import it.unibz.inf.ontop.answering.reformulation.QueryReformulator;
import it.unibz.inf.ontop.answering.reformulation.input.ConstructTemplate;
import it.unibz.inf.ontop.answering.reformulation.input.InputQuery;
import it.unibz.inf.ontop.answering.resultset.BooleanResultSet;
import it.unibz.inf.ontop.answering.resultset.GraphResultSet;
import it.unibz.inf.ontop.answering.resultset.TupleResultSet;
import it.unibz.inf.ontop.answering.resultset.impl.DefaultSimpleGraphResultSet;
import it.unibz.inf.ontop.answering.resultset.impl.DistinctJDBCTupleResultSet;
import it.unibz.inf.ontop.answering.resultset.impl.EmptyTupleResultSet;
import it.unibz.inf.ontop.answering.resultset.impl.JDBCTupleResultSet;
import it.unibz.inf.ontop.answering.resultset.impl.OntopConnectionCloseable;
import it.unibz.inf.ontop.answering.resultset.impl.PredefinedBooleanResultSet;
import it.unibz.inf.ontop.answering.resultset.impl.SQLBooleanResultSet;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSortedSet;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.exception.OntopConnectionException;
import it.unibz.inf.ontop.exception.OntopInternalBugException;
import it.unibz.inf.ontop.exception.OntopQueryEvaluationException;
import it.unibz.inf.ontop.exception.OntopReformulationException;
import it.unibz.inf.ontop.exception.OntopResultConversionException;
import it.unibz.inf.ontop.injection.OntopSystemSQLSettings;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.exception.EmptyQueryException;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.NativeNode;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Optional;
import org.apache.commons.rdf.api.RDF;

public class SQLQuestStatement
extends QuestStatement {
    private final Statement sqlStatement;
    private final JDBCStatementFinalizer statementFinalizer;
    private final TermFactory termFactory;
    private final RDF rdfFactory;
    private final SubstitutionFactory substitutionFactory;
    private final OntopSystemSQLSettings settings;

    public SQLQuestStatement(QueryReformulator queryProcessor, Statement sqlStatement, JDBCStatementFinalizer statementFinalizer, TermFactory termFactory, RDF rdfFactory, SubstitutionFactory substitutionFactory, OntopSystemSQLSettings settings) {
        super(queryProcessor);
        this.sqlStatement = sqlStatement;
        this.statementFinalizer = statementFinalizer;
        this.termFactory = termFactory;
        this.rdfFactory = rdfFactory;
        this.substitutionFactory = substitutionFactory;
        this.settings = settings;
    }

    public int getMaxRows() throws OntopConnectionException {
        try {
            return this.sqlStatement.getMaxRows();
        }
        catch (SQLException e) {
            throw new OntopConnectionException((Exception)e);
        }
    }

    public void getMoreResults() throws OntopConnectionException {
        try {
            this.sqlStatement.getMoreResults();
        }
        catch (SQLException e) {
            throw new OntopConnectionException((Exception)e);
        }
    }

    public void setMaxRows(int max) throws OntopConnectionException {
        try {
            this.sqlStatement.setMaxRows(max);
        }
        catch (SQLException e) {
            throw new OntopConnectionException((Exception)e);
        }
    }

    public void setQueryTimeout(int seconds) throws OntopConnectionException {
        try {
            this.sqlStatement.setQueryTimeout(seconds);
        }
        catch (SQLException e) {
            throw new OntopConnectionException((Exception)e);
        }
    }

    public int getQueryTimeout() throws OntopConnectionException {
        try {
            return this.sqlStatement.getQueryTimeout();
        }
        catch (SQLException e) {
            throw new OntopConnectionException((Exception)e);
        }
    }

    public boolean isClosed() throws OntopConnectionException {
        try {
            return this.sqlStatement.isClosed();
        }
        catch (SQLException e) {
            throw new OntopConnectionException((Exception)e);
        }
    }

    public int getTupleCount(InputQuery inputQuery) throws OntopReformulationException, OntopQueryEvaluationException {
        IQ targetQuery = this.getExecutableQuery(inputQuery);
        try {
            String sql = this.extractSQLQuery(targetQuery);
            String newsql = "SELECT count(*) FROM (" + sql + ") t1";
            if (!this.isCanceled()) {
                try {
                    ResultSet set = this.sqlStatement.executeQuery(newsql);
                    if (set.next()) {
                        return set.getInt(1);
                    }
                    return 0;
                }
                catch (SQLException e) {
                    throw new OntopQueryEvaluationException((Exception)e);
                }
            }
            throw new OntopQueryEvaluationException("Action canceled.");
        }
        catch (EmptyQueryException e) {
            return 0;
        }
    }

    public void close() throws OntopConnectionException {
        try {
            if (this.sqlStatement != null) {
                this.statementFinalizer.closeStatement(this.sqlStatement);
            }
        }
        catch (SQLException e) {
            throw new OntopConnectionException((Exception)e);
        }
    }

    protected void cancelExecution() throws OntopQueryEvaluationException {
        try {
            this.sqlStatement.cancel();
        }
        catch (SQLException e) {
            throw new OntopQueryEvaluationException((Exception)e);
        }
    }

    public BooleanResultSet executeBooleanQuery(IQ executableQuery, QueryLogger queryLogger) throws OntopQueryEvaluationException {
        try {
            String sqlQuery = this.extractSQLQuery(executableQuery);
            try {
                ResultSet set = this.sqlStatement.executeQuery(sqlQuery);
                queryLogger.declareResultSetUnblockedAndSerialize();
                return new SQLBooleanResultSet(set, queryLogger, this::close);
            }
            catch (SQLException e) {
                throw new OntopQueryEvaluationException(e.getMessage());
            }
        }
        catch (EmptyQueryException e) {
            queryLogger.declareResultSetUnblockedAndSerialize();
            return new PredefinedBooleanResultSet(false);
        }
    }

    protected TupleResultSet executeSelectQuery(IQ executableQuery, QueryLogger queryLogger, boolean shouldAlsoCloseStatement) throws OntopQueryEvaluationException {
        try {
            String sqlQuery = this.extractSQLQuery(executableQuery);
            ConstructionNode constructionNode = this.extractRootConstructionNode(executableQuery);
            NativeNode nativeNode = this.extractNativeNode(executableQuery);
            ImmutableSortedSet signature = nativeNode.getVariables();
            ImmutableMap typeMap = nativeNode.getTypeMap();
            OntopConnectionCloseable statementClosingCB = shouldAlsoCloseStatement ? this::close : null;
            try {
                ResultSet set = this.sqlStatement.executeQuery(sqlQuery);
                queryLogger.declareResultSetUnblockedAndSerialize();
                return this.settings.isDistinctPostProcessingEnabled() ? new DistinctJDBCTupleResultSet(set, (ImmutableSortedSet<Variable>)signature, (ImmutableMap<Variable, DBTermType>)typeMap, constructionNode, executableQuery.getProjectionAtom(), queryLogger, statementClosingCB, this.termFactory, this.substitutionFactory) : new JDBCTupleResultSet(set, (ImmutableSortedSet<Variable>)signature, (ImmutableMap<Variable, DBTermType>)typeMap, constructionNode, executableQuery.getProjectionAtom(), queryLogger, statementClosingCB, this.termFactory, this.substitutionFactory);
            }
            catch (SQLException e) {
                throw new OntopQueryEvaluationException((Exception)e);
            }
        }
        catch (EmptyQueryException e) {
            queryLogger.declareResultSetUnblockedAndSerialize();
            return new EmptyTupleResultSet((ImmutableList<Variable>)executableQuery.getProjectionAtom().getArguments(), queryLogger);
        }
    }

    protected GraphResultSet executeConstructQuery(ConstructTemplate constructTemplate, IQ executableQuery, QueryLogger queryLogger, boolean shouldAlsoCloseStatement) throws OntopQueryEvaluationException, OntopResultConversionException, OntopConnectionException {
        Object tuples;
        try {
            String sqlQuery = this.extractSQLQuery(executableQuery);
            ConstructionNode constructionNode = this.extractRootConstructionNode(executableQuery);
            NativeNode nativeNode = this.extractNativeNode(executableQuery);
            ImmutableSortedSet SQLSignature = nativeNode.getVariables();
            ImmutableMap SQLTypeMap = nativeNode.getTypeMap();
            OntopConnectionCloseable statementClosingCB = shouldAlsoCloseStatement ? this::close : null;
            try {
                ResultSet rs = this.sqlStatement.executeQuery(sqlQuery);
                queryLogger.declareResultSetUnblockedAndSerialize();
                tuples = new JDBCTupleResultSet(rs, (ImmutableSortedSet<Variable>)SQLSignature, (ImmutableMap<Variable, DBTermType>)SQLTypeMap, constructionNode, executableQuery.getProjectionAtom(), queryLogger, statementClosingCB, this.termFactory, this.substitutionFactory);
            }
            catch (SQLException e) {
                throw new OntopQueryEvaluationException(e.getMessage());
            }
        }
        catch (EmptyQueryException e) {
            queryLogger.declareResultSetUnblockedAndSerialize();
            tuples = new EmptyTupleResultSet((ImmutableList<Variable>)executableQuery.getProjectionAtom().getArguments(), queryLogger);
        }
        return new DefaultSimpleGraphResultSet((TupleResultSet)tuples, constructTemplate, this.termFactory, this.rdfFactory, this.settings.areInvalidTriplesExcludedFromResultSet());
    }

    private NativeNode extractNativeNode(IQ executableQuery) throws EmptyQueryException {
        IQTree tree = executableQuery.getTree();
        if (tree.isDeclaredAsEmpty()) {
            throw new EmptyQueryException();
        }
        return Optional.of(tree).filter(t -> t instanceof UnaryIQTree).map(t -> ((UnaryIQTree)t).getChild().getRootNode()).filter(n -> n instanceof NativeNode).map(n -> (NativeNode)n).orElseThrow(() -> new MinorOntopInternalBugException("The query does not have the expected structure for an executable query\n" + executableQuery));
    }

    private String extractSQLQuery(IQ executableQuery) throws EmptyQueryException, OntopInternalBugException {
        IQTree tree = executableQuery.getTree();
        if (tree.isDeclaredAsEmpty()) {
            throw new EmptyQueryException();
        }
        String queryString = Optional.of(tree).filter(t -> t instanceof UnaryIQTree).map(t -> ((UnaryIQTree)t).getChild().getRootNode()).filter(n -> n instanceof NativeNode).map(n -> (NativeNode)n).map(NativeNode::getNativeQueryString).orElseThrow(() -> new MinorOntopInternalBugException("The query does not have the expected structure of an executable query\n" + executableQuery));
        if (queryString.equals("")) {
            throw new EmptyQueryException();
        }
        return queryString;
    }

    private ConstructionNode extractRootConstructionNode(IQ executableQuery) throws EmptyQueryException, OntopInternalBugException {
        IQTree tree = executableQuery.getTree();
        if (tree.isDeclaredAsEmpty()) {
            throw new EmptyQueryException();
        }
        return Optional.of(tree.getRootNode()).filter(n -> n instanceof ConstructionNode).map(n -> (ConstructionNode)n).orElseThrow(() -> new MinorOntopInternalBugException("The \"executable\" query is not starting with a construction node\n" + executableQuery));
    }
}

