/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.answering.resultset.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.UnmodifiableIterator;
import it.unibz.inf.ontop.answering.logging.QueryLogger;
import it.unibz.inf.ontop.answering.resultset.TupleResultSet;
import it.unibz.inf.ontop.answering.resultset.impl.AbstractTupleResultSet;
import it.unibz.inf.ontop.answering.resultset.impl.SQLOntopBindingSet;
import it.unibz.inf.ontop.exception.OntopConnectionException;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.model.atom.DistinctVariableOnlyDataAtom;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.annotation.Nullable;

public class JDBCTupleResultSet
extends AbstractTupleResultSet
implements TupleResultSet {
    private final ImmutableSortedSet<Variable> sqlSignature;
    private final ImmutableMap<Variable, DBTermType> sqlTypeMap;
    private final ImmutableSubstitution<ImmutableTerm> sparqlVar2Term;
    private final SubstitutionFactory substitutionFactory;
    private final TermFactory termFactory;

    public JDBCTupleResultSet(ResultSet rs, ImmutableSortedSet<Variable> sqlSignature, ImmutableMap<Variable, DBTermType> sqlTypeMap, ConstructionNode constructionNode, DistinctVariableOnlyDataAtom answerAtom, QueryLogger queryLogger, TermFactory termFactory, SubstitutionFactory substitutionFactory) {
        super(rs, (ImmutableList<Variable>)answerAtom.getArguments(), queryLogger);
        this.sqlSignature = sqlSignature;
        this.sqlTypeMap = sqlTypeMap;
        this.substitutionFactory = substitutionFactory;
        this.termFactory = termFactory;
        this.sparqlVar2Term = constructionNode.getSubstitution();
    }

    @Override
    protected SQLOntopBindingSet readCurrentRow() throws OntopConnectionException {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        UnmodifiableIterator it = this.sqlSignature.iterator();
        try {
            for (int i = 1; i <= this.sqlSignature.size(); ++i) {
                Variable var = (Variable)it.next();
                builder.put((Object)var, (Object)this.convertToConstant(this.rs.getString(i), (DBTermType)this.sqlTypeMap.get((Object)var)));
            }
        }
        catch (SQLException e) {
            throw new OntopConnectionException((Exception)e);
        }
        return new SQLOntopBindingSet((ImmutableList<Variable>)this.signature, (ImmutableSubstitution<Constant>)this.substitutionFactory.getSubstitution(builder.build()), this.sparqlVar2Term);
    }

    private Constant convertToConstant(@Nullable String jdbcValue, DBTermType termType) {
        if (jdbcValue == null) {
            return this.termFactory.getNullConstant();
        }
        return this.termFactory.getDBConstant(jdbcValue, termType);
    }
}

