/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.answering.resultset.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import it.unibz.inf.ontop.answering.logging.QueryLogger;
import it.unibz.inf.ontop.answering.resultset.TupleResultSet;
import it.unibz.inf.ontop.answering.resultset.impl.JDBCTupleResultSet;
import it.unibz.inf.ontop.exception.OntopConnectionException;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.model.atom.DistinctVariableOnlyDataAtom;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DistinctJDBCTupleResultSet
extends JDBCTupleResultSet
implements TupleResultSet {
    private Set<List<Object>> rowKeys = new HashSet<List<Object>>();

    public DistinctJDBCTupleResultSet(ResultSet rs, ImmutableSortedSet<Variable> sqlSignature, ImmutableMap<Variable, DBTermType> sqlTypes, ConstructionNode constructionNode, DistinctVariableOnlyDataAtom answerAtom, QueryLogger queryLogger, TermFactory termFactory, SubstitutionFactory substitutionFactory) {
        super(rs, sqlSignature, sqlTypes, constructionNode, answerAtom, queryLogger, termFactory, substitutionFactory);
    }

    @Override
    protected boolean moveCursor() throws SQLException, OntopConnectionException {
        List<Object> currentKey;
        boolean foundFreshTuple;
        while ((foundFreshTuple = this.rs.next()) && !this.rowKeys.add(currentKey = this.computeTupleKey(this.rs))) {
        }
        return foundFreshTuple;
    }

    private List<Object> computeTupleKey(ResultSet rs) throws OntopConnectionException {
        ArrayList<Object> rowKey = new ArrayList<Object>();
        for (int i = 1; i <= this.getSignature().size(); ++i) {
            rowKey.add(this.getRawObject(i));
        }
        return rowKey;
    }

    Object getRawObject(int column) throws OntopConnectionException {
        try {
            Object realValue = this.rs.getObject(column);
            return realValue;
        }
        catch (Exception e) {
            throw new OntopConnectionException(e);
        }
    }
}

