/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.answering.resultset.impl;

import it.unibz.inf.ontop.answering.resultset.OntopBinding;
import it.unibz.inf.ontop.answering.resultset.OntopBindingSet;
import it.unibz.inf.ontop.answering.resultset.impl.AbstractOntopBindingSet;
import it.unibz.inf.ontop.answering.resultset.impl.OntopBindingImpl;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.Maps;
import it.unibz.inf.ontop.exception.OntopInternalBugException;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.RDFConstant;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class SQLOntopBindingSet
extends AbstractOntopBindingSet
implements OntopBindingSet {
    SQLOntopBindingSet(ImmutableList<Variable> signature, ImmutableSubstitution<Constant> sqlVar2Constant, ImmutableSubstitution<ImmutableTerm> sparqlVar2Term) {
        super(SQLOntopBindingSet.computeBindingMap(signature, sqlVar2Constant, sparqlVar2Term));
    }

    private static LinkedHashMap<String, OntopBinding> computeBindingMap(ImmutableList<Variable> signature, ImmutableSubstitution<Constant> sqlVar2Constant, ImmutableSubstitution<ImmutableTerm> sparqlVar2Term) {
        ImmutableSubstitution composition = sqlVar2Constant.composeWith(sparqlVar2Term);
        return signature.stream().map(v -> SQLOntopBindingSet.getBinding(v, (ImmutableSubstitution<ImmutableTerm>)composition)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
    }

    private static Optional<Map.Entry<String, OntopBinding>> getBinding(Variable v, ImmutableSubstitution<ImmutableTerm> composition) {
        Optional<RDFConstant> constant = SQLOntopBindingSet.evaluate(composition.apply((ImmutableTerm)v));
        return constant.map(rdfConstant -> Maps.immutableEntry((Object)v.getName(), (Object)new OntopBindingImpl(v, rdfConstant)));
    }

    private static Optional<RDFConstant> evaluate(ImmutableTerm term) {
        ImmutableTerm simplifiedTerm = term.simplify();
        if (simplifiedTerm instanceof Constant) {
            if (simplifiedTerm instanceof RDFConstant) {
                return Optional.of((RDFConstant)simplifiedTerm);
            }
            Constant constant = (Constant)simplifiedTerm;
            if (constant.isNull()) {
                return Optional.empty();
            }
            if (constant instanceof DBConstant) {
                throw new InvalidConstantTypeInResultException(constant + "is a DB constant. But a binding cannot have a DB constant as value");
            }
            throw new InvalidConstantTypeInResultException("Unexpected constant type for " + constant);
        }
        throw new InvalidTermAsResultException(simplifiedTerm);
    }

    public static class InvalidConstantTypeInResultException
    extends OntopInternalBugException {
        InvalidConstantTypeInResultException(String message) {
            super(message);
        }
    }

    public static class InvalidTermAsResultException
    extends OntopInternalBugException {
        InvalidTermAsResultException(ImmutableTerm term) {
            super("Term " + term + " does not evaluate to a constant");
        }
    }
}

