/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.answering.resultset.impl;

import it.unibz.inf.ontop.answering.logging.QueryLogger;
import it.unibz.inf.ontop.answering.resultset.BooleanResultSet;
import it.unibz.inf.ontop.exception.OntopConnectionException;
import java.sql.ResultSet;
import java.sql.SQLException;

public class SQLBooleanResultSet
implements BooleanResultSet {
    private final ResultSet set;
    private final QueryLogger queryLogger;
    private boolean hasRead;

    public SQLBooleanResultSet(ResultSet set, QueryLogger queryLogger) {
        this.set = set;
        this.queryLogger = queryLogger;
        this.hasRead = false;
    }

    public void close() throws OntopConnectionException {
        if (this.set == null) {
            return;
        }
        try {
            this.set.close();
        }
        catch (SQLException e) {
            throw new OntopConnectionException((Exception)e);
        }
    }

    public boolean getValue() throws OntopConnectionException {
        if (this.hasRead) {
            throw new IllegalStateException("getValue() can only called once!");
        }
        this.hasRead = true;
        this.queryLogger.declareLastResultRetrievedAndSerialize(1L);
        try {
            return this.set.next();
        }
        catch (SQLException e) {
            throw new OntopConnectionException((Exception)e);
        }
    }
}

