/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.injection.impl;

import it.unibz.inf.ontop.injection.OntopSQLCredentialSettings;
import it.unibz.inf.ontop.injection.OntopSystemSQLSettings;
import it.unibz.inf.ontop.injection.OntopSystemSettings;
import it.unibz.inf.ontop.injection.impl.OntopReformulationSQLSettingsImpl;
import it.unibz.inf.ontop.injection.impl.OntopSQLCredentialSettingsImpl;
import it.unibz.inf.ontop.injection.impl.OntopSystemSettingsImpl;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;

public class OntopSystemSQLSettingsImpl
extends OntopReformulationSQLSettingsImpl
implements OntopSystemSQLSettings {
    private static final String DEFAULT_FILE = "system-sql-default.properties";
    private final OntopSystemSettings systemSettings = new OntopSystemSettingsImpl(this.copyProperties());
    private final OntopSQLCredentialSettings sqlCredentialSettings = new OntopSQLCredentialSettingsImpl(this.copyProperties());

    OntopSystemSQLSettingsImpl(Properties userProperties) {
        super(OntopSystemSQLSettingsImpl.loadProperties(userProperties));
    }

    private static Properties loadProperties(Properties userProperties) {
        Properties properties = OntopSystemSQLSettingsImpl.loadDefaultSystemSQLProperties();
        properties.putAll((Map<?, ?>)userProperties);
        return properties;
    }

    static Properties loadDefaultSystemSQLProperties() {
        Properties properties = OntopSystemSettingsImpl.loadDefaultSystemProperties();
        properties.putAll((Map<?, ?>)OntopSystemSQLSettingsImpl.loadDefaultPropertiesFromFile(OntopSystemSQLSettings.class, (String)DEFAULT_FILE));
        return properties;
    }

    public boolean isDistinctPostProcessingEnabled() {
        return this.systemSettings.isDistinctPostProcessingEnabled();
    }

    @Override
    public boolean isKeepAliveEnabled() {
        return this.getRequiredBoolean("jdbc.pool.keepAlive");
    }

    @Override
    public boolean isRemoveAbandonedEnabled() {
        return this.getRequiredBoolean("jdbc.pool.removeAbandoned");
    }

    @Override
    public int getConnectionTimeout() {
        return this.getRequiredInteger("jdbc.pool.connectionTimeout");
    }

    @Override
    public int getConnectionPoolInitialSize() {
        return this.getRequiredInteger("jdbc.pool.initialSize");
    }

    @Override
    public int getConnectionPoolMaxSize() {
        return this.getRequiredInteger("jdbc.pool.maxSize");
    }

    public Optional<Integer> getDefaultQueryTimeout() {
        return this.getInteger("ontop.query.defaultTimeout");
    }

    public boolean isPermanentDBConnectionEnabled() {
        return this.systemSettings.isPermanentDBConnectionEnabled();
    }

    public String getJdbcUser() {
        return this.sqlCredentialSettings.getJdbcUser();
    }

    public String getJdbcPassword() {
        return this.sqlCredentialSettings.getJdbcPassword();
    }
}

