/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.injection.impl;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Module;
import it.unibz.inf.ontop.answering.reformulation.QueryReformulator;
import it.unibz.inf.ontop.answering.reformulation.input.InputQueryFactory;
import it.unibz.inf.ontop.exception.OBDASpecificationException;
import it.unibz.inf.ontop.injection.OntopMappingSQLAllSettings;
import it.unibz.inf.ontop.injection.OntopReformulationConfiguration;
import it.unibz.inf.ontop.injection.OntopReformulationSQLConfiguration;
import it.unibz.inf.ontop.injection.OntopStandaloneSQLConfiguration;
import it.unibz.inf.ontop.injection.OntopStandaloneSQLSettings;
import it.unibz.inf.ontop.injection.OntopSystemConfiguration;
import it.unibz.inf.ontop.injection.impl.DefaultOntopSystemBuilderFragment;
import it.unibz.inf.ontop.injection.impl.OntopMappingSQLAllConfigurationImpl;
import it.unibz.inf.ontop.injection.impl.OntopReformulationConfigurationImpl;
import it.unibz.inf.ontop.injection.impl.OntopReformulationSQLConfigurationImpl;
import it.unibz.inf.ontop.injection.impl.OntopSQLCredentialConfigurationImpl;
import it.unibz.inf.ontop.injection.impl.OntopStandaloneSQLSettingsImpl;
import it.unibz.inf.ontop.injection.impl.OntopSystemSQLConfigurationImpl;
import it.unibz.inf.ontop.iq.executor.ProposalExecutor;
import it.unibz.inf.ontop.iq.proposal.QueryOptimizationProposal;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Stream;

public class OntopStandaloneSQLConfigurationImpl
extends OntopMappingSQLAllConfigurationImpl
implements OntopStandaloneSQLConfiguration {
    private final OntopStandaloneSQLSettings settings;
    private final OntopSystemSQLConfigurationImpl systemConfiguration;

    OntopStandaloneSQLConfigurationImpl(OntopStandaloneSQLSettings settings, OntopStandaloneSQLOptions options) {
        super((OntopMappingSQLAllSettings)settings, options.mappingOptions);
        this.settings = settings;
        this.systemConfiguration = new OntopSystemSQLConfigurationImpl(settings, options.systemOptions, () -> ((OntopStandaloneSQLConfigurationImpl)this).loadOBDASpecification());
    }

    @Override
    public OntopStandaloneSQLSettings getSettings() {
        return this.settings;
    }

    public QueryReformulator loadQueryReformulator() throws OBDASpecificationException {
        return this.systemConfiguration.loadQueryReformulator();
    }

    public InputQueryFactory getInputQueryFactory() {
        return (InputQueryFactory)this.getInjector().getInstance(InputQueryFactory.class);
    }

    protected Stream<Module> buildGuiceModules() {
        return Stream.concat(super.buildGuiceModules(), this.systemConfiguration.buildGuiceModules());
    }

    protected ImmutableMap<Class<? extends QueryOptimizationProposal>, Class<? extends ProposalExecutor>> generateOptimizationConfigurationMap() {
        return (ImmutableMap)Stream.concat(super.generateOptimizationConfigurationMap().entrySet().stream(), this.systemConfiguration.generateOptimizationConfigurationMap().entrySet().stream()).distinct().collect(ImmutableCollectors.toMap());
    }

    public static final class BuilderImpl<B extends OntopStandaloneSQLConfiguration.Builder<B>>
    extends OntopStandaloneSQLBuilderMixin<B> {
        @Override
        public OntopStandaloneSQLConfiguration build() {
            OntopStandaloneSQLSettingsImpl settings = new OntopStandaloneSQLSettingsImpl(this.generateProperties(), this.isR2rml());
            OntopStandaloneSQLOptions options = this.generateStandaloneSQLOptions();
            return new OntopStandaloneSQLConfigurationImpl(settings, options);
        }
    }

    static abstract class OntopStandaloneSQLBuilderMixin<B extends OntopStandaloneSQLConfiguration.Builder<B>>
    extends OntopMappingSQLAllConfigurationImpl.OntopMappingSQLAllBuilderMixin<B>
    implements OntopStandaloneSQLConfiguration.Builder<B> {
        private final OntopReformulationSQLConfigurationImpl.DefaultOntopReformulationSQLBuilderFragment<B> sqlTranslationFragmentBuilder;
        private final OntopReformulationConfigurationImpl.DefaultOntopReformulationBuilderFragment<B> translationFragmentBuilder;
        private final DefaultOntopSystemBuilderFragment<B> systemFragmentBuilder;

        OntopStandaloneSQLBuilderMixin() {
            OntopStandaloneSQLBuilderMixin builder = this;
            this.sqlTranslationFragmentBuilder = new OntopReformulationSQLConfigurationImpl.DefaultOntopReformulationSQLBuilderFragment((OntopReformulationSQLConfiguration.Builder)builder);
            this.translationFragmentBuilder = new OntopReformulationConfigurationImpl.DefaultOntopReformulationBuilderFragment((OntopReformulationConfiguration.Builder)builder);
            this.systemFragmentBuilder = new DefaultOntopSystemBuilderFragment((OntopSystemConfiguration.Builder)builder);
        }

        public B enableExistentialReasoning(boolean enable) {
            return (B)((OntopStandaloneSQLConfiguration.Builder)this.translationFragmentBuilder.enableExistentialReasoning(enable));
        }

        public B keepPermanentDBConnection(boolean keep) {
            return (B)((OntopStandaloneSQLConfiguration.Builder)this.systemFragmentBuilder.keepPermanentDBConnection(keep));
        }

        protected Properties generateProperties() {
            Properties p = super.generateProperties();
            p.putAll((Map<?, ?>)this.systemFragmentBuilder.generateProperties());
            p.putAll((Map<?, ?>)this.sqlTranslationFragmentBuilder.generateProperties());
            p.putAll((Map<?, ?>)this.translationFragmentBuilder.generateProperties());
            return p;
        }

        final OntopStandaloneSQLOptions generateStandaloneSQLOptions() {
            OntopMappingSQLAllConfigurationImpl.OntopMappingSQLAllOptions sqlMappingOptions = this.generateMappingSQLAllOptions();
            OntopReformulationConfigurationImpl.OntopReformulationOptions translationOptions = this.translationFragmentBuilder.generateReformulationOptions(sqlMappingOptions.mappingSQLOptions.mappingOptions.obdaOptions, sqlMappingOptions.mappingSQLOptions.mappingOptions.optimizationOptions);
            OntopSQLCredentialConfigurationImpl.OntopSQLCredentialOptions sqlOptions = sqlMappingOptions.mappingSQLOptions.sqlOptions;
            OntopReformulationSQLConfigurationImpl.OntopReformulationSQLOptions sqlTranslationOptions = this.sqlTranslationFragmentBuilder.generateSQLReformulationOptions(translationOptions, sqlOptions.sqlCoreOptions);
            OntopSystemSQLConfigurationImpl.OntopSystemSQLOptions systemSQLOptions = new OntopSystemSQLConfigurationImpl.OntopSystemSQLOptions(sqlTranslationOptions, sqlOptions);
            return new OntopStandaloneSQLOptions(systemSQLOptions, sqlMappingOptions);
        }
    }

    static class OntopStandaloneSQLOptions {
        final OntopSystemSQLConfigurationImpl.OntopSystemSQLOptions systemOptions;
        final OntopMappingSQLAllConfigurationImpl.OntopMappingSQLAllOptions mappingOptions;

        OntopStandaloneSQLOptions(OntopSystemSQLConfigurationImpl.OntopSystemSQLOptions systemOptions, OntopMappingSQLAllConfigurationImpl.OntopMappingSQLAllOptions mappingOptions) {
            this.systemOptions = systemOptions;
            this.mappingOptions = mappingOptions;
        }
    }
}

