/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.answering.resultset.impl;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.answering.resultset.OntopBindingSet;
import it.unibz.inf.ontop.answering.resultset.TupleResultSet;
import it.unibz.inf.ontop.exception.OntopConnectionException;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.NoSuchElementException;

public abstract class AbstractTupleResultSet
implements TupleResultSet {
    protected final ResultSet rs;
    protected final ImmutableList<Variable> signature;
    private boolean lastCalledIsHasNext = false;
    private boolean foundNextElement = true;

    AbstractTupleResultSet(ResultSet rs, ImmutableList<Variable> signature) {
        this.rs = rs;
        this.signature = signature;
    }

    public int getColumnCount() {
        return this.signature.size();
    }

    public int getFetchSize() throws OntopConnectionException {
        try {
            return this.rs.getFetchSize();
        }
        catch (Exception e) {
            throw new OntopConnectionException(e.getMessage());
        }
    }

    public ImmutableList<String> getSignature() {
        return (ImmutableList)this.signature.stream().map(Variable::getName).collect(ImmutableCollectors.toList());
    }

    public OntopBindingSet next() throws OntopConnectionException {
        if (!this.lastCalledIsHasNext) {
            try {
                this.foundNextElement = this.moveCursor();
            }
            catch (Exception e) {
                throw new OntopConnectionException(e);
            }
        }
        this.lastCalledIsHasNext = false;
        if (!this.foundNextElement) {
            throw new NoSuchElementException("No next OntopBindingSet in this TupleResultSet");
        }
        return this.readCurrentRow();
    }

    public boolean hasNext() throws OntopConnectionException {
        if (!this.lastCalledIsHasNext) {
            this.lastCalledIsHasNext = true;
            try {
                this.foundNextElement = this.moveCursor();
            }
            catch (Exception e) {
                throw new OntopConnectionException(e);
            }
        }
        return this.foundNextElement;
    }

    protected boolean moveCursor() throws SQLException, OntopConnectionException {
        return this.rs.next();
    }

    public void close() throws OntopConnectionException {
        try {
            this.rs.close();
        }
        catch (Exception e) {
            throw new OntopConnectionException(e);
        }
    }

    protected abstract OntopBindingSet readCurrentRow() throws OntopConnectionException;
}

