/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.answering.connection.pool.impl;

import com.google.inject.Inject;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import it.unibz.inf.ontop.answering.connection.pool.JDBCConnectionPool;
import it.unibz.inf.ontop.injection.OntopSystemSQLSettings;
import java.sql.Connection;
import java.sql.SQLException;

public class HikariConnectionPool
implements JDBCConnectionPool {
    private final HikariDataSource ds;

    @Inject
    private HikariConnectionPool(OntopSystemSQLSettings settings) {
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl(settings.getJdbcUrl());
        config.setUsername(settings.getJdbcUser());
        config.setPassword(settings.getJdbcPassword());
        config.setDriverClassName(settings.getJdbcDriver());
        config.setMinimumIdle(settings.getConnectionPoolInitialSize());
        config.setMaximumPoolSize(settings.getConnectionPoolMaxSize());
        config.setConnectionTimeout((long)settings.getConnectionTimeout());
        config.setReadOnly(true);
        this.ds = new HikariDataSource(config);
    }

    @Override
    public void close() {
        this.ds.close();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.ds.getConnection();
    }
}

