/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.answering.connection.impl;

import it.unibz.inf.ontop.answering.connection.OntopConnection;
import it.unibz.inf.ontop.answering.connection.OntopStatement;
import it.unibz.inf.ontop.answering.connection.impl.JDBCConnector;
import it.unibz.inf.ontop.answering.connection.impl.SQLQuestStatement;
import it.unibz.inf.ontop.answering.reformulation.QueryReformulator;
import it.unibz.inf.ontop.answering.reformulation.input.InputQueryFactory;
import it.unibz.inf.ontop.dbschema.DBMetadata;
import it.unibz.inf.ontop.exception.OntopConnectionException;
import it.unibz.inf.ontop.injection.OntopSystemSQLSettings;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import java.sql.Connection;
import org.apache.commons.rdf.api.RDF;

public class SQLConnection
implements OntopConnection {
    private final QueryReformulator queryProcessor;
    private Connection conn;
    private final DBMetadata dbMetadata;
    private final InputQueryFactory inputQueryFactory;
    private final TermFactory termFactory;
    private final TypeFactory typeFactory;
    private final SubstitutionFactory substitutionFactory;
    private final OntopSystemSQLSettings settings;
    private final JDBCConnector jdbcConnector;
    private boolean isClosed;
    private final RDF rdfFactory;

    public SQLConnection(JDBCConnector jdbcConnector, QueryReformulator queryProcessor, Connection connection, DBMetadata dbMetadata, InputQueryFactory inputQueryFactory, TermFactory termFactory, TypeFactory typeFactory, RDF rdfFactory, SubstitutionFactory substitutionFactory, OntopSystemSQLSettings settings) {
        this.jdbcConnector = jdbcConnector;
        this.queryProcessor = queryProcessor;
        this.conn = connection;
        this.dbMetadata = dbMetadata;
        this.inputQueryFactory = inputQueryFactory;
        this.termFactory = termFactory;
        this.typeFactory = typeFactory;
        this.substitutionFactory = substitutionFactory;
        this.settings = settings;
        this.rdfFactory = rdfFactory;
        this.isClosed = false;
    }

    public void close() throws OntopConnectionException {
        try {
            this.conn.close();
        }
        catch (Exception e) {
            throw new OntopConnectionException(e);
        }
    }

    public OntopStatement createStatement() throws OntopConnectionException {
        try {
            if (this.conn.isClosed()) {
                this.conn = this.jdbcConnector.getSQLPoolConnection();
            }
            return new SQLQuestStatement(this.queryProcessor, this.conn.createStatement(1003, 1007), this.inputQueryFactory, this.termFactory, this.typeFactory, this.rdfFactory, this.substitutionFactory, this.settings);
        }
        catch (Exception e) {
            throw new OntopConnectionException(e);
        }
    }

    public InputQueryFactory getInputQueryFactory() {
        return this.queryProcessor.getInputQueryFactory();
    }

    public void commit() throws OntopConnectionException {
        try {
            this.conn.commit();
        }
        catch (Exception e) {
            throw new OntopConnectionException(e);
        }
    }

    public void setAutoCommit(boolean autocommit) throws OntopConnectionException {
        try {
            this.conn.setAutoCommit(autocommit);
        }
        catch (Exception e) {
            throw new OntopConnectionException(e);
        }
    }

    public boolean getAutoCommit() throws OntopConnectionException {
        try {
            return this.conn.getAutoCommit();
        }
        catch (Exception e) {
            throw new OntopConnectionException(e);
        }
    }

    public boolean isClosed() throws OntopConnectionException {
        try {
            this.isClosed = this.conn.isClosed();
            return this.isClosed;
        }
        catch (Exception e) {
            throw new OntopConnectionException(e);
        }
    }

    public void rollBack() throws OntopConnectionException {
        try {
            this.conn.rollback();
        }
        catch (Exception e) {
            throw new OntopConnectionException(e);
        }
    }
}

