/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.answering.connection.impl;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.answering.connection.DBConnector;
import it.unibz.inf.ontop.answering.connection.OntopConnection;
import it.unibz.inf.ontop.answering.connection.impl.SQLConnection;
import it.unibz.inf.ontop.answering.connection.pool.JDBCConnectionPool;
import it.unibz.inf.ontop.answering.reformulation.QueryReformulator;
import it.unibz.inf.ontop.answering.reformulation.input.InputQueryFactory;
import it.unibz.inf.ontop.dbschema.DBMetadata;
import it.unibz.inf.ontop.exception.OntopConnectionException;
import it.unibz.inf.ontop.injection.OntopSQLCredentialSettings;
import it.unibz.inf.ontop.injection.OntopSystemSQLSettings;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.LocalJDBCConnectionUtils;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.rdf.api.RDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCConnector
implements DBConnector {
    private final QueryReformulator queryReformulator;
    private final SubstitutionFactory substitutionFactory;
    private final OntopSystemSQLSettings settings;
    private transient Connection localConnection;
    private final Logger log = LoggerFactory.getLogger(JDBCConnector.class);
    private final JDBCConnectionPool connectionPool;
    private final DBMetadata dbMetadata;
    private final InputQueryFactory inputQueryFactory;
    private final TermFactory termFactory;
    private final TypeFactory typeFactory;
    private final RDF rdfFactory;

    @AssistedInject
    private JDBCConnector(@Assisted QueryReformulator queryReformulator, @Assisted DBMetadata dbMetadata, JDBCConnectionPool connectionPool, InputQueryFactory inputQueryFactory, TermFactory termFactory, TypeFactory typeFactory, SubstitutionFactory substitutionFactory, RDF rdfFactory, OntopSystemSQLSettings settings) {
        this.queryReformulator = queryReformulator;
        this.dbMetadata = dbMetadata;
        this.inputQueryFactory = inputQueryFactory;
        this.termFactory = termFactory;
        this.substitutionFactory = substitutionFactory;
        this.settings = settings;
        this.connectionPool = connectionPool;
        this.typeFactory = typeFactory;
        this.rdfFactory = rdfFactory;
    }

    public boolean connect() throws OntopConnectionException {
        try {
            if (this.localConnection != null && !this.localConnection.isClosed()) {
                return true;
            }
            if (this.settings.isPermanentDBConnectionEnabled()) {
                this.localConnection = LocalJDBCConnectionUtils.createConnection((OntopSQLCredentialSettings)this.settings);
                return this.localConnection != null;
            }
        }
        catch (SQLException e) {
            throw new OntopConnectionException((Exception)e);
        }
        return true;
    }

    public void close() {
        try {
            if (this.localConnection != null) {
                this.localConnection.close();
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
        }
        this.connectionPool.close();
    }

    public synchronized Connection getSQLPoolConnection() throws OntopConnectionException {
        try {
            return this.connectionPool.getConnection();
        }
        catch (SQLException e) {
            throw new OntopConnectionException((Exception)e);
        }
    }

    public OntopConnection getConnection() throws OntopConnectionException {
        return new SQLConnection(this, this.queryReformulator, this.getSQLPoolConnection(), this.dbMetadata, this.inputQueryFactory, this.termFactory, this.typeFactory, this.rdfFactory, this.substitutionFactory, this.settings);
    }
}

