/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.injection.impl;

import it.unibz.inf.ontop.injection.OntopOBDASettings;
import it.unibz.inf.ontop.injection.OntopSystemSettings;
import it.unibz.inf.ontop.injection.impl.OntopReformulationSettingsImpl;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class OntopSystemSettingsImpl
extends OntopReformulationSettingsImpl
implements OntopSystemSettings {
    private static final String DEFAULT_FILE = "system-default.properties";

    OntopSystemSettingsImpl(Properties userProperties) {
        super(OntopSystemSettingsImpl.loadProperties(userProperties));
    }

    private static Properties loadProperties(Properties userProperties) {
        Properties properties = OntopSystemSettingsImpl.loadDefaultSystemProperties();
        properties.putAll((Map<?, ?>)userProperties);
        return properties;
    }

    static Properties loadDefaultSystemProperties() {
        return OntopSystemSettingsImpl.loadDefaultPropertiesFromFile(OntopOBDASettings.class, (String)DEFAULT_FILE);
    }

    @Override
    public Optional<Integer> getDefaultQueryTimeout() {
        return this.getInteger("ontop.query.defaultTimeout");
    }

    @Override
    public boolean isPermanentDBConnectionEnabled() {
        return this.getRequiredBoolean("ontop.permanentConnection");
    }

    @Override
    public Optional<String> getHttpCacheControl() {
        String cacheControl = this.getProperty("ontop.http.cacheControl").orElseGet(() -> Stream.of(this.getInteger("ontop.http.cache.maxAge").map(i -> "max-age=" + i), this.getInteger("ontop.http.cache.staleWhileRevalidate").map(i -> "stale-while-revalidate=" + i), this.getInteger("ontop.http.cache.staleIfError").map(i -> "stale-if-error=" + i)).flatMap(e -> e.map(Stream::of).orElseGet(Stream::empty)).collect(Collectors.joining(", ")));
        return Optional.of(cacheControl).filter(s -> !s.isEmpty());
    }
}

