/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.answering.resultset.impl;

import it.unibz.inf.ontop.answering.reformulation.input.ConstructTemplate;
import it.unibz.inf.ontop.answering.resultset.GraphResultSet;
import it.unibz.inf.ontop.answering.resultset.OntopBindingSet;
import it.unibz.inf.ontop.answering.resultset.OntopCloseableIterator;
import it.unibz.inf.ontop.answering.resultset.TupleResultSet;
import it.unibz.inf.ontop.answering.resultset.impl.RDFFactCloseableIterator;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.exception.OntopConnectionException;
import it.unibz.inf.ontop.exception.OntopResultConversionException;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.IRIConstant;
import it.unibz.inf.ontop.model.term.ObjectConstant;
import it.unibz.inf.ontop.model.term.RDFConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.vocabulary.XSD;
import it.unibz.inf.ontop.spec.ontology.RDFFact;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Queue;
import org.apache.commons.rdf.api.RDF;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.query.algebra.BNodeGenerator;
import org.eclipse.rdf4j.query.algebra.Extension;
import org.eclipse.rdf4j.query.algebra.ExtensionElem;
import org.eclipse.rdf4j.query.algebra.ProjectionElem;
import org.eclipse.rdf4j.query.algebra.ProjectionElemList;
import org.eclipse.rdf4j.query.algebra.ValueConstant;
import org.eclipse.rdf4j.query.algebra.ValueExpr;

public class DefaultSimpleGraphResultSet
implements GraphResultSet {
    private final ResultSetIterator iterator;

    public DefaultSimpleGraphResultSet(TupleResultSet tupleResultSet, ConstructTemplate constructTemplate, TermFactory termFactory, RDF rdfFactory, boolean excludeInvalidTriples) {
        this.iterator = new ResultSetIterator(tupleResultSet, constructTemplate, termFactory, rdfFactory, excludeInvalidTriples);
    }

    public boolean hasNext() throws OntopConnectionException, OntopResultConversionException {
        return this.iterator.hasNext();
    }

    public RDFFact next() throws OntopConnectionException {
        return this.iterator.next();
    }

    public OntopCloseableIterator<RDFFact, OntopConnectionException> iterator() {
        return this.iterator;
    }

    public void close() throws OntopConnectionException {
        this.iterator.close();
    }

    private static class ResultSetIterator
    extends RDFFactCloseableIterator {
        private final TupleResultSet resultSet;
        private final ConstructTemplate constructTemplate;
        private final TermFactory termFactory;
        private final RDF rdfFactory;
        private final Queue<RDFFact> statementBuffer;
        private ImmutableMap<String, ValueExpr> extMap;
        private final boolean excludeInvalidTriples;

        private ResultSetIterator(TupleResultSet resultSet, ConstructTemplate constructTemplate, TermFactory termFactory, RDF rdfFactory, boolean excludeInvalidTriples) {
            this.resultSet = resultSet;
            this.constructTemplate = constructTemplate;
            this.termFactory = termFactory;
            this.rdfFactory = rdfFactory;
            this.excludeInvalidTriples = excludeInvalidTriples;
            this.intExtMap();
            this.statementBuffer = new LinkedList<RDFFact>();
        }

        public boolean hasNext() throws OntopConnectionException, OntopResultConversionException {
            boolean hasNext;
            if (this.statementBuffer.isEmpty() && this.resultSetHasNext()) {
                this.addStatementFromResultSet();
            }
            boolean bl = hasNext = !this.statementBuffer.isEmpty();
            if (!hasNext) {
                this.handleClose();
            }
            return hasNext;
        }

        public RDFFact next() throws OntopConnectionException {
            if (this.statementBuffer.isEmpty()) {
                this.handleClose();
            }
            return this.statementBuffer.remove();
        }

        public void handleClose() throws OntopConnectionException {
            try {
                if (this.resultSet.isConnectionAlive()) {
                    this.resultSet.close();
                }
            }
            catch (Exception e) {
                throw new OntopConnectionException(e);
            }
        }

        private void addStatementFromResultSet() throws OntopConnectionException, OntopResultConversionException {
            block4: {
                try {
                    OntopBindingSet bindingSet = (OntopBindingSet)this.resultSet.next();
                    for (ProjectionElemList peList : this.constructTemplate.getProjectionElemList()) {
                        int size = peList.getElements().size();
                        for (int i = 0; i < size / 3; ++i) {
                            ObjectConstant subjectConstant = (ObjectConstant)this.getConstant((ProjectionElem)peList.getElements().get(i * 3), bindingSet);
                            IRIConstant propertyConstant = (IRIConstant)this.getConstant((ProjectionElem)peList.getElements().get(i * 3 + 1), bindingSet);
                            RDFConstant objectConstant = (RDFConstant)this.getConstant((ProjectionElem)peList.getElements().get(i * 3 + 2), bindingSet);
                            if (subjectConstant == null || propertyConstant == null || objectConstant == null) continue;
                            this.statementBuffer.add(RDFFact.createTripleFact((ObjectConstant)subjectConstant, (IRIConstant)propertyConstant, (RDFConstant)objectConstant));
                        }
                    }
                }
                catch (OntopResultConversionException e) {
                    if (this.excludeInvalidTriples) break block4;
                    throw e;
                }
            }
        }

        private Constant getConstant(ProjectionElem node, OntopBindingSet bindingSet) throws OntopResultConversionException {
            Object constant = null;
            String nodeName = node.getSourceName();
            ValueExpr ve = null;
            if (this.extMap != null) {
                ve = (ValueExpr)this.extMap.get((Object)nodeName);
            }
            if (ve instanceof ValueConstant) {
                ValueConstant vc = (ValueConstant)ve;
                constant = vc.getValue() instanceof IRI ? this.termFactory.getConstantIRI(this.rdfFactory.createIRI(vc.getValue().stringValue())) : (vc.getValue() instanceof Literal ? this.termFactory.getRDFLiteralConstant(vc.getValue().stringValue(), XSD.STRING) : this.termFactory.getConstantBNode(vc.getValue().stringValue()));
            } else if (ve instanceof BNodeGenerator) {
                String rowId = bindingSet.getRowUUIDStr();
                String label = Optional.ofNullable(((BNodeGenerator)ve).getNodeIdExpr()).filter(e -> e instanceof ValueConstant).map(v -> ((ValueConstant)v).getValue().stringValue()).map(s -> s + rowId).orElseGet(() -> nodeName + rowId);
                constant = this.termFactory.getConstantBNode(label);
            } else {
                constant = bindingSet.getConstant(nodeName);
            }
            return constant;
        }

        private void intExtMap() {
            Extension ex = this.constructTemplate.getExtension();
            this.extMap = ex != null ? (ImmutableMap)ex.getElements().stream().collect(ImmutableCollectors.toMap(ExtensionElem::getName, ExtensionElem::getExpr)) : null;
        }

        private boolean resultSetHasNext() throws OntopConnectionException, OntopResultConversionException {
            if (!this.resultSet.isConnectionAlive()) {
                return false;
            }
            return this.resultSet.hasNext();
        }
    }
}

