/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.answering.resultset.impl;

import it.unibz.inf.ontop.answering.connection.impl.Evaluator;
import it.unibz.inf.ontop.answering.logging.QueryLogger;
import it.unibz.inf.ontop.answering.reformulation.input.ConstructQuery;
import it.unibz.inf.ontop.answering.reformulation.input.DescribeQuery;
import it.unibz.inf.ontop.answering.reformulation.input.InputQuery;
import it.unibz.inf.ontop.answering.reformulation.input.SelectQuery;
import it.unibz.inf.ontop.answering.resultset.GraphResultSet;
import it.unibz.inf.ontop.answering.resultset.OntopBinding;
import it.unibz.inf.ontop.answering.resultset.OntopBindingSet;
import it.unibz.inf.ontop.answering.resultset.OntopCloseableIterator;
import it.unibz.inf.ontop.answering.resultset.TupleResultSet;
import it.unibz.inf.ontop.answering.resultset.impl.OntopConnectionCloseable;
import it.unibz.inf.ontop.answering.resultset.impl.RDFFactCloseableIterator;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableCollection;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMultimap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.com.google.common.collect.UnmodifiableIterator;
import it.unibz.inf.ontop.exception.OntopConnectionException;
import it.unibz.inf.ontop.exception.OntopInvalidInputQueryException;
import it.unibz.inf.ontop.exception.OntopQueryAnsweringException;
import it.unibz.inf.ontop.exception.OntopQueryEvaluationException;
import it.unibz.inf.ontop.exception.OntopReformulationException;
import it.unibz.inf.ontop.exception.OntopResultConversionException;
import it.unibz.inf.ontop.model.term.IRIConstant;
import it.unibz.inf.ontop.model.term.RDFConstant;
import it.unibz.inf.ontop.spec.ontology.RDFFact;
import javax.annotation.Nullable;
import org.apache.commons.rdf.api.IRI;

public class DefaultDescribeGraphResultSet
implements GraphResultSet {
    private final ResultSetIterator iterator;

    public DefaultDescribeGraphResultSet(DescribeQuery describeQuery, QueryLogger queryLogger, QueryLogger.Factory queryLoggerFactory, Evaluator<TupleResultSet, SelectQuery> selectQueryEvaluator, Evaluator<GraphResultSet, ConstructQuery> constructQueryEvaluator, OntopConnectionCloseable statementClosingCB) throws OntopQueryEvaluationException, OntopConnectionException, OntopReformulationException, OntopResultConversionException {
        ImmutableSet<IRI> resourcesToDescribe = DefaultDescribeGraphResultSet.extractDescribeResources(describeQuery, queryLogger, queryLoggerFactory, selectQueryEvaluator);
        this.iterator = new ResultSetIterator((ImmutableCollection<ConstructQuery>)describeQuery.computeConstructQueries(resourcesToDescribe), queryLogger, queryLoggerFactory, constructQueryEvaluator, statementClosingCB);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ImmutableSet<IRI> extractDescribeResources(DescribeQuery inputQuery, QueryLogger queryLogger, QueryLogger.Factory queryLoggerFactory, Evaluator<TupleResultSet, SelectQuery> selectQueryEvaluator) throws OntopQueryEvaluationException, OntopConnectionException, OntopReformulationException, OntopResultConversionException {
        QueryLogger selectQueryLogger = queryLoggerFactory.create(ImmutableMultimap.of());
        try (TupleResultSet resultSet = selectQueryEvaluator.evaluate(inputQuery.getSelectQuery(), selectQueryLogger);){
            queryLogger.declareResultSetUnblockedAndSerialize();
            ImmutableSet.Builder iriSetBuilder = ImmutableSet.builder();
            while (resultSet.hasNext()) {
                OntopBindingSet bindingSet = (OntopBindingSet)resultSet.next();
                for (OntopBinding binding : bindingSet.getBindings()) {
                    RDFConstant value = binding.getValue();
                    if (!(value instanceof IRIConstant)) continue;
                    iriSetBuilder.add((Object)((IRIConstant)value).getIRI());
                }
            }
            ImmutableSet immutableSet = iriSetBuilder.build();
            return immutableSet;
        }
        catch (OntopInvalidInputQueryException e) {
            throw new OntopReformulationException((Exception)((Object)e));
        }
    }

    public boolean hasNext() throws OntopConnectionException, OntopQueryAnsweringException {
        return this.iterator.hasNext();
    }

    public RDFFact next() throws OntopQueryAnsweringException, OntopConnectionException {
        return this.iterator.next();
    }

    public OntopCloseableIterator<RDFFact, OntopConnectionException> iterator() {
        return this.iterator;
    }

    public void close() throws OntopConnectionException {
        this.iterator.close();
    }

    protected static class ResultSetIterator
    extends RDFFactCloseableIterator {
        private final UnmodifiableIterator<ConstructQuery> constructQueryIterator;
        private final OntopConnectionCloseable statementClosingCB;
        private final QueryLogger queryLogger;
        private final QueryLogger.Factory queryLoggerFactory;
        private final Evaluator<GraphResultSet, ConstructQuery> constructQueryEvaluator;
        private long rowCount;
        @Nullable
        private OntopCloseableIterator<RDFFact, OntopConnectionException> currentGraphResultSetIterator;

        public ResultSetIterator(ImmutableCollection<ConstructQuery> constructQueries, QueryLogger queryLogger, QueryLogger.Factory queryLoggerFactory, Evaluator<GraphResultSet, ConstructQuery> constructQueryEvaluator, OntopConnectionCloseable statementClosingCB) {
            this.constructQueryIterator = constructQueries.iterator();
            this.statementClosingCB = statementClosingCB;
            this.currentGraphResultSetIterator = null;
            this.queryLogger = queryLogger;
            this.queryLoggerFactory = queryLoggerFactory;
            this.constructQueryEvaluator = constructQueryEvaluator;
            this.rowCount = 0L;
        }

        public boolean hasNext() throws OntopConnectionException, OntopResultConversionException {
            while (true) {
                if (this.currentGraphResultSetIterator == null) {
                    if (this.constructQueryIterator.hasNext()) {
                        QueryLogger constructQueryLogger = this.queryLoggerFactory.create(ImmutableMultimap.of());
                        try {
                            GraphResultSet graphResultSet = this.constructQueryEvaluator.evaluate((ConstructQuery)((InputQuery)this.constructQueryIterator.next()), constructQueryLogger);
                            this.currentGraphResultSetIterator = graphResultSet.iterator();
                        }
                        catch (OntopQueryEvaluationException e) {
                            throw new LateQueryEvaluationExceptionWhenDescribing(e);
                        }
                        catch (OntopReformulationException e) {
                            throw new LateQueryReformulationExceptionWhenDescribing(e);
                        }
                    } else {
                        this.queryLogger.declareLastResultRetrievedAndSerialize(this.rowCount);
                        this.handleClose();
                        return false;
                    }
                }
                if (this.currentGraphResultSetIterator.hasNext()) {
                    ++this.rowCount;
                    return true;
                }
                this.currentGraphResultSetIterator.close();
                this.currentGraphResultSetIterator = null;
            }
        }

        public RDFFact next() throws OntopConnectionException {
            if (this.currentGraphResultSetIterator == null) {
                throw new IllegalStateException("Make sure to call hasNext() before calling next()");
            }
            return this.currentGraphResultSetIterator.next();
        }

        protected void handleClose() throws OntopConnectionException {
            if (this.currentGraphResultSetIterator != null) {
                this.currentGraphResultSetIterator.close();
            }
            this.statementClosingCB.close();
        }

        private static class LateQueryReformulationExceptionWhenDescribing
        extends OntopConnectionException {
            private LateQueryReformulationExceptionWhenDescribing(OntopReformulationException e) {
                super((Exception)e);
            }
        }

        private static class LateQueryEvaluationExceptionWhenDescribing
        extends OntopConnectionException {
            private LateQueryEvaluationExceptionWhenDescribing(OntopQueryEvaluationException e) {
                super((Exception)((Object)e));
            }
        }
    }
}

