/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.answering.connection.impl;

import it.unibz.inf.ontop.answering.connection.OntopStatement;
import it.unibz.inf.ontop.answering.connection.impl.Evaluator;
import it.unibz.inf.ontop.answering.logging.QueryLogger;
import it.unibz.inf.ontop.answering.reformulation.QueryReformulator;
import it.unibz.inf.ontop.answering.reformulation.input.AskQuery;
import it.unibz.inf.ontop.answering.reformulation.input.ConstructQuery;
import it.unibz.inf.ontop.answering.reformulation.input.ConstructTemplate;
import it.unibz.inf.ontop.answering.reformulation.input.DescribeQuery;
import it.unibz.inf.ontop.answering.reformulation.input.InputQuery;
import it.unibz.inf.ontop.answering.reformulation.input.SelectQuery;
import it.unibz.inf.ontop.answering.resultset.BooleanResultSet;
import it.unibz.inf.ontop.answering.resultset.GraphResultSet;
import it.unibz.inf.ontop.answering.resultset.OBDAResultSet;
import it.unibz.inf.ontop.answering.resultset.TupleResultSet;
import it.unibz.inf.ontop.answering.resultset.impl.DefaultDescribeGraphResultSet;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMultimap;
import it.unibz.inf.ontop.exception.OntopConnectionException;
import it.unibz.inf.ontop.exception.OntopQueryEvaluationException;
import it.unibz.inf.ontop.exception.OntopReformulationException;
import it.unibz.inf.ontop.exception.OntopResultConversionException;
import it.unibz.inf.ontop.exception.OntopUnsupportedInputQueryException;
import it.unibz.inf.ontop.iq.IQ;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QuestStatement
implements OntopStatement {
    private final QueryReformulator engine;
    private final QueryLogger.Factory queryLoggerFactory;
    private QueryExecutionThread executionThread;
    private boolean canceled = false;
    private static final Logger log = LoggerFactory.getLogger(QuestStatement.class);

    public QuestStatement(QueryReformulator queryProcessor) {
        this.engine = queryProcessor;
        this.queryLoggerFactory = queryProcessor.getQueryLoggerFactory();
    }

    private TupleResultSet executeSelectQuery(SelectQuery inputQuery, QueryLogger queryLogger) throws OntopQueryEvaluationException, OntopReformulationException {
        return this.executeSelectQuery(inputQuery, queryLogger, true);
    }

    private TupleResultSet executeSelectQuery(SelectQuery inputQuery, QueryLogger queryLogger, boolean shouldAlsoCloseStatement) throws OntopQueryEvaluationException, OntopReformulationException {
        IQ executableQuery = this.engine.reformulateIntoNativeQuery((InputQuery)inputQuery, queryLogger);
        this.logExecutionStartingMessage();
        return this.executeSelectQuery(executableQuery, queryLogger, shouldAlsoCloseStatement);
    }

    @Override
    public TupleResultSet executeSelectQuery(IQ executableQuery, QueryLogger queryLogger) throws OntopQueryEvaluationException {
        return this.executeSelectQuery(executableQuery, queryLogger, true);
    }

    protected abstract TupleResultSet executeSelectQuery(IQ var1, QueryLogger var2, boolean var3) throws OntopQueryEvaluationException;

    private BooleanResultSet executeBooleanQuery(AskQuery inputQuery, QueryLogger queryLogger) throws OntopQueryEvaluationException, OntopReformulationException {
        IQ executableQuery = this.engine.reformulateIntoNativeQuery((InputQuery)inputQuery, queryLogger);
        this.logExecutionStartingMessage();
        return this.executeBooleanQuery(executableQuery, queryLogger);
    }

    private GraphResultSet executeConstructQuery(ConstructQuery constructQuery, QueryLogger queryLogger) throws OntopQueryEvaluationException, OntopResultConversionException, OntopConnectionException, OntopReformulationException {
        return this.executeConstructQuery(constructQuery, queryLogger, true);
    }

    private GraphResultSet executeConstructQuery(ConstructQuery constructQuery, QueryLogger queryLogger, boolean shouldAlsoCloseStatement) throws OntopQueryEvaluationException, OntopResultConversionException, OntopConnectionException, OntopReformulationException {
        IQ executableQuery = this.engine.reformulateIntoNativeQuery((InputQuery)constructQuery, queryLogger);
        this.logExecutionStartingMessage();
        return this.executeConstructQuery(constructQuery.getConstructTemplate(), executableQuery, queryLogger, shouldAlsoCloseStatement);
    }

    @Override
    public GraphResultSet executeConstructQuery(ConstructTemplate constructTemplate, IQ executableQuery, QueryLogger queryLogger) throws OntopQueryEvaluationException, OntopResultConversionException, OntopConnectionException {
        return this.executeConstructQuery(constructTemplate, executableQuery, queryLogger, true);
    }

    protected abstract GraphResultSet executeConstructQuery(ConstructTemplate var1, IQ var2, QueryLogger var3, boolean var4) throws OntopQueryEvaluationException, OntopResultConversionException, OntopConnectionException;

    protected GraphResultSet executeDescribeQuery(DescribeQuery describeQuery, QueryLogger queryLogger) throws OntopQueryEvaluationException, OntopConnectionException, OntopReformulationException, OntopResultConversionException {
        return new DefaultDescribeGraphResultSet(describeQuery, queryLogger, this.queryLoggerFactory, (selectQuery, logger) -> this.executeSelectQuery((SelectQuery)selectQuery, logger, false), (constructQuery, logger) -> this.executeConstructQuery((ConstructQuery)constructQuery, logger, false), this::close);
    }

    private void logExecutionStartingMessage() {
        log.debug("Executing the query and get the result...");
    }

    protected abstract void cancelExecution() throws OntopQueryEvaluationException;

    @Override
    public <R extends OBDAResultSet> R execute(InputQuery<R> inputQuery) throws OntopConnectionException, OntopReformulationException, OntopQueryEvaluationException, OntopResultConversionException {
        return this.execute(inputQuery, (ImmutableMultimap<String, String>)ImmutableMultimap.of());
    }

    @Override
    public <R extends OBDAResultSet> R execute(InputQuery<R> inputQuery, ImmutableMultimap<String, String> httpHeaders) throws OntopConnectionException, OntopReformulationException, OntopQueryEvaluationException, OntopResultConversionException {
        if (inputQuery instanceof SelectQuery) {
            return (R)this.executeInThread((SelectQuery)inputQuery, httpHeaders, this::executeSelectQuery);
        }
        if (inputQuery instanceof AskQuery) {
            return (R)this.executeInThread((AskQuery)inputQuery, httpHeaders, this::executeBooleanQuery);
        }
        if (inputQuery instanceof DescribeQuery) {
            return (R)this.executeInThread((DescribeQuery)inputQuery, httpHeaders, this::executeDescribeQuery);
        }
        if (inputQuery instanceof ConstructQuery) {
            return (R)this.executeInThread((ConstructQuery)inputQuery, httpHeaders, this::executeConstructQuery);
        }
        throw new OntopUnsupportedInputQueryException("Unsupported query type: " + inputQuery);
    }

    private <R extends OBDAResultSet, Q extends InputQuery<R>> R executeInThread(Q inputQuery, ImmutableMultimap<String, String> httpHeaders, Evaluator<R, Q> evaluator) throws OntopReformulationException, OntopQueryEvaluationException {
        QueryExecutionThread executionthread;
        QueryLogger queryLogger = this.queryLoggerFactory.create(httpHeaders);
        queryLogger.setSparqlQuery(inputQuery.getInputString());
        CountDownLatch monitor = new CountDownLatch(1);
        this.executionThread = executionthread = new QueryExecutionThread(this, inputQuery, queryLogger, evaluator, monitor);
        executionthread.start();
        try {
            monitor.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (executionthread.errorStatus()) {
            Exception ex = executionthread.getException();
            if (ex instanceof OntopReformulationException) {
                throw (OntopReformulationException)ex;
            }
            if (ex instanceof OntopQueryEvaluationException) {
                queryLogger.declareEvaluationException(ex);
                throw (OntopQueryEvaluationException)((Object)ex);
            }
            queryLogger.declareEvaluationException(ex);
            throw new OntopQueryEvaluationException(ex);
        }
        if (this.canceled) {
            this.canceled = false;
            throw new OntopQueryEvaluationException("Query execution was cancelled");
        }
        Object resultSet = executionthread.getResultSet();
        return resultSet;
    }

    @Override
    public void cancel() throws OntopConnectionException {
        this.canceled = true;
        try {
            this.executionThread.cancel();
        }
        catch (Exception e) {
            throw new OntopConnectionException(e);
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public String getRewritingRendering(InputQuery query) throws OntopReformulationException {
        return this.engine.getRewritingRendering(query);
    }

    @Override
    public IQ getExecutableQuery(InputQuery inputQuery) throws OntopReformulationException {
        return this.engine.reformulateIntoNativeQuery(inputQuery, this.queryLoggerFactory.create(ImmutableMultimap.of()));
    }

    private static class QueryExecutionThread<R extends OBDAResultSet, Q extends InputQuery<R>>
    extends Thread {
        private final Q inputQuery;
        private final QueryLogger queryLogger;
        private final Evaluator<R, Q> evaluator;
        private final CountDownLatch monitor;
        private R resultSet;
        private Exception exception;
        private boolean executingTargetQuery;
        final /* synthetic */ QuestStatement this$0;

        QueryExecutionThread(Q inputQuery, QueryLogger queryLogger, Evaluator<R, Q> evaluator, CountDownLatch monitor) {
            this.this$0 = var1_1;
            this.inputQuery = inputQuery;
            this.queryLogger = queryLogger;
            this.evaluator = evaluator;
            this.monitor = monitor;
            this.exception = null;
            this.executingTargetQuery = false;
        }

        public boolean errorStatus() {
            return this.exception != null;
        }

        public Exception getException() {
            return this.exception;
        }

        public R getResultSet() {
            return this.resultSet;
        }

        public void cancel() throws OntopQueryEvaluationException {
            this.this$0.canceled = true;
            if (!this.executingTargetQuery) {
                this.stop();
            } else {
                this.this$0.cancelExecution();
            }
        }

        @Override
        public void run() {
            try {
                this.executingTargetQuery = true;
                this.resultSet = this.evaluator.evaluate(this.inputQuery, this.queryLogger);
                log.debug("Result set unblocked.\n");
            }
            catch (Exception e) {
                this.exception = e;
                log.error(e.getMessage(), (Throwable)e);
            }
            finally {
                this.monitor.countDown();
            }
        }
    }
}

