/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.materialization.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Injector;
import it.unibz.inf.ontop.answering.OntopQueryEngine;
import it.unibz.inf.ontop.answering.reformulation.input.InputQueryFactory;
import it.unibz.inf.ontop.answering.resultset.MaterializedGraphResultSet;
import it.unibz.inf.ontop.exception.OBDASpecificationException;
import it.unibz.inf.ontop.injection.OntopSystemConfiguration;
import it.unibz.inf.ontop.injection.OntopSystemFactory;
import it.unibz.inf.ontop.materialization.MaterializationParams;
import it.unibz.inf.ontop.materialization.OntopRDFMaterializer;
import it.unibz.inf.ontop.materialization.impl.DefaultMaterializedGraphResultSet;
import it.unibz.inf.ontop.materialization.impl.VocabularyEntry;
import it.unibz.inf.ontop.model.atom.QuadPredicate;
import it.unibz.inf.ontop.model.atom.RDFAtomPredicate;
import it.unibz.inf.ontop.model.atom.TriplePredicate;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.spec.OBDASpecification;
import it.unibz.inf.ontop.spec.mapping.Mapping;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.RDF;

public class DefaultOntopRDFMaterializer
implements OntopRDFMaterializer {
    private final MaterializationParams params;
    private final InputQueryFactory inputQueryFactory;
    private final OntopQueryEngine queryEngine;
    private final ImmutableMap<IRI, VocabularyEntry> vocabulary;
    private final TermFactory termFactory;
    private final RDF rdfFactory;

    public DefaultOntopRDFMaterializer(OntopSystemConfiguration configuration, MaterializationParams materializationParams) throws OBDASpecificationException {
        Injector injector = configuration.getInjector();
        OntopSystemFactory engineFactory = (OntopSystemFactory)injector.getInstance(OntopSystemFactory.class);
        OBDASpecification specification = configuration.loadSpecification();
        this.queryEngine = engineFactory.create(specification, configuration.getExecutorRegistry());
        this.inputQueryFactory = (InputQueryFactory)injector.getInstance(InputQueryFactory.class);
        this.termFactory = (TermFactory)injector.getInstance(TermFactory.class);
        this.rdfFactory = (RDF)injector.getInstance(RDF.class);
        this.vocabulary = DefaultOntopRDFMaterializer.extractVocabulary(specification.getSaturatedMapping());
        this.params = materializationParams;
    }

    @Override
    public MaterializedGraphResultSet materialize() {
        return new DefaultMaterializedGraphResultSet(this.vocabulary, this.params, this.queryEngine, this.inputQueryFactory, this.termFactory, this.rdfFactory);
    }

    @Override
    public MaterializedGraphResultSet materialize(@Nonnull ImmutableSet<IRI> selectedVocabulary) {
        return new DefaultMaterializedGraphResultSet(this.filterVocabularyEntries(selectedVocabulary), this.params, this.queryEngine, this.inputQueryFactory, this.termFactory, this.rdfFactory);
    }

    private ImmutableMap<IRI, VocabularyEntry> filterVocabularyEntries(ImmutableSet<IRI> selectedVocabulary) {
        return (ImmutableMap)this.vocabulary.entrySet().stream().filter(e -> selectedVocabulary.contains(e.getKey())).collect(ImmutableCollectors.toMap());
    }

    @Override
    public ImmutableSet<IRI> getClasses() {
        return (ImmutableSet)this.vocabulary.entrySet().stream().filter(e -> ((VocabularyEntry)e.getValue()).arity == 1).map(Map.Entry::getKey).collect(ImmutableCollectors.toSet());
    }

    @Override
    public ImmutableSet<IRI> getProperties() {
        return (ImmutableSet)this.vocabulary.entrySet().stream().filter(e -> ((VocabularyEntry)e.getValue()).arity == 2).map(Map.Entry::getKey).collect(ImmutableCollectors.toSet());
    }

    private static ImmutableMap<IRI, VocabularyEntry> extractVocabulary(@Nonnull Mapping mapping) {
        HashMap result = new HashMap();
        for (RDFAtomPredicate predicate : mapping.getRDFAtomPredicates()) {
            if (!(predicate instanceof TriplePredicate) && !(predicate instanceof QuadPredicate)) continue;
            result.putAll((Map)DefaultOntopRDFMaterializer.extractTripleVocabulary(mapping, predicate).collect(ImmutableCollectors.toMap(e -> e.name, e -> e)));
        }
        return ImmutableMap.copyOf(result);
    }

    private static Stream<VocabularyEntry> extractTripleVocabulary(Mapping mapping, RDFAtomPredicate tripleOrQuadPredicate) {
        Stream<VocabularyEntry> vocabularyPropertyStream = mapping.getRDFProperties(tripleOrQuadPredicate).stream().map(p -> new VocabularyEntry((IRI)p, 2));
        Stream<VocabularyEntry> vocabularyClassStream = mapping.getRDFClasses(tripleOrQuadPredicate).stream().map(p -> new VocabularyEntry((IRI)p, 1));
        return Stream.concat(vocabularyClassStream, vocabularyPropertyStream);
    }
}

