/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.answering.resultset.impl;

import com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.answering.reformulation.input.ConstructTemplate;
import it.unibz.inf.ontop.answering.resultset.OntopBindingSet;
import it.unibz.inf.ontop.answering.resultset.SimpleGraphResultSet;
import it.unibz.inf.ontop.answering.resultset.TupleResultSet;
import it.unibz.inf.ontop.exception.OntopConnectionException;
import it.unibz.inf.ontop.exception.OntopResultConversionException;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.ObjectConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.vocabulary.XSD;
import it.unibz.inf.ontop.spec.ontology.ABoxAssertionSupplier;
import it.unibz.inf.ontop.spec.ontology.Assertion;
import it.unibz.inf.ontop.spec.ontology.impl.OntologyBuilderImpl;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.apache.commons.rdf.api.RDF;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.query.algebra.BNodeGenerator;
import org.eclipse.rdf4j.query.algebra.Extension;
import org.eclipse.rdf4j.query.algebra.ExtensionElem;
import org.eclipse.rdf4j.query.algebra.ProjectionElem;
import org.eclipse.rdf4j.query.algebra.ProjectionElemList;
import org.eclipse.rdf4j.query.algebra.ValueConstant;
import org.eclipse.rdf4j.query.algebra.ValueExpr;

public class DefaultSimpleGraphResultSet
implements SimpleGraphResultSet {
    private final List<Assertion> results = new ArrayList<Assertion>();
    private final TupleResultSet tupleResultSet;
    private final ConstructTemplate constructTemplate;
    private final ImmutableMap<String, ValueExpr> extMap;
    private final boolean storeResults;
    private final TermFactory termFactory;
    private final RDF rdfFactory;
    ABoxAssertionSupplier builder;

    public DefaultSimpleGraphResultSet(TupleResultSet tupleResultSet, ConstructTemplate constructTemplate, boolean storeResults, TermFactory termFactory, RDF rdfFactory) throws OntopResultConversionException, OntopConnectionException {
        this.tupleResultSet = tupleResultSet;
        this.constructTemplate = constructTemplate;
        this.termFactory = termFactory;
        this.rdfFactory = rdfFactory;
        this.builder = OntologyBuilderImpl.assertionSupplier((RDF)this.rdfFactory);
        Extension ex = constructTemplate.getExtension();
        this.extMap = ex != null ? (ImmutableMap)ex.getElements().stream().collect(ImmutableCollectors.toMap(ExtensionElem::getName, ExtensionElem::getExpr)) : null;
        this.storeResults = storeResults;
        if (storeResults) {
            while (tupleResultSet.hasNext()) {
                this.results.addAll(this.processResults((OntopBindingSet)tupleResultSet.next()));
            }
        }
    }

    public int getFetchSize() throws OntopConnectionException {
        return this.tupleResultSet.getFetchSize();
    }

    public void addNewResult(Assertion assertion) {
        this.results.add(assertion);
    }

    private List<Assertion> processResults(OntopBindingSet bindingSet) throws OntopResultConversionException, OntopConnectionException {
        ArrayList<Assertion> tripleAssertions = new ArrayList<Assertion>();
        for (ProjectionElemList peList : this.constructTemplate.getProjectionElemList()) {
            int size = peList.getElements().size();
            for (int i = 0; i < size / 3; ++i) {
                Constant objectConstant;
                Constant predicateConstant;
                ObjectConstant subjectConstant = (ObjectConstant)this.getConstant((ProjectionElem)peList.getElements().get(i * 3), bindingSet);
                Assertion assertion = SimpleGraphResultSet.getAssertion((ABoxAssertionSupplier)this.builder, (ObjectConstant)subjectConstant, (Constant)(predicateConstant = this.getConstant((ProjectionElem)peList.getElements().get(i * 3 + 1), bindingSet)), (Constant)(objectConstant = this.getConstant((ProjectionElem)peList.getElements().get(i * 3 + 2), bindingSet)));
                if (assertion == null) continue;
                tripleAssertions.add(assertion);
            }
        }
        return tripleAssertions;
    }

    public boolean hasNext() throws OntopConnectionException, OntopResultConversionException {
        if (this.results.size() > 0) {
            return true;
        }
        if (this.storeResults) {
            return false;
        }
        while (this.tupleResultSet.hasNext()) {
            List<Assertion> newTriples = this.processResults((OntopBindingSet)this.tupleResultSet.next());
            if (newTriples.isEmpty()) continue;
            this.results.addAll(newTriples);
            return true;
        }
        return false;
    }

    public Assertion next() {
        if (this.results.size() > 0) {
            return this.results.remove(0);
        }
        throw new NoSuchElementException("Please call hasNext() before calling next()");
    }

    private Constant getConstant(ProjectionElem node, OntopBindingSet bindingSet) throws OntopResultConversionException, OntopConnectionException {
        Object constant = null;
        String node_name = node.getSourceName();
        ValueExpr ve = null;
        if (this.extMap != null) {
            ve = (ValueExpr)this.extMap.get((Object)node_name);
        }
        if (ve instanceof ValueConstant) {
            ValueConstant vc = (ValueConstant)ve;
            constant = vc.getValue() instanceof IRI ? this.termFactory.getConstantIRI(this.rdfFactory.createIRI(vc.getValue().stringValue())) : (vc.getValue() instanceof Literal ? this.termFactory.getRDFLiteralConstant(vc.getValue().stringValue(), XSD.STRING) : this.termFactory.getConstantBNode(vc.getValue().stringValue()));
        } else if (ve instanceof BNodeGenerator) {
            String rowId = bindingSet.getRowUUIDStr();
            String label = Optional.ofNullable(((BNodeGenerator)ve).getNodeIdExpr()).filter(e -> e instanceof ValueConstant).map(v -> ((ValueConstant)v).getValue().stringValue()).map(s -> s + rowId).orElseGet(() -> node_name + rowId);
            constant = this.termFactory.getConstantBNode(label);
        } else {
            constant = bindingSet.getConstant(node_name);
        }
        return constant;
    }

    public void close() throws OntopConnectionException {
        this.tupleResultSet.close();
    }
}

