/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.utils.querymanager;

import it.unibz.inf.ontop.utils.querymanager.QueryControllerEntity;
import it.unibz.inf.ontop.utils.querymanager.QueryControllerGroup;
import it.unibz.inf.ontop.utils.querymanager.QueryControllerListener;
import it.unibz.inf.ontop.utils.querymanager.QueryControllerQuery;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class QueryController
implements Serializable {
    private static final long serialVersionUID = 6456175226053526128L;
    private List<QueryControllerEntity> entities = new ArrayList<QueryControllerEntity>();
    private List<QueryControllerListener> listeners = new ArrayList<QueryControllerListener>();
    private boolean eventDisabled;

    public void addListener(QueryControllerListener listener) {
        if (this.listeners.contains(listener)) {
            return;
        }
        this.listeners.add(listener);
    }

    public void removeListener(QueryControllerListener listener) {
        this.listeners.remove(listener);
    }

    public void removeAllListeners() {
        this.listeners.clear();
    }

    public void createGroup(String groupId) throws Exception {
        if (this.getElementPosition(groupId) != -1) {
            throw new Exception("The name is already taken, either by a query group or a query item");
        }
        QueryControllerGroup group = new QueryControllerGroup(groupId);
        this.entities.add(group);
        this.fireElementAdded(group);
    }

    public QueryControllerGroup getGroup(String groupId) {
        int index = this.getElementPosition(groupId);
        if (index == -1) {
            return null;
        }
        QueryControllerGroup group = (QueryControllerGroup)this.entities.get(index);
        return group;
    }

    public List<QueryControllerGroup> getGroups() {
        ArrayList<QueryControllerGroup> groups = new ArrayList<QueryControllerGroup>();
        for (QueryControllerEntity element : this.entities) {
            if (!(element instanceof QueryControllerGroup)) continue;
            groups.add((QueryControllerGroup)element);
        }
        return groups;
    }

    public void removeGroup(String groupId) {
        for (QueryControllerEntity temporal : this.entities) {
            QueryControllerGroup group;
            QueryControllerGroup element;
            if (!(temporal instanceof QueryControllerGroup) || !((element = (QueryControllerGroup)temporal) instanceof QueryControllerGroup) || !(group = element).getID().equals(groupId)) continue;
            this.entities.remove(group);
            this.fireElementRemoved(group);
            return;
        }
    }

    public QueryControllerQuery addQuery(String queryStr, String queryId) {
        int position = this.getElementPosition(queryId);
        QueryControllerQuery query = new QueryControllerQuery(queryId);
        query.setQuery(queryStr);
        if (position == -1) {
            this.entities.add(query);
            this.fireElementAdded(query);
        } else {
            this.entities.set(position, query);
            this.fireElementChanged(query);
        }
        return query;
    }

    public QueryControllerQuery addQuery(String queryStr, String queryId, String groupId) {
        int position = this.getElementPosition(queryId);
        QueryControllerQuery query = new QueryControllerQuery(queryId);
        query.setQuery(queryStr);
        QueryControllerGroup group = this.getGroup(groupId);
        if (group == null) {
            group = new QueryControllerGroup(groupId);
            this.entities.add(group);
            this.fireElementAdded(group);
        }
        if (position == -1) {
            group.addQuery(query);
            this.fireElementAdded(query, group);
        } else {
            group.updateQuery(query);
            this.fireElementChanged(query, group);
        }
        return query;
    }

    public void removeAllQueriesAndGroups() {
        List<QueryControllerEntity> elements = this.getElements();
        for (QueryControllerEntity treeElement : elements) {
            this.fireElementRemoved(treeElement);
        }
        this.entities.clear();
    }

    public void removeQuery(String id) {
        int index = this.getElementPosition(id);
        QueryControllerEntity element = this.entities.get(index);
        if (element instanceof QueryControllerQuery) {
            this.entities.remove(index);
            this.fireElementRemoved(element);
            return;
        }
        QueryControllerGroup group = (QueryControllerGroup)element;
        Vector<QueryControllerQuery> queries_ingroup = group.getQueries();
        for (QueryControllerQuery query : queries_ingroup) {
            if (!query.getID().equals(id)) continue;
            this.fireElementRemoved(group.removeQuery(query.getID()), group);
            return;
        }
    }

    public int getElementPosition(String element_id) {
        int index = -1;
        block0: for (int i = 0; i < this.entities.size(); ++i) {
            QueryControllerQuery query;
            QueryControllerEntity element = this.entities.get(i);
            if (element instanceof QueryControllerQuery && (query = (QueryControllerQuery)element).getID().equals(element_id)) {
                index = i;
                break;
            }
            if (!(element instanceof QueryControllerGroup)) continue;
            QueryControllerGroup group = (QueryControllerGroup)element;
            if (group.getID().equals(element_id)) {
                index = i;
                break;
            }
            Vector<QueryControllerQuery> queries_ingroup = group.getQueries();
            for (QueryControllerQuery query2 : queries_ingroup) {
                if (!query2.getID().equals(element_id)) continue;
                index = i;
                continue block0;
            }
        }
        return index;
    }

    public List<QueryControllerEntity> getElements() {
        return this.entities;
    }

    public void fireElementAdded(QueryControllerEntity element) {
        if (!this.eventDisabled) {
            for (QueryControllerListener listener : this.listeners) {
                listener.elementAdded(element);
            }
        }
    }

    public void fireElementAdded(QueryControllerQuery query, QueryControllerGroup group) {
        if (!this.eventDisabled) {
            for (QueryControllerListener listener : this.listeners) {
                listener.elementAdded(query, group);
            }
        }
    }

    public void fireElementRemoved(QueryControllerEntity element) {
        if ((element instanceof QueryControllerGroup || element instanceof QueryControllerQuery) && !this.eventDisabled) {
            for (QueryControllerListener listener : this.listeners) {
                listener.elementRemoved(element);
            }
        }
    }

    public void fireElementRemoved(QueryControllerQuery query, QueryControllerGroup group) {
        if (!this.eventDisabled) {
            for (QueryControllerListener listener : this.listeners) {
                listener.elementRemoved(query, group);
            }
        }
    }

    public void fireElementChanged(QueryControllerQuery query) {
        if (!this.eventDisabled) {
            for (QueryControllerListener listener : this.listeners) {
                listener.elementChanged(query);
            }
        }
    }

    public void fireElementChanged(QueryControllerQuery query, QueryControllerGroup group) {
        if (!this.eventDisabled) {
            for (QueryControllerListener listener : this.listeners) {
                listener.elementChanged(query, group);
            }
        }
    }

    public void setEventsDisabled(boolean value) {
        this.eventDisabled = value;
    }

    public boolean getEventsDisabled() {
        return this.eventDisabled;
    }

    public void reset() {
        this.entities = new ArrayList<QueryControllerEntity>();
    }
}

