/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.answering.connection.impl;

import it.unibz.inf.ontop.answering.connection.OntopStatement;
import it.unibz.inf.ontop.answering.logging.QueryLogger;
import it.unibz.inf.ontop.answering.reformulation.QueryReformulator;
import it.unibz.inf.ontop.answering.reformulation.input.AskQuery;
import it.unibz.inf.ontop.answering.reformulation.input.ConstructQuery;
import it.unibz.inf.ontop.answering.reformulation.input.DescribeQuery;
import it.unibz.inf.ontop.answering.reformulation.input.InputQuery;
import it.unibz.inf.ontop.answering.reformulation.input.InputQueryFactory;
import it.unibz.inf.ontop.answering.reformulation.input.SPARQLQueryUtility;
import it.unibz.inf.ontop.answering.reformulation.input.SelectQuery;
import it.unibz.inf.ontop.answering.resultset.BooleanResultSet;
import it.unibz.inf.ontop.answering.resultset.OBDAResultSet;
import it.unibz.inf.ontop.answering.resultset.OntopBindingSet;
import it.unibz.inf.ontop.answering.resultset.SimpleGraphResultSet;
import it.unibz.inf.ontop.answering.resultset.TupleResultSet;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.exception.OntopConnectionException;
import it.unibz.inf.ontop.exception.OntopInvalidInputQueryException;
import it.unibz.inf.ontop.exception.OntopQueryEvaluationException;
import it.unibz.inf.ontop.exception.OntopReformulationException;
import it.unibz.inf.ontop.exception.OntopResultConversionException;
import it.unibz.inf.ontop.exception.OntopUnsupportedInputQueryException;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.IRIConstant;
import java.util.concurrent.CountDownLatch;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QuestStatement
implements OntopStatement {
    private final QueryReformulator engine;
    private final InputQueryFactory inputQueryFactory;
    private final QueryLogger.Factory queryLoggerFactory;
    private QueryExecutionThread executionThread;
    private boolean canceled = false;
    private static final Logger log = LoggerFactory.getLogger(QuestStatement.class);

    public QuestStatement(QueryReformulator queryProcessor, InputQueryFactory inputQueryFactory) {
        this.engine = queryProcessor;
        this.inputQueryFactory = inputQueryFactory;
        this.queryLoggerFactory = queryProcessor.getQueryLoggerFactory();
    }

    protected abstract TupleResultSet executeSelectQuery(IQ var1, QueryLogger var2) throws OntopQueryEvaluationException;

    private TupleResultSet executeSelectQuery(SelectQuery inputQuery, IQ executableQuery, QueryLogger queryLogger) throws OntopQueryEvaluationException {
        return this.executeSelectQuery(executableQuery, queryLogger);
    }

    protected abstract BooleanResultSet executeBooleanQuery(IQ var1, QueryLogger var2) throws OntopQueryEvaluationException;

    private BooleanResultSet executeBooleanQuery(AskQuery inputQuery, IQ executableQuery, QueryLogger queryLogger) throws OntopQueryEvaluationException {
        return this.executeBooleanQuery(executableQuery, queryLogger);
    }

    private SimpleGraphResultSet executeDescribeConstructQuery(ConstructQuery constructQuery, IQ executableQuery, QueryLogger queryLogger) throws OntopQueryEvaluationException, OntopResultConversionException, OntopConnectionException {
        return this.executeGraphQuery(constructQuery, executableQuery, true, queryLogger);
    }

    private SimpleGraphResultSet executeConstructQuery(ConstructQuery constructQuery, IQ executableQuery, QueryLogger queryLogger) throws OntopQueryEvaluationException, OntopResultConversionException, OntopConnectionException {
        return this.executeGraphQuery(constructQuery, executableQuery, false, queryLogger);
    }

    protected abstract SimpleGraphResultSet executeGraphQuery(ConstructQuery var1, IQ var2, boolean var3, QueryLogger var4) throws OntopQueryEvaluationException, OntopResultConversionException, OntopConnectionException;

    protected abstract void cancelExecution() throws OntopQueryEvaluationException;

    @Override
    public <R extends OBDAResultSet> R execute(InputQuery<R> inputQuery) throws OntopConnectionException, OntopReformulationException, OntopQueryEvaluationException, OntopResultConversionException {
        if (inputQuery instanceof SelectQuery) {
            return (R)this.executeInThread((SelectQuery)inputQuery, this::executeSelectQuery);
        }
        if (inputQuery instanceof AskQuery) {
            return (R)this.executeInThread((AskQuery)inputQuery, this::executeBooleanQuery);
        }
        if (inputQuery instanceof ConstructQuery) {
            return (R)this.executeInThread((ConstructQuery)inputQuery, this::executeConstructQuery);
        }
        if (inputQuery instanceof DescribeQuery) {
            return (R)this.executeDescribeQuery((DescribeQuery)inputQuery);
        }
        throw new OntopUnsupportedInputQueryException("Unsupported query type: " + inputQuery);
    }

    private SimpleGraphResultSet executeDescribeQuery(DescribeQuery inputQuery) throws OntopReformulationException, OntopResultConversionException, OntopConnectionException, OntopQueryEvaluationException {
        ImmutableSet<String> constants = this.extractDescribeQueryConstants(inputQuery);
        SimpleGraphResultSet describeResultSet = null;
        try {
            SimpleGraphResultSet set;
            ConstructQuery constructQuery;
            String str;
            for (String constant : constants) {
                str = SPARQLQueryUtility.getConstructSubjQuery((String)constant);
                constructQuery = this.inputQueryFactory.createConstructQuery(str);
                set = this.executeInThread(constructQuery, this::executeDescribeConstructQuery);
                if (describeResultSet == null) {
                    describeResultSet = set;
                    continue;
                }
                if (set == null) continue;
                while (set.hasNext()) {
                    describeResultSet.addNewResult(set.next());
                }
            }
            for (String constant : constants) {
                str = SPARQLQueryUtility.getConstructObjQuery((String)constant);
                constructQuery = this.inputQueryFactory.createConstructQuery(str);
                set = this.executeInThread(constructQuery, this::executeDescribeConstructQuery);
                if (describeResultSet == null) {
                    describeResultSet = set;
                    continue;
                }
                if (set == null) continue;
                while (set.hasNext()) {
                    describeResultSet.addNewResult(set.next());
                }
            }
        }
        catch (OntopInvalidInputQueryException e) {
            throw new OntopReformulationException((Exception)((Object)e));
        }
        return describeResultSet;
    }

    private ImmutableSet<String> extractDescribeQueryConstants(DescribeQuery inputQuery) throws OntopQueryEvaluationException, OntopConnectionException, OntopReformulationException, OntopResultConversionException {
        String inputQueryString = inputQuery.getInputString();
        if (SPARQLQueryUtility.isVarDescribe((String)inputQueryString)) {
            String sel = SPARQLQueryUtility.getSelectVarDescribe((String)inputQueryString);
            try {
                SelectQuery selectQuery = this.inputQueryFactory.createSelectQuery(sel);
                TupleResultSet resultSet = (TupleResultSet)this.execute((InputQuery)selectQuery);
                ImmutableSet.Builder constantSetBuilder = ImmutableSet.builder();
                while (resultSet.hasNext()) {
                    OntopBindingSet bindingSet = (OntopBindingSet)resultSet.next();
                    Constant constant = (Constant)bindingSet.getValues().get(0);
                    if (!(constant instanceof IRIConstant)) continue;
                    constantSetBuilder.add((Object)((IRIConstant)constant).getIRI().getIRIString());
                }
                return constantSetBuilder.build();
            }
            catch (OntopInvalidInputQueryException e) {
                throw new OntopReformulationException((Exception)((Object)e));
            }
        }
        if (SPARQLQueryUtility.isURIDescribe((String)inputQueryString)) {
            try {
                return ImmutableSet.of((Object)SPARQLQueryUtility.getDescribeURI((String)inputQueryString));
            }
            catch (MalformedQueryException e) {
                throw new OntopReformulationException((Exception)((Object)e));
            }
        }
        return ImmutableSet.of();
    }

    private <R extends OBDAResultSet, Q extends InputQuery<R>> R executeInThread(Q inputQuery, Evaluator<R, Q> evaluator) throws OntopReformulationException, OntopQueryEvaluationException {
        QueryExecutionThread executionthread;
        QueryLogger queryLogger = this.queryLoggerFactory.create();
        CountDownLatch monitor = new CountDownLatch(1);
        IQ executableQuery = this.engine.reformulateIntoNativeQuery(inputQuery, queryLogger);
        this.executionThread = executionthread = new QueryExecutionThread(this, inputQuery, executableQuery, queryLogger, evaluator, monitor);
        executionthread.start();
        try {
            monitor.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (executionthread.errorStatus()) {
            Exception ex = executionthread.getException();
            if (ex instanceof OntopReformulationException) {
                throw (OntopReformulationException)ex;
            }
            if (ex instanceof OntopQueryEvaluationException) {
                throw (OntopQueryEvaluationException)((Object)ex);
            }
            throw new OntopQueryEvaluationException(ex);
        }
        if (this.canceled) {
            this.canceled = false;
            throw new OntopQueryEvaluationException("Query execution was cancelled");
        }
        Object resultSet = executionthread.getResultSet();
        return resultSet;
    }

    @Override
    public void cancel() throws OntopConnectionException {
        this.canceled = true;
        try {
            this.executionThread.cancel();
        }
        catch (Exception e) {
            throw new OntopConnectionException(e);
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public String getRewritingRendering(InputQuery query) throws OntopReformulationException {
        return this.engine.getRewritingRendering(query);
    }

    @Override
    public IQ getExecutableQuery(InputQuery inputQuery) throws OntopReformulationException {
        return this.engine.reformulateIntoNativeQuery(inputQuery, this.queryLoggerFactory.create());
    }

    private static class QueryExecutionThread<R extends OBDAResultSet, Q extends InputQuery<R>>
    extends Thread {
        private final Q inputQuery;
        private final QueryLogger queryLogger;
        private final Evaluator<R, Q> evaluator;
        private final CountDownLatch monitor;
        private final IQ executableQuery;
        private R resultSet;
        private Exception exception;
        private boolean executingTargetQuery;
        final /* synthetic */ QuestStatement this$0;

        QueryExecutionThread(Q inputQuery, IQ executableQuery, QueryLogger queryLogger, Evaluator<R, Q> evaluator, CountDownLatch monitor) {
            this.this$0 = var1_1;
            this.executableQuery = executableQuery;
            this.inputQuery = inputQuery;
            this.queryLogger = queryLogger;
            this.evaluator = evaluator;
            this.monitor = monitor;
            this.exception = null;
            this.executingTargetQuery = false;
        }

        public boolean errorStatus() {
            return this.exception != null;
        }

        public Exception getException() {
            return this.exception;
        }

        public R getResultSet() {
            return this.resultSet;
        }

        public void cancel() throws OntopQueryEvaluationException {
            this.this$0.canceled = true;
            if (!this.executingTargetQuery) {
                this.stop();
            } else {
                this.this$0.cancelExecution();
            }
        }

        @Override
        public void run() {
            try {
                log.debug("Executing the query and get the result...");
                this.executingTargetQuery = true;
                this.resultSet = this.evaluator.evaluate(this.inputQuery, this.executableQuery, this.queryLogger);
                log.debug("Result set unblocked.\n");
            }
            catch (Exception e) {
                this.exception = e;
                log.error(e.getMessage(), (Throwable)e);
            }
            finally {
                this.monitor.countDown();
            }
        }
    }

    @FunctionalInterface
    private static interface Evaluator<R extends OBDAResultSet, Q extends InputQuery<R>> {
        public R evaluate(Q var1, IQ var2, QueryLogger var3) throws OntopQueryEvaluationException, OntopResultConversionException, OntopConnectionException;
    }
}

