/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.utils.querymanager;

import it.unibz.inf.ontop.utils.querymanager.QueryController;
import it.unibz.inf.ontop.utils.querymanager.QueryControllerEntity;
import it.unibz.inf.ontop.utils.querymanager.QueryControllerGroup;
import it.unibz.inf.ontop.utils.querymanager.QueryControllerQuery;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;

public class QueryIOManager {
    private static final String QUERY_GROUP = "QueryGroup";
    private static final String QUERY_ITEM = "QueryItem";
    private static final String QUERY_GROUP_TAG = "[QueryGroup=\"%s\"]";
    private static final String QUERY_ITEM_TAG = "[QueryItem=\"%s\"]";
    private static final String START_COLLECTION_SYMBOL = "@collection [[";
    private static final String END_COLLECTION_SYMBOL = "]]";
    private static final String COMMENT_SYMBOL = ";";
    private QueryController queryController;

    public QueryIOManager(QueryController controller) {
        this.queryController = controller;
    }

    public void save(String fileLocation) throws IOException {
        this.save(new File(fileLocation));
    }

    public void save(File file) throws IOException {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            boolean needLineBreakForGroup = false;
            boolean needLineBreakForItem = false;
            for (QueryControllerEntity entity : this.queryController.getElements()) {
                if (entity instanceof QueryControllerGroup) {
                    if (needLineBreakForGroup) {
                        writer.write("\n");
                    }
                    this.writeQueryGroup((QueryControllerGroup)entity, writer);
                    needLineBreakForGroup = true;
                    continue;
                }
                if (!(entity instanceof QueryControllerQuery)) continue;
                if (needLineBreakForItem) {
                    writer.write("\n");
                }
                this.writeQueryItem((QueryControllerQuery)entity, writer);
                needLineBreakForItem = true;
                needLineBreakForGroup = true;
            }
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            throw new IOException(String.format("Error while saving the queries to file located at %s.\nMake sure you have the write permission at the location specified.", file.getAbsolutePath()));
        }
    }

    public void load(String fileLocation) throws IOException {
        this.load(new File(fileLocation));
    }

    public void load(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        if (!file.canRead()) {
            throw new IOException(String.format("Error while reading the file located at %s.\nMake sure you have the read permission at the location specified.", file.getAbsolutePath()));
        }
        this.queryController.reset();
        LineNumberReader reader = new LineNumberReader(new FileReader(file));
        String line = "";
        while ((line = reader.readLine()) != null) {
            try {
                if (this.isCommentLine(line) || line.isEmpty()) continue;
                if (line.contains(QUERY_GROUP)) {
                    String groupId = line.substring(line.indexOf("\"") + 1, line.lastIndexOf("\""));
                    this.readQueryGroup(reader, groupId);
                    continue;
                }
                if (line.contains(QUERY_ITEM)) {
                    String queryId = line.substring(line.indexOf("\"") + 1, line.lastIndexOf("\""));
                    this.readQueryContent(reader, "", queryId);
                    continue;
                }
                throw new IOException("Unknown syntax: " + line);
            }
            catch (Exception e) {
                throw new IOException(String.format("Invalid syntax at line: %s", reader.getLineNumber()), e);
            }
        }
    }

    private void readQueryGroup(LineNumberReader reader, String groupId) throws IOException {
        String line = "";
        while (!(line = reader.readLine()).equals(END_COLLECTION_SYMBOL)) {
            if (this.isCommentLine(line) || line.isEmpty()) continue;
            if (line.contains(QUERY_ITEM)) {
                String queryId = line.substring(line.indexOf("\"") + 1, line.lastIndexOf("\""));
                this.readQueryContent(reader, groupId, queryId);
                continue;
            }
            throw new IOException(String.format("Invalid syntax at line: %s", reader.getLineNumber()));
        }
    }

    private void readQueryContent(LineNumberReader reader, String groupId, String queryId) throws IOException {
        if (queryId.isEmpty()) {
            throw new IOException("Query ID is missing");
        }
        StringBuffer buffer = new StringBuffer();
        String line = reader.readLine();
        while (!(line == null || line.contains(QUERY_ITEM) || line.contains(QUERY_GROUP) || line.contains(END_COLLECTION_SYMBOL))) {
            reader.mark(100000);
            buffer.append(line + "\n");
            line = reader.readLine();
        }
        reader.reset();
        String queryText = buffer.toString();
        this.addQueryItem(queryText, queryId, groupId);
    }

    private void writeQueryGroup(QueryControllerGroup group, BufferedWriter writer) throws IOException {
        writer.append(String.format(QUERY_GROUP_TAG, group.getID()) + " ");
        writer.append("@collection [[\n");
        boolean needLineBreak = false;
        for (QueryControllerQuery query : group.getQueries()) {
            if (needLineBreak) {
                writer.write("\n");
            }
            this.writeQueryItem(query, writer);
            needLineBreak = true;
        }
        writer.append(END_COLLECTION_SYMBOL);
        writer.append("\n");
    }

    private void writeQueryItem(QueryControllerQuery query, BufferedWriter writer) throws IOException {
        writer.append(String.format(QUERY_ITEM_TAG, query.getID()) + "\n");
        writer.append(query.getQuery().trim() + "\n");
    }

    private void addQueryItem(String queryText, String queryId, String groupId) {
        if (!groupId.isEmpty()) {
            this.queryController.addQuery(queryText, queryId, groupId);
        } else {
            this.queryController.addQuery(queryText, queryId);
        }
    }

    private boolean isCommentLine(String line) {
        return line.contains(COMMENT_SYMBOL) && line.trim().indexOf(COMMENT_SYMBOL) == 0;
    }
}

