/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.materialization.impl;

import it.unibz.inf.ontop.materialization.MaterializationParams;

public class MaterializationParamsImpl
implements MaterializationParams {
    private final boolean enableDBResultStreaming;
    private final boolean enableIncompleteMaterialization;

    private MaterializationParamsImpl(boolean enableDBResultStreaming, boolean enableIncompleteMaterialization) {
        this.enableDBResultStreaming = enableDBResultStreaming;
        this.enableIncompleteMaterialization = enableIncompleteMaterialization;
    }

    @Override
    public boolean isDBResultStreamingEnabled() {
        return this.enableDBResultStreaming;
    }

    @Override
    public boolean canMaterializationBeIncomplete() {
        return this.enableIncompleteMaterialization;
    }

    public static class DefaultBuilder<B extends MaterializationParams.Builder<B>>
    implements MaterializationParams.Builder<B> {
        private final B builder = this;
        private boolean isDBResultStreamingEnabled = false;
        private boolean canMaterializationBeIncomplete = false;

        @Override
        public B enableDBResultsStreaming(boolean enable) {
            this.isDBResultStreamingEnabled = enable;
            return this.builder;
        }

        @Override
        public B enableIncompleteMaterialization(boolean enable) {
            this.canMaterializationBeIncomplete = enable;
            return this.builder;
        }

        @Override
        public MaterializationParams build() {
            return new MaterializationParamsImpl(this.isDBResultStreamingEnabled, this.canMaterializationBeIncomplete);
        }
    }
}

