/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.materialization.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import com.google.inject.Injector;
import it.unibz.inf.ontop.answering.OntopQueryEngine;
import it.unibz.inf.ontop.answering.connection.OntopConnection;
import it.unibz.inf.ontop.answering.connection.OntopStatement;
import it.unibz.inf.ontop.answering.reformulation.input.ConstructQuery;
import it.unibz.inf.ontop.answering.reformulation.input.InputQueryFactory;
import it.unibz.inf.ontop.answering.resultset.MaterializedGraphResultSet;
import it.unibz.inf.ontop.answering.resultset.SimpleGraphResultSet;
import it.unibz.inf.ontop.exception.OBDASpecificationException;
import it.unibz.inf.ontop.exception.OntopConnectionException;
import it.unibz.inf.ontop.exception.OntopInternalBugException;
import it.unibz.inf.ontop.exception.OntopQueryAnsweringException;
import it.unibz.inf.ontop.exception.OntopResultConversionException;
import it.unibz.inf.ontop.injection.OntopSystemConfiguration;
import it.unibz.inf.ontop.injection.OntopSystemFactory;
import it.unibz.inf.ontop.materialization.MaterializationParams;
import it.unibz.inf.ontop.materialization.OntopRDFMaterializer;
import it.unibz.inf.ontop.model.atom.RDFAtomPredicate;
import it.unibz.inf.ontop.model.atom.TriplePredicate;
import it.unibz.inf.ontop.spec.OBDASpecification;
import it.unibz.inf.ontop.spec.mapping.Mapping;
import it.unibz.inf.ontop.spec.ontology.Assertion;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.rdf.api.IRI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOntopRDFMaterializer
implements OntopRDFMaterializer {
    private static int FETCH_SIZE = 50000;
    private final MaterializationParams params;
    private final InputQueryFactory inputQueryFactory;
    private final OntopQueryEngine queryEngine;
    private final ImmutableMap<IRI, VocabularyEntry> vocabulary;

    public DefaultOntopRDFMaterializer(OntopSystemConfiguration configuration, MaterializationParams materializationParams) throws OBDASpecificationException {
        Injector injector = configuration.getInjector();
        OntopSystemFactory engineFactory = (OntopSystemFactory)injector.getInstance(OntopSystemFactory.class);
        OBDASpecification specification = configuration.loadSpecification();
        this.queryEngine = engineFactory.create(specification, configuration.getExecutorRegistry());
        this.inputQueryFactory = (InputQueryFactory)injector.getInstance(InputQueryFactory.class);
        this.vocabulary = DefaultOntopRDFMaterializer.extractVocabulary(specification.getSaturatedMapping());
        this.params = materializationParams;
    }

    @Override
    public MaterializedGraphResultSet materialize() {
        return new DefaultMaterializedGraphResultSet(this.vocabulary, this.params, this.queryEngine, this.inputQueryFactory);
    }

    @Override
    public MaterializedGraphResultSet materialize(@Nonnull ImmutableSet<IRI> selectedVocabulary) {
        return new DefaultMaterializedGraphResultSet(this.filterVocabularyEntries(selectedVocabulary), this.params, this.queryEngine, this.inputQueryFactory);
    }

    private ImmutableMap<IRI, VocabularyEntry> filterVocabularyEntries(ImmutableSet<IRI> selectedVocabulary) {
        return (ImmutableMap)this.vocabulary.entrySet().stream().filter(e -> selectedVocabulary.contains(e.getKey())).collect(ImmutableCollectors.toMap());
    }

    @Override
    public ImmutableSet<IRI> getClasses() {
        return (ImmutableSet)this.vocabulary.entrySet().stream().filter(e -> ((VocabularyEntry)e.getValue()).arity == 1).map(Map.Entry::getKey).collect(ImmutableCollectors.toSet());
    }

    @Override
    public ImmutableSet<IRI> getProperties() {
        return (ImmutableSet)this.vocabulary.entrySet().stream().filter(e -> ((VocabularyEntry)e.getValue()).arity == 2).map(Map.Entry::getKey).collect(ImmutableCollectors.toSet());
    }

    private static ImmutableMap<IRI, VocabularyEntry> extractVocabulary(@Nonnull Mapping mapping) {
        return mapping.getRDFAtomPredicates().stream().filter(p -> p instanceof TriplePredicate).map(p -> (TriplePredicate)p).findFirst().map(p -> (ImmutableMap)DefaultOntopRDFMaterializer.extractTripleVocabulary(mapping, p).collect(ImmutableCollectors.toMap(e -> ((VocabularyEntry)e).name, e -> e))).orElseGet(ImmutableMap::of);
    }

    private static Stream<VocabularyEntry> extractTripleVocabulary(Mapping mapping, TriplePredicate triplePredicate) {
        Stream<VocabularyEntry> vocabularyPropertyStream = mapping.getRDFProperties((RDFAtomPredicate)triplePredicate).stream().map(p -> new VocabularyEntry((IRI)p, 2));
        Stream<VocabularyEntry> vocabularyClassStream = mapping.getRDFClasses((RDFAtomPredicate)triplePredicate).stream().map(p -> new VocabularyEntry((IRI)p, 1));
        return Stream.concat(vocabularyClassStream, vocabularyPropertyStream);
    }

    private static class NonURIPredicateInVocabularyException
    extends OntopInternalBugException {
        NonURIPredicateInVocabularyException(String vocabularyPredicate) {
            super("A non-URI predicate has been found in the vocabulary: " + vocabularyPredicate);
        }
    }

    private static class DefaultMaterializedGraphResultSet
    implements MaterializedGraphResultSet {
        private final ImmutableMap<IRI, VocabularyEntry> vocabulary;
        private final InputQueryFactory inputQueryFactory;
        private final boolean doStreamResults;
        private final boolean canBeIncomplete;
        private final OntopQueryEngine queryEngine;
        private final UnmodifiableIterator<VocabularyEntry> vocabularyIterator;
        private int counter;
        @Nullable
        private OntopConnection ontopConnection;
        @Nullable
        private OntopStatement tmpStatement;
        @Nullable
        private SimpleGraphResultSet tmpGraphResultSet;
        @Nullable
        private Logger LOGGER = LoggerFactory.getLogger(DefaultMaterializedGraphResultSet.class);
        private final List<IRI> possiblyIncompleteClassesAndProperties;

        DefaultMaterializedGraphResultSet(ImmutableMap<IRI, VocabularyEntry> vocabulary, MaterializationParams params, OntopQueryEngine queryEngine, InputQueryFactory inputQueryFactory) {
            this.vocabulary = vocabulary;
            this.vocabularyIterator = vocabulary.values().iterator();
            this.queryEngine = queryEngine;
            this.doStreamResults = params.isDBResultStreamingEnabled();
            this.canBeIncomplete = params.canMaterializationBeIncomplete();
            this.inputQueryFactory = inputQueryFactory;
            this.possiblyIncompleteClassesAndProperties = new ArrayList<IRI>();
            if (this.doStreamResults) {
                // empty if block
            }
            this.counter = 0;
            this.ontopConnection = null;
            this.tmpStatement = null;
            this.tmpGraphResultSet = null;
        }

        @Override
        public ImmutableSet<IRI> getSelectedVocabulary() {
            return this.vocabulary.keySet();
        }

        public boolean hasNext() throws OntopQueryAnsweringException, OntopConnectionException {
            if (this.ontopConnection == null) {
                this.ontopConnection = this.queryEngine.getConnection();
            }
            if (this.tmpGraphResultSet != null && this.tmpGraphResultSet.hasNext()) {
                return true;
            }
            while (this.vocabularyIterator.hasNext()) {
                if (this.tmpGraphResultSet != null) {
                    try {
                        this.tmpGraphResultSet.close();
                    }
                    catch (OntopConnectionException e) {
                        this.LOGGER.warn("Non-critical exception while closing the graph result set: " + (Object)((Object)e));
                    }
                }
                if (this.tmpStatement != null) {
                    try {
                        this.tmpStatement.close();
                    }
                    catch (OntopConnectionException e) {
                        this.LOGGER.warn("Non-critical exception while closing the statement: " + (Object)((Object)e));
                    }
                }
                VocabularyEntry predicate = (VocabularyEntry)this.vocabularyIterator.next();
                ConstructQuery query = this.inputQueryFactory.createConstructQuery(predicate.getQuery());
                try {
                    this.tmpStatement = this.ontopConnection.createStatement();
                    if (this.doStreamResults) {
                        this.tmpStatement.setFetchSize(FETCH_SIZE);
                    }
                    this.tmpGraphResultSet = (SimpleGraphResultSet)this.tmpStatement.execute(query);
                    if (!this.tmpGraphResultSet.hasNext()) continue;
                    return true;
                }
                catch (OntopConnectionException | OntopQueryAnsweringException e) {
                    if (this.canBeIncomplete) {
                        this.LOGGER.warn("Possibly incomplete class/property " + predicate + " (materialization problem).\nDetails: " + e);
                        this.possiblyIncompleteClassesAndProperties.add(predicate.name);
                        continue;
                    }
                    this.LOGGER.error("Problem materialiing the class/property " + predicate);
                    throw e;
                }
            }
            return false;
        }

        public Assertion next() throws OntopQueryAnsweringException {
            ++this.counter;
            try {
                return this.tmpGraphResultSet.next();
            }
            catch (OntopResultConversionException e) {
                throw new OntopQueryAnsweringException((Exception)((Object)e));
            }
        }

        public void close() throws OntopConnectionException {
            if (this.tmpStatement != null) {
                this.tmpStatement.close();
            }
            if (this.ontopConnection != null) {
                this.ontopConnection.close();
            }
        }

        @Override
        public long getTripleCountSoFar() {
            return this.counter;
        }

        @Override
        public ImmutableList<IRI> getPossiblyIncompleteRDFPropertiesAndClassesSoFar() {
            return ImmutableList.copyOf(this.possiblyIncompleteClassesAndProperties);
        }
    }

    private static final class VocabularyEntry {
        private final IRI name;
        private final int arity;
        private static final String PROPERTY_QUERY = "CONSTRUCT {?s <%s> ?o} WHERE {?s <%s> ?o}";
        private static final String CLASS_QUERY = "CONSTRUCT {?s a <%s>} WHERE {?s a <%s>}";

        VocabularyEntry(IRI predicate, int arity) {
            this.name = predicate;
            this.arity = arity;
        }

        String getQuery() {
            return String.format(this.arity == 1 ? CLASS_QUERY : PROPERTY_QUERY, this.name.getIRIString(), this.name.getIRIString());
        }
    }
}

