/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.test.sparql;

import it.unibz.inf.ontop.injection.OntopSystemConfiguration;
import it.unibz.inf.ontop.rdf4j.repository.OntopRepository;
import it.unibz.inf.ontop.rdf4j.repository.impl.OntopVirtualRepository;
import it.unibz.inf.ontop.si.OntopSemanticIndexLoader;
import it.unibz.inf.ontop.si.SemanticIndexException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.rdf4j.common.io.IOUtil;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.common.text.StringUtil;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.util.Models;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.BooleanQuery;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.Query;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.QueryResultHandler;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.dawg.DAWGTestResultSetUtil;
import org.eclipse.rdf4j.query.impl.MutableTupleQueryResult;
import org.eclipse.rdf4j.query.impl.TupleQueryResultBuilder;
import org.eclipse.rdf4j.query.resultio.BooleanQueryResultParserRegistry;
import org.eclipse.rdf4j.query.resultio.QueryResultFormat;
import org.eclipse.rdf4j.query.resultio.QueryResultIO;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultParser;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.rio.ParserConfig;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;
import org.eclipse.rdf4j.rio.helpers.StatementCollector;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryTestExecutor {
    static final Logger logger = LoggerFactory.getLogger(MemoryTestExecutor.class);
    protected final String testIRI;
    private final String name;
    protected final String queryFileURL;
    protected final String resultFileURL;
    protected final Dataset dataset;
    protected final boolean laxCardinality;
    protected final boolean checkOrder;

    public MemoryTestExecutor(String testIRI, String name, String queryFileURL, String resultFileURL, Dataset dataSet, boolean laxCardinality, boolean checkOrder) {
        this.testIRI = testIRI;
        this.name = name;
        this.queryFileURL = queryFileURL;
        this.resultFileURL = resultFileURL;
        this.dataset = dataSet;
        this.laxCardinality = laxCardinality;
        this.checkOrder = checkOrder;
    }

    private OntopRepository createRepository() throws RepositoryException, SemanticIndexException {
        try (OntopSemanticIndexLoader loader = OntopSemanticIndexLoader.loadRDFGraph((Dataset)this.dataset, (Properties)new Properties());){
            OntopVirtualRepository repository = OntopRepository.defaultRepository((OntopSystemConfiguration)loader.getConfiguration());
            repository.initialize();
            OntopVirtualRepository ontopVirtualRepository = repository;
            return ontopVirtualRepository;
        }
    }

    public void runTest() throws Exception {
        block27: {
            try (OntopRepository dataRep = this.createRepository();
                 RepositoryConnection con = dataRep.getConnection();){
                String queryString = this.readQueryString();
                Query query = con.prepareQuery(QueryLanguage.SPARQL, queryString, this.queryFileURL);
                if (query instanceof TupleQuery) {
                    TupleQueryResult queryResult = ((TupleQuery)query).evaluate();
                    TupleQueryResult expectedResult = this.readExpectedTupleQueryResult((Repository)dataRep);
                    this.compareTupleQueryResults(queryResult, expectedResult);
                    break block27;
                }
                if (query instanceof GraphQuery) {
                    GraphQueryResult gqr = ((GraphQuery)query).evaluate();
                    Set queryResult = Iterations.asSet((Iteration)gqr);
                    Set<Statement> expectedResult = this.readExpectedGraphQueryResult((Repository)dataRep);
                    this.compareGraphs(queryResult, expectedResult);
                    break block27;
                }
                if (query instanceof BooleanQuery) {
                    boolean queryResult = ((BooleanQuery)query).evaluate();
                    boolean expectedResult = this.readExpectedBooleanQueryResult((Repository)dataRep);
                    Assert.assertEquals((Object)expectedResult, (Object)queryResult);
                    break block27;
                }
                throw new RuntimeException("Unexpected query type: " + query.getClass());
            }
        }
    }

    private void compareTupleQueryResults(TupleQueryResult queryResult, TupleQueryResult expectedResult) throws Exception {
        boolean resultsEqual;
        MutableTupleQueryResult queryResultTable = new MutableTupleQueryResult(queryResult);
        MutableTupleQueryResult expectedResultTable = new MutableTupleQueryResult(expectedResult);
        if (this.laxCardinality) {
            resultsEqual = MemoryTestExecutor.isSubset((TupleQueryResult)queryResultTable, (TupleQueryResult)expectedResultTable);
        } else {
            resultsEqual = MemoryTestExecutor.equals((TupleQueryResult)queryResultTable, (TupleQueryResult)expectedResultTable);
            if (this.checkOrder) {
                queryResultTable.beforeFirst();
                expectedResultTable.beforeFirst();
                while (queryResultTable.hasNext()) {
                    BindingSet expectedBs;
                    BindingSet bs = queryResultTable.next();
                    if (bs.equals((Object)(expectedBs = expectedResultTable.next()))) continue;
                    resultsEqual = false;
                    break;
                }
            }
        }
        if (!resultsEqual) {
            queryResultTable.beforeFirst();
            expectedResultTable.beforeFirst();
            List queryBindings = Iterations.asList((Iteration)queryResultTable);
            List expectedBindings = Iterations.asList((Iteration)expectedResultTable);
            ArrayList missingBindings = new ArrayList(expectedBindings);
            missingBindings.removeAll(queryBindings);
            ArrayList unexpectedBindings = new ArrayList(queryBindings);
            unexpectedBindings.removeAll(expectedBindings);
            StringBuilder message = new StringBuilder(128);
            message.append("\n============ ");
            message.append(this.getName());
            message.append(" =======================\n");
            if (!missingBindings.isEmpty()) {
                message.append("Missing bindings: \n");
                for (BindingSet bs : missingBindings) {
                    message.append(bs);
                    message.append("\n");
                }
                message.append("=============");
                StringUtil.appendN((char)'=', (int)this.getName().length(), (StringBuilder)message);
                message.append("========================\n");
            }
            if (!unexpectedBindings.isEmpty()) {
                message.append("Unexpected bindings: \n");
                for (BindingSet bs : unexpectedBindings) {
                    message.append(bs);
                    message.append("\n");
                }
                message.append("=============");
                StringUtil.appendN((char)'=', (int)this.getName().length(), (StringBuilder)message);
                message.append("========================\n");
            }
            if (this.checkOrder && missingBindings.isEmpty() && unexpectedBindings.isEmpty()) {
                message.append("Results are not in expected order.\n");
                message.append(" =======================\n");
                message.append("query result: \n");
                for (BindingSet bs : queryBindings) {
                    message.append(bs);
                    message.append("\n");
                }
                message.append(" =======================\n");
                message.append("expected result: \n");
                for (BindingSet bs : expectedBindings) {
                    message.append(bs);
                    message.append("\n");
                }
                message.append(" =======================\n");
            }
            logger.error(message.toString());
            Assert.fail((String)message.toString());
        }
    }

    public static boolean equals(TupleQueryResult tqr1, TupleQueryResult tqr2) throws QueryEvaluationException {
        List list2;
        List list1 = Iterations.asList((Iteration)tqr1);
        return MemoryTestExecutor.matchBindingSets(list1, list2 = Iterations.asList((Iteration)tqr2)) && MemoryTestExecutor.matchBindingSets(list2, list1);
    }

    public static boolean isSubset(TupleQueryResult tqr1, TupleQueryResult tqr2) throws QueryEvaluationException {
        List list1 = Iterations.asList((Iteration)tqr1);
        List list2 = Iterations.asList((Iteration)tqr2);
        return MemoryTestExecutor.matchBindingSets(list1, list2);
    }

    private static boolean matchBindingSets(List<? extends BindingSet> queryResult1, Iterable<? extends BindingSet> queryResult2) {
        return MemoryTestExecutor.matchBindingSets(queryResult1, queryResult2, new HashMap<BNode, BNode>(), 0);
    }

    private static boolean matchBindingSets(List<? extends BindingSet> queryResult1, Iterable<? extends BindingSet> queryResult2, Map<BNode, BNode> bNodeMapping, int idx) {
        boolean result = false;
        if (idx < queryResult1.size()) {
            BindingSet bs1 = queryResult1.get(idx);
            List<BindingSet> matchingBindingSets = MemoryTestExecutor.findMatchingBindingSets(bs1, queryResult2, bNodeMapping);
            for (BindingSet bs2 : matchingBindingSets) {
                HashMap<BNode, BNode> newBNodeMapping = new HashMap<BNode, BNode>(bNodeMapping);
                for (Binding binding : bs1) {
                    if (!(binding.getValue() instanceof BNode)) continue;
                    newBNodeMapping.put((BNode)binding.getValue(), (BNode)bs2.getValue(binding.getName()));
                }
                result = MemoryTestExecutor.matchBindingSets(queryResult1, queryResult2, newBNodeMapping, idx + 1);
                if (!result) continue;
                break;
            }
        } else {
            result = true;
        }
        return result;
    }

    private static List<BindingSet> findMatchingBindingSets(BindingSet st, Iterable<? extends BindingSet> model, Map<BNode, BNode> bNodeMapping) {
        ArrayList<BindingSet> result = new ArrayList<BindingSet>();
        for (BindingSet bindingSet : model) {
            if (!MemoryTestExecutor.bindingSetsMatch(st, bindingSet, bNodeMapping)) continue;
            result.add(bindingSet);
        }
        return result;
    }

    private static boolean bindingSetsMatch(BindingSet bs1, BindingSet bs2, Map<BNode, BNode> bNodeMapping) {
        if (bs1.size() != bs2.size()) {
            return false;
        }
        for (Binding binding1 : bs1) {
            Value value1 = binding1.getValue();
            Value value2 = bs2.getValue(binding1.getName());
            if (value1 instanceof BNode && value2 instanceof BNode) {
                BNode mappedBNode = bNodeMapping.get(value1);
                if (!(mappedBNode != null ? !value2.equals(mappedBNode) : bNodeMapping.containsValue(value2))) continue;
                return false;
            }
            if (value1 instanceof Literal && value2 instanceof Literal) {
                Literal leftLit = (Literal)value1;
                Literal rightLit = (Literal)value2;
                IRI dt1 = leftLit.getDatatype();
                IRI dt2 = rightLit.getDatatype();
                if (dt1 != null && dt2 != null && dt1.equals((Object)dt2) && XMLDatatypeUtil.isValidValue((String)leftLit.getLabel(), (IRI)dt1) && XMLDatatypeUtil.isValidValue((String)rightLit.getLabel(), (IRI)dt2)) {
                    Integer compareResult = null;
                    if (dt1.equals((Object)XMLSchema.DOUBLE)) {
                        compareResult = Double.compare(leftLit.doubleValue(), rightLit.doubleValue());
                    } else if (dt1.equals((Object)XMLSchema.FLOAT)) {
                        compareResult = Float.compare(leftLit.floatValue(), rightLit.floatValue());
                    } else if (dt1.equals((Object)XMLSchema.DECIMAL)) {
                        compareResult = leftLit.decimalValue().compareTo(rightLit.decimalValue());
                    } else if (XMLDatatypeUtil.isIntegerDatatype((IRI)dt1)) {
                        compareResult = leftLit.integerValue().compareTo(rightLit.integerValue());
                    } else if (dt1.equals((Object)XMLSchema.BOOLEAN)) {
                        Boolean leftBool = leftLit.booleanValue();
                        Boolean rightBool = rightLit.booleanValue();
                        compareResult = leftBool.compareTo(rightBool);
                    } else if (XMLDatatypeUtil.isCalendarDatatype((IRI)dt1)) {
                        XMLGregorianCalendar left = leftLit.calendarValue();
                        XMLGregorianCalendar right = rightLit.calendarValue();
                        compareResult = left.compare(right);
                    }
                    if (!(compareResult != null ? compareResult != 0 : !value1.equals(value2))) continue;
                    return false;
                }
                if (value1.equals(value2)) continue;
                return false;
            }
            if (value1.equals(value2)) continue;
            return false;
        }
        return true;
    }

    private void compareGraphs(Set<Statement> queryResult, Set<Statement> expectedResult) throws Exception {
        if (!Models.isomorphic(expectedResult, queryResult)) {
            StringBuilder message = new StringBuilder(128);
            message.append("\n============ ");
            message.append(this.getName());
            message.append(" =======================\n");
            message.append("Expected result: \n");
            for (Statement st : expectedResult) {
                message.append(st.toString());
                message.append("\n");
            }
            message.append("=============");
            StringUtil.appendN((char)'=', (int)this.getName().length(), (StringBuilder)message);
            message.append("========================\n");
            message.append("Query result: \n");
            for (Statement st : queryResult) {
                message.append(st.toString());
                message.append("\n");
            }
            message.append("=============");
            StringUtil.appendN((char)'=', (int)this.getName().length(), (StringBuilder)message);
            message.append("========================\n");
            logger.error(message.toString());
            Assert.fail((String)message.toString());
        }
    }

    private String readQueryString() throws IOException {
        try (InputStream stream = new URL(this.queryFileURL).openStream();){
            String string = IOUtil.readString((Reader)new InputStreamReader(stream, "UTF-8"));
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TupleQueryResult readExpectedTupleQueryResult(Repository dataRep) throws Exception {
        Optional tqrFormat = QueryResultIO.getParserFormatForFileName((String)this.resultFileURL);
        if (tqrFormat.isPresent()) {
            try (InputStream in = new URL(this.resultFileURL).openStream();){
                TupleQueryResultParser parser = QueryResultIO.createTupleParser((QueryResultFormat)((QueryResultFormat)tqrFormat.get()));
                parser.setValueFactory(dataRep.getValueFactory());
                TupleQueryResultBuilder qrBuilder = new TupleQueryResultBuilder();
                parser.setQueryResultHandler((QueryResultHandler)qrBuilder);
                parser.parseQueryResult(in);
                TupleQueryResult tupleQueryResult = qrBuilder.getQueryResult();
                return tupleQueryResult;
            }
        }
        Set<Statement> resultGraph = this.readExpectedGraphQueryResult(dataRep);
        return DAWGTestResultSetUtil.toTupleQueryResult(resultGraph);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readExpectedBooleanQueryResult(Repository dataRep) throws Exception {
        Optional bqrFormat = BooleanQueryResultParserRegistry.getInstance().getFileFormatForFileName(this.resultFileURL);
        if (bqrFormat.isPresent()) {
            try (InputStream in = new URL(this.resultFileURL).openStream();){
                boolean bl = QueryResultIO.parseBoolean((InputStream)in, (QueryResultFormat)((QueryResultFormat)bqrFormat.get()));
                return bl;
            }
        }
        Set<Statement> resultGraph = this.readExpectedGraphQueryResult(dataRep);
        return DAWGTestResultSetUtil.toBooleanQueryResult(resultGraph);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Statement> readExpectedGraphQueryResult(Repository dataRep) throws Exception {
        Optional rdfFormat = Rio.getParserFormatForFileName((String)this.resultFileURL);
        if (rdfFormat.isPresent()) {
            RDFParser parser = Rio.createParser((RDFFormat)((RDFFormat)rdfFormat.get()), (ValueFactory)dataRep.getValueFactory());
            ParserConfig config = parser.getParserConfig();
            config.addNonFatalError(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES);
            config.addNonFatalError(BasicParserSettings.VERIFY_DATATYPE_VALUES);
            config.addNonFatalError(BasicParserSettings.NORMALIZE_DATATYPE_VALUES);
            config.set(BasicParserSettings.PRESERVE_BNODE_IDS, (Object)true);
            LinkedHashSet<Statement> result = new LinkedHashSet<Statement>();
            parser.setRDFHandler((RDFHandler)new StatementCollector(result));
            try (InputStream in = new URL(this.resultFileURL).openStream();){
                parser.parse(in, this.resultFileURL);
            }
            return result;
        }
        throw new RuntimeException("Unable to determine file type of results file");
    }

    public String getName() {
        return this.name;
    }
}

