/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.test.sparql;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.rdf4j.OpenRDFUtil;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.impl.SimpleDataset;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.repository.util.RDFInserter;
import org.eclipse.rdf4j.rio.ParserConfig;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManifestTestUtils {
    static final Logger LOGGER = LoggerFactory.getLogger(ManifestTestUtils.class);

    public static Collection<Object[]> parametersFromSuperManifest(String manifestFilePath, ImmutableSet<String> ignoredTests) throws Exception {
        URL url = ManifestTestUtils.class.getResource(manifestFilePath);
        if (url == null) {
            throw new RuntimeException("Could not find the resource file " + manifestFilePath + ".\nPlease make sure resources have been generated");
        }
        SailRepository manifestRep = new SailRepository((Sail)new MemoryStore());
        manifestRep.initialize();
        RepositoryConnection con = manifestRep.getConnection();
        String manifestFile = url.toString();
        ManifestTestUtils.addTurtle(con, url, manifestFile, new Resource[0]);
        String query = "SELECT DISTINCT manifestFile FROM {x} rdf:first {manifestFile} USING NAMESPACE mf = <http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#>,   qt = <http://www.w3.org/2001/sw/DataAccess/tests/test-query#>";
        TupleQueryResult manifestResults = con.prepareTupleQuery(QueryLanguage.SERQL, query, manifestFile).evaluate();
        ArrayList testCaseParameters = Lists.newArrayList();
        while (manifestResults.hasNext()) {
            BindingSet bindingSet = (BindingSet)manifestResults.next();
            String subManifestFile = bindingSet.getValue("manifestFile").toString();
            testCaseParameters.addAll(ManifestTestUtils.parametersFromSubManifest(subManifestFile, true, ignoredTests));
        }
        manifestResults.close();
        con.close();
        manifestRep.shutDown();
        LOGGER.info("Created aggregated test suite with " + testCaseParameters.size() + " test cases.");
        return testCaseParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Object[]> parametersFromSubManifest(String manifestFileURL, boolean approvedOnly, ImmutableSet<String> ignoredTests) throws Exception {
        LOGGER.info("Building test suite for {}", (Object)manifestFileURL);
        ArrayList testCaseParameters = Lists.newArrayList();
        SailRepository manifestRep = new SailRepository((Sail)new MemoryStore());
        manifestRep.initialize();
        RepositoryConnection con = manifestRep.getConnection();
        ManifestTestUtils.addTurtle(con, new URL(manifestFileURL), manifestFileURL, new Resource[0]);
        String manifestName = ManifestTestUtils.getManifestName((Repository)manifestRep, con, manifestFileURL);
        StringBuilder query = new StringBuilder(512);
        query.append(" SELECT DISTINCT testIRI, testName, resultFile, action, queryFile, defaultGraph, ordered ");
        query.append(" FROM {} rdf:first {testIRI} ");
        if (approvedOnly) {
            query.append("                          dawgt:approval {dawgt:Approved}; ");
        }
        query.append("                             mf:name {testName}; ");
        query.append("                             mf:result {resultFile}; ");
        query.append("                             [ mf:checkOrder {ordered} ]; ");
        query.append("                             [ mf:requires {Requirement} ];");
        query.append("                             mf:action {action} qt:query {queryFile}; ");
        query.append("                                               [qt:data {defaultGraph}]; ");
        query.append("                                               [sd:entailmentRegime {Regime} ]");
        query.append(" WHERE NOT resultFile LIKE \"*.csv\" ");
        query.append(" AND NOT resultFile LIKE \"*.srj\" ");
        query.append(" AND NOT BOUND(Regime) ");
        query.append(" AND (NOT BOUND(Requirement) OR (Requirement != mf:BasicFederation)) ");
        query.append(" USING NAMESPACE ");
        query.append("  mf = <http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#>, ");
        query.append("  dawgt = <http://www.w3.org/2001/sw/DataAccess/tests/test-dawg#>, ");
        query.append("  qt = <http://www.w3.org/2001/sw/DataAccess/tests/test-query#>, ");
        query.append("  sd = <http://www.w3.org/ns/sparql-service-description#>, ");
        query.append("  ent = <http://www.w3.org/ns/entailment/> ");
        TupleQuery testCaseQuery = con.prepareTupleQuery(QueryLanguage.SERQL, query.toString());
        query.setLength(0);
        query.append(" SELECT graph ");
        query.append(" FROM {action} qt:graphData {graph} ");
        query.append(" USING NAMESPACE ");
        query.append(" qt = <http://www.w3.org/2001/sw/DataAccess/tests/test-query#>");
        TupleQuery namedGraphsQuery = con.prepareTupleQuery(QueryLanguage.SERQL, query.toString());
        query.setLength(0);
        query.append("SELECT 1 ");
        query.append(" FROM {testIRI} mf:resultCardinality {mf:LaxCardinality}");
        query.append(" USING NAMESPACE mf = <http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#>");
        TupleQuery laxCardinalityQuery = con.prepareTupleQuery(QueryLanguage.SERQL, query.toString());
        LOGGER.debug("evaluating query..");
        TupleQueryResult testCases = testCaseQuery.evaluate();
        while (testCases.hasNext()) {
            boolean laxCardinality;
            BindingSet bindingSet = (BindingSet)testCases.next();
            IRI testIRI = (IRI)bindingSet.getValue("testIRI");
            String testLocalName = bindingSet.getValue("testName").toString();
            String testName = manifestName + "-" + testLocalName;
            String resultFile = bindingSet.getValue("resultFile").toString();
            String queryFile = bindingSet.getValue("queryFile").toString();
            IRI defaultGraphIRI = (IRI)bindingSet.getValue("defaultGraph");
            Value action = bindingSet.getValue("action");
            Value ordered = bindingSet.getValue("ordered");
            LOGGER.debug("found test case : {}", (Object)testName);
            namedGraphsQuery.setBinding("action", action);
            TupleQueryResult namedGraphs = namedGraphsQuery.evaluate();
            SimpleDataset dataset = null;
            if (defaultGraphIRI != null || namedGraphs.hasNext()) {
                dataset = new SimpleDataset();
                if (defaultGraphIRI != null) {
                    dataset.addDefaultGraph(defaultGraphIRI);
                }
                while (namedGraphs.hasNext()) {
                    BindingSet graphBindings = (BindingSet)namedGraphs.next();
                    IRI namedGraphIRI = (IRI)graphBindings.getValue("graph");
                    LOGGER.debug(" adding named graph : {}", (Object)namedGraphIRI);
                    dataset.addNamedGraph(namedGraphIRI);
                }
            }
            laxCardinalityQuery.setBinding("testIRI", (Value)testIRI);
            try (TupleQueryResult laxCardinalityResult = laxCardinalityQuery.evaluate();){
                laxCardinality = laxCardinalityResult.hasNext();
            }
            boolean checkOrder = false;
            if (ordered != null) {
                checkOrder = Boolean.parseBoolean(ordered.stringValue());
            }
            testCaseParameters.add(new Object[]{testIRI.toString(), testName, queryFile, resultFile, dataset, laxCardinality, checkOrder, ignoredTests});
        }
        testCases.close();
        con.close();
        manifestRep.shutDown();
        return testCaseParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getManifestName(Repository manifestRep, RepositoryConnection con, String manifestFileURL) throws QueryEvaluationException, RepositoryException, MalformedQueryException {
        TupleQuery manifestNameQuery = con.prepareTupleQuery(QueryLanguage.SERQL, "SELECT ManifestName FROM {ManifestURL} rdfs:label {ManifestName}");
        manifestNameQuery.setBinding("ManifestURL", (Value)manifestRep.getValueFactory().createIRI(manifestFileURL));
        try (TupleQueryResult manifestNames = manifestNameQuery.evaluate();){
            if (manifestNames.hasNext()) {
                String string = ((BindingSet)manifestNames.next()).getValue("ManifestName").stringValue();
                return string;
            }
        }
        int lastSlashIdx = manifestFileURL.lastIndexOf(47);
        int secLastSlashIdx = manifestFileURL.lastIndexOf(47, lastSlashIdx - 1);
        return manifestFileURL.substring(secLastSlashIdx + 1, lastSlashIdx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addTurtle(RepositoryConnection con, URL url, String baseURI, Resource ... contexts) throws IOException, RepositoryException, RDFParseException {
        if (baseURI == null) {
            baseURI = url.toExternalForm();
        }
        try (InputStream in = url.openStream();){
            OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
            ValueFactory vf = con.getRepository().getValueFactory();
            RDFParser rdfParser = Rio.createParser((RDFFormat)RDFFormat.TURTLE, (ValueFactory)vf);
            ParserConfig config = rdfParser.getParserConfig();
            config.addNonFatalError(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES);
            config.addNonFatalError(BasicParserSettings.VERIFY_DATATYPE_VALUES);
            config.addNonFatalError(BasicParserSettings.NORMALIZE_DATATYPE_VALUES);
            RDFInserter rdfInserter = new RDFInserter(con);
            rdfInserter.enforceContext(contexts);
            rdfParser.setRDFHandler((RDFHandler)rdfInserter);
            con.begin();
            try {
                rdfParser.parse(in, baseURI);
            }
            catch (RDFHandlerException e) {
                con.rollback();
                throw (RepositoryException)e.getCause();
            }
            catch (RuntimeException e) {
                con.rollback();
                throw e;
            }
            finally {
                con.commit();
            }
        }
    }
}

