/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.si.repository.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.exception.OntopInternalBugException;
import it.unibz.inf.ontop.model.type.LanguageTag;
import it.unibz.inf.ontop.model.type.ObjectRDFType;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.RDFTermType;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.model.vocabulary.RDF;
import it.unibz.inf.ontop.model.vocabulary.XSD;
import it.unibz.inf.ontop.si.repository.impl.RDBMSSIRepositoryManager;
import it.unibz.inf.ontop.si.repository.impl.SemanticIndexView;
import it.unibz.inf.ontop.si.repository.impl.SemanticIndexViewID;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.rdf.api.IRI;

public class SemanticIndexViewsManager {
    private static final IRI[] SITableToIRI = new IRI[]{XSD.STRING, XSD.INTEGER, XSD.LONG, XSD.DECIMAL, XSD.DOUBLE, XSD.DATETIME, XSD.INT, XSD.UNSIGNED_INT, XSD.NEGATIVE_INTEGER, XSD.NON_NEGATIVE_INTEGER, XSD.POSITIVE_INTEGER, XSD.NON_POSITIVE_INTEGER, XSD.FLOAT, XSD.BOOLEAN, XSD.DATETIMESTAMP};
    private static final int OBJ_TYPE_URI = 0;
    private static final int OBJ_TYPE_BNode = 1;
    private final Map<SemanticIndexViewID, SemanticIndexView> views = new HashMap<SemanticIndexViewID, SemanticIndexView>();
    private final List<SemanticIndexView> propertyViews = new LinkedList<SemanticIndexView>();
    private final List<SemanticIndexView> classViews = new LinkedList<SemanticIndexView>();
    private final TypeFactory typeFactory;
    private final Map<TermType, Integer> colTypetoSITable;

    public SemanticIndexViewsManager(TypeFactory typeFactory) {
        this.typeFactory = typeFactory;
        this.init();
        this.colTypetoSITable = new HashMap<TermType, Integer>();
        this.colTypetoSITable.put((TermType)typeFactory.getBlankNodeType(), 1);
        this.colTypetoSITable.put((TermType)typeFactory.getIRITermType(), 1);
        for (int i = 2; i < SITableToIRI.length; ++i) {
            this.colTypetoSITable.put((TermType)typeFactory.getDatatype(SITableToIRI[i]), i);
        }
    }

    public List<SemanticIndexView> getPropertyViews() {
        return Collections.unmodifiableList(this.propertyViews);
    }

    public List<SemanticIndexView> getClassViews() {
        return Collections.unmodifiableList(this.classViews);
    }

    public SemanticIndexView getView(ObjectRDFType type) {
        SemanticIndexViewID viewId = new SemanticIndexViewID(type);
        return this.views.get(viewId);
    }

    public SemanticIndexView getView(ObjectRDFType type1, RDFTermType type2) {
        SemanticIndexViewID viewId = new SemanticIndexViewID(type1, type2);
        if (!this.views.containsKey(viewId)) {
            if (type2 instanceof RDFDatatype) {
                this.initDataProperty(type1, (RDFDatatype)type2);
            } else {
                throw new UnexpectedRDFTermTypeException(type2);
            }
        }
        return this.views.get(viewId);
    }

    private final void init() {
        ImmutableList objectTypes = ImmutableList.of((Object)this.typeFactory.getIRITermType(), (Object)this.typeFactory.getBlankNodeType());
        IRI[] datatypeIRIs = new IRI[]{XSD.BOOLEAN, XSD.DATETIME, XSD.DATETIMESTAMP, XSD.DECIMAL, XSD.DOUBLE, XSD.INTEGER, XSD.INT, XSD.UNSIGNED_INT, XSD.NEGATIVE_INTEGER, XSD.NON_NEGATIVE_INTEGER, XSD.POSITIVE_INTEGER, XSD.NON_POSITIVE_INTEGER, XSD.FLOAT, XSD.LONG, XSD.STRING};
        for (ObjectRDFType type1 : objectTypes) {
            String value = type1.isBlankNode() ? "TRUE" : "FALSE";
            String filter = "ISBNODE = " + value + " AND ";
            String select = RDBMSSIRepositoryManager.classTable.getSELECT(filter);
            String insert = RDBMSSIRepositoryManager.classTable.getINSERT("?, ?, " + value);
            SemanticIndexViewID viewId = new SemanticIndexViewID(type1);
            SemanticIndexView view = new SemanticIndexView(viewId, select, insert);
            this.views.put(view.getId(), view);
            this.classViews.add(view);
            for (ObjectRDFType type2 : objectTypes) {
                this.initObjectProperty(type1, type2);
            }
            for (IRI iriType2 : datatypeIRIs) {
                this.initDataProperty(type1, this.typeFactory.getDatatype(iriType2));
            }
        }
    }

    private void initDataProperty(ObjectRDFType type1, RDFDatatype type2) {
        String insert;
        String select;
        String value = type1.isBlankNode() ? "TRUE" : "FALSE";
        String filter = "ISBNODE = " + value + " AND ";
        if (type2.getLanguageTag().isPresent()) {
            LanguageTag languageTag = (LanguageTag)type2.getLanguageTag().get();
            RDBMSSIRepositoryManager.TableDescription tableDescription = (RDBMSSIRepositoryManager.TableDescription)RDBMSSIRepositoryManager.ATTRIBUTE_TABLE_MAP.get((Object)RDF.LANGSTRING);
            select = tableDescription.getSELECT("LANG = '" + languageTag.getFullString() + "' AND " + filter);
            insert = tableDescription.getINSERT("?, ?, ?, ?, " + value);
        } else {
            RDBMSSIRepositoryManager.TableDescription tableDescription = (RDBMSSIRepositoryManager.TableDescription)RDBMSSIRepositoryManager.ATTRIBUTE_TABLE_MAP.get((Object)type2.getIRI());
            select = tableDescription.getSELECT(filter);
            insert = tableDescription.getINSERT("?, ?, ?, " + value);
        }
        this.createViews(type1, (RDFTermType)type2, select, insert);
    }

    private void initObjectProperty(ObjectRDFType type1, ObjectRDFType type2) {
        String value1 = type1.isBlankNode() ? "TRUE" : "FALSE";
        String value2 = type2.isBlankNode() ? "TRUE" : "FALSE";
        String filter = "ISBNODE = " + value1 + " AND ";
        RDBMSSIRepositoryManager.TableDescription tableDescription = RDBMSSIRepositoryManager.ROLE_TABLE;
        String select = tableDescription.getSELECT(filter + "ISBNODE2 = " + value2 + " AND ");
        String insert = tableDescription.getINSERT("?, ?, ?, " + value1 + ", " + value2);
        this.createViews(type1, (RDFTermType)type2, select, insert);
    }

    private void createViews(ObjectRDFType type1, RDFTermType type2, String select, String insert) {
        SemanticIndexViewID viewId = new SemanticIndexViewID(type1, type2);
        SemanticIndexView view = new SemanticIndexView(viewId, select, insert);
        this.views.put(view.getId(), view);
        this.propertyViews.add(view);
    }

    private static int COLTYPEtoInt(ObjectRDFType t) {
        return t.isBlankNode() ? 1 : 0;
    }

    public void store(Connection conn) throws SQLException {
        try (PreparedStatement stm = conn.prepareStatement(RDBMSSIRepositoryManager.emptinessIndexTable.getINSERT("?, ?, ?, ?"));){
            for (SemanticIndexView view : this.views.values()) {
                SemanticIndexViewID viewId = view.getId();
                for (Integer idx : view.getIndexes()) {
                    if (viewId.getType2() == null) {
                        stm.setInt(1, 0);
                        stm.setInt(2, idx);
                        stm.setInt(3, SemanticIndexViewsManager.COLTYPEtoInt(viewId.getType1()));
                        stm.setInt(4, 1);
                    } else {
                        stm.setInt(1, this.colTypetoSITable.get(viewId.getType2()));
                        stm.setInt(2, idx);
                        stm.setInt(3, SemanticIndexViewsManager.COLTYPEtoInt(viewId.getType1()));
                        stm.setInt(4, SemanticIndexViewsManager.COLTYPEtoInt((ObjectRDFType)viewId.getType2()));
                    }
                    stm.addBatch();
                }
            }
            stm.executeBatch();
        }
    }

    private static class UnexpectedRDFTermTypeException
    extends OntopInternalBugException {
        private UnexpectedRDFTermTypeException(RDFTermType termType) {
            super("Unexpected RDF term type used as property object: " + termType);
        }
    }
}

