/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.si.repository.impl;

import it.unibz.inf.ontop.com.google.common.base.Joiner;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.model.term.BNode;
import it.unibz.inf.ontop.model.term.IRIConstant;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.ObjectConstant;
import it.unibz.inf.ontop.model.term.RDFConstant;
import it.unibz.inf.ontop.model.term.RDFLiteralConstant;
import it.unibz.inf.ontop.model.term.RDFTermTypeConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.IRIDictionary;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.Int2IRIStringFunctionSymbolImpl;
import it.unibz.inf.ontop.model.type.DBTypeFactory;
import it.unibz.inf.ontop.model.type.LanguageTag;
import it.unibz.inf.ontop.model.type.ObjectRDFType;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.RDFTermType;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.model.vocabulary.RDF;
import it.unibz.inf.ontop.model.vocabulary.XSD;
import it.unibz.inf.ontop.si.repository.impl.COL_TYPE;
import it.unibz.inf.ontop.si.repository.impl.Interval;
import it.unibz.inf.ontop.si.repository.impl.SemanticIndexCache;
import it.unibz.inf.ontop.si.repository.impl.SemanticIndexRange;
import it.unibz.inf.ontop.si.repository.impl.SemanticIndexURIMap;
import it.unibz.inf.ontop.si.repository.impl.SemanticIndexView;
import it.unibz.inf.ontop.si.repository.impl.SemanticIndexViewID;
import it.unibz.inf.ontop.si.repository.impl.SemanticIndexViewsManager;
import it.unibz.inf.ontop.si.repository.impl.XsdDatatypeConverter;
import it.unibz.inf.ontop.spec.mapping.SQLPPSourceQuery;
import it.unibz.inf.ontop.spec.mapping.SQLPPSourceQueryFactory;
import it.unibz.inf.ontop.spec.mapping.TargetAtom;
import it.unibz.inf.ontop.spec.mapping.TargetAtomFactory;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPTriplesMap;
import it.unibz.inf.ontop.spec.mapping.pp.impl.OntopNativeSQLPPTriplesMap;
import it.unibz.inf.ontop.spec.ontology.ClassExpression;
import it.unibz.inf.ontop.spec.ontology.ClassifiedTBox;
import it.unibz.inf.ontop.spec.ontology.DataPropertyExpression;
import it.unibz.inf.ontop.spec.ontology.Equivalences;
import it.unibz.inf.ontop.spec.ontology.OClass;
import it.unibz.inf.ontop.spec.ontology.ObjectPropertyExpression;
import it.unibz.inf.ontop.spec.ontology.RDFFact;
import it.unibz.inf.ontop.utils.IDGenerator;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.rdf.api.IRI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDBMSSIRepositoryManager {
    private static final Logger log = LoggerFactory.getLogger(RDBMSSIRepositoryManager.class);
    private static final TableDescription indexTable = new TableDescription("IDX", (ImmutableMap<String, String>)ImmutableMap.of((Object)"URI", (Object)"VARCHAR(400)", (Object)"IDX", (Object)"INTEGER", (Object)"ENTITY_TYPE", (Object)"INTEGER"), "*");
    private static final TableDescription intervalTable = new TableDescription("IDXINTERVAL", (ImmutableMap<String, String>)ImmutableMap.of((Object)"URI", (Object)"VARCHAR(400)", (Object)"IDX_FROM", (Object)"INTEGER", (Object)"IDX_TO", (Object)"INTEGER", (Object)"ENTITY_TYPE", (Object)"INTEGER"), "*");
    private static final TableDescription uriIdTable = new TableDescription("URIID", (ImmutableMap<String, String>)ImmutableMap.of((Object)"ID", (Object)"INTEGER", (Object)"URI", (Object)"VARCHAR(400)"), "*");
    static final TableDescription emptinessIndexTable = new TableDescription("NONEMPTYNESSINDEX", (ImmutableMap<String, String>)ImmutableMap.of((Object)"TABLEID", (Object)"INTEGER", (Object)"IDX", (Object)"INTEGER", (Object)"TYPE1", (Object)"INTEGER", (Object)"TYPE2", (Object)"INTEGER"), "*");
    static final TableDescription classTable = new TableDescription("QUEST_CLASS_ASSERTION", (ImmutableMap<String, String>)ImmutableMap.of((Object)"\"URI\"", (Object)"INTEGER NOT NULL", (Object)"\"IDX\"", (Object)"SMALLINT NOT NULL", (Object)"ISBNODE", (Object)"BOOLEAN NOT NULL DEFAULT FALSE"), "\"URI\" as X");
    static final ImmutableList<TableDescription> attributeTables;
    static final TableDescription ROLE_TABLE;
    static final ImmutableMap<IRI, TableDescription> ATTRIBUTE_TABLE_MAP;
    private final SemanticIndexURIMap uriMap;
    private final ClassifiedTBox reasonerDag;
    private final SemanticIndexCache cacheSI;
    private final SemanticIndexViewsManager views;
    private final TermFactory termFactory;
    private final TargetAtomFactory targetAtomFactory;
    private final FunctionSymbol int2IRIStringFunctionSymbol;
    private final RDFTermTypeConstant iriTypeConstant;
    private final SQLPPSourceQueryFactory sourceQueryFactory;
    private int maxURIId = -1;
    public static final int CLASS_TYPE = 1;
    public static final int ROLE_TYPE = 2;

    public RDBMSSIRepositoryManager(ClassifiedTBox reasonerDag, TermFactory termFactory, TypeFactory typeFactory, TargetAtomFactory targetAtomFactory, SQLPPSourceQueryFactory sourceQueryFactory) {
        this.reasonerDag = reasonerDag;
        this.termFactory = termFactory;
        this.sourceQueryFactory = sourceQueryFactory;
        this.views = new SemanticIndexViewsManager(typeFactory);
        this.cacheSI = new SemanticIndexCache(reasonerDag);
        this.targetAtomFactory = targetAtomFactory;
        this.cacheSI.buildSemanticIndexFromReasoner();
        this.uriMap = new SemanticIndexURIMap();
        DBTypeFactory dbTypeFactory = typeFactory.getDBTypeFactory();
        this.int2IRIStringFunctionSymbol = new Int2IRIStringFunctionSymbolImpl(dbTypeFactory.getDBTermType("INTEGER"), dbTypeFactory.getDBStringType(), this.uriMap);
        this.iriTypeConstant = termFactory.getRDFTermTypeConstant((RDFTermType)typeFactory.getIRITermType());
    }

    public SemanticIndexURIMap getUriMap() {
        return this.uriMap;
    }

    public void createDBSchemaAndInsertMetadata(Connection conn) throws SQLException {
        if (this.isDBSchemaDefined(conn)) {
            log.debug("Schema already exists. Skipping creation");
            return;
        }
        log.debug("Creating data tables");
        try (Statement st = conn.createStatement();){
            st.addBatch(RDBMSSIRepositoryManager.uriIdTable.createCommand);
            st.addBatch(RDBMSSIRepositoryManager.indexTable.createCommand);
            st.addBatch(RDBMSSIRepositoryManager.intervalTable.createCommand);
            st.addBatch(RDBMSSIRepositoryManager.emptinessIndexTable.createCommand);
            st.addBatch(RDBMSSIRepositoryManager.classTable.createCommand);
            for (TableDescription table : attributeTables) {
                st.addBatch(table.createCommand);
            }
            st.executeBatch();
        }
        this.insertMetadata(conn);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isDBSchemaDefined(Connection conn) {
        try (Statement st = conn.createStatement();){
            st.executeQuery(String.format("SELECT 1 FROM %s WHERE 1=0", RDBMSSIRepositoryManager.classTable.tableName));
            st.executeQuery(String.format("SELECT 1 FROM %s WHERE 1=0", RDBMSSIRepositoryManager.ROLE_TABLE.tableName));
            st.executeQuery(String.format("SELECT 1 FROM %s WHERE 1=0", ((TableDescription)RDBMSSIRepositoryManager.ATTRIBUTE_TABLE_MAP.get((Object)RDF.LANGSTRING)).tableName));
            st.executeQuery(String.format("SELECT 1 FROM %s WHERE 1=0", ((TableDescription)RDBMSSIRepositoryManager.ATTRIBUTE_TABLE_MAP.get((Object)XSD.STRING)).tableName));
            st.executeQuery(String.format("SELECT 1 FROM %s WHERE 1=0", ((TableDescription)RDBMSSIRepositoryManager.ATTRIBUTE_TABLE_MAP.get((Object)XSD.INTEGER)).tableName));
            st.executeQuery(String.format("SELECT 1 FROM %s WHERE 1=0", ((TableDescription)RDBMSSIRepositoryManager.ATTRIBUTE_TABLE_MAP.get((Object)XSD.LONG)).tableName));
            st.executeQuery(String.format("SELECT 1 FROM %s WHERE 1=0", ((TableDescription)RDBMSSIRepositoryManager.ATTRIBUTE_TABLE_MAP.get((Object)XSD.DECIMAL)).tableName));
            st.executeQuery(String.format("SELECT 1 FROM %s WHERE 1=0", ((TableDescription)RDBMSSIRepositoryManager.ATTRIBUTE_TABLE_MAP.get((Object)XSD.DOUBLE)).tableName));
            st.executeQuery(String.format("SELECT 1 FROM %s WHERE 1=0", ((TableDescription)RDBMSSIRepositoryManager.ATTRIBUTE_TABLE_MAP.get((Object)XSD.DATETIME)).tableName));
            st.executeQuery(String.format("SELECT 1 FROM %s WHERE 1=0", ((TableDescription)RDBMSSIRepositoryManager.ATTRIBUTE_TABLE_MAP.get((Object)XSD.BOOLEAN)).tableName));
            st.executeQuery(String.format("SELECT 1 FROM %s WHERE 1=0", ((TableDescription)RDBMSSIRepositoryManager.ATTRIBUTE_TABLE_MAP.get((Object)XSD.DATETIMESTAMP)).tableName));
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insertData(Connection conn, Iterator<RDFFact> data, int commitLimit, int batchLimit) throws SQLException {
        log.debug("Inserting data into DB");
        commitLimit = commitLimit < 1 ? 1 : commitLimit;
        batchLimit = batchLimit < 1 ? 1 : batchLimit;
        boolean oldAutoCommit = conn.getAutoCommit();
        conn.setAutoCommit(false);
        PreparedStatement uriidStm = conn.prepareStatement(uriIdTable.getINSERT("?, ?"));
        HashMap<SemanticIndexViewID, PreparedStatement> stmMap = new HashMap<SemanticIndexViewID, PreparedStatement>();
        int success = 0;
        HashMap<IRI, Integer> failures = new HashMap<IRI, Integer>();
        int batchCount = 0;
        int commitCount = 0;
        try {
            while (data.hasNext()) {
                RDFFact ax = data.next();
                ++batchCount;
                ++commitCount;
                try {
                    this.process(conn, ax, uriidStm, stmMap);
                    ++success;
                }
                catch (Exception e) {
                    IRI iri = Optional.of(ax.getClassOrProperty()).filter(c -> c instanceof IRIConstant).map(c -> (IRIConstant)c).orElseGet(() -> ((RDFFact)ax).getProperty()).getIRI();
                    Integer counter = (Integer)failures.get(iri);
                    if (counter == null) {
                        counter = 0;
                    }
                    failures.put(iri, counter + 1);
                }
                if (batchCount == batchLimit) {
                    uriidStm.executeBatch();
                    uriidStm.clearBatch();
                    for (PreparedStatement stm : stmMap.values()) {
                        stm.executeBatch();
                        stm.clearBatch();
                    }
                    batchCount = 0;
                }
                if (commitCount != commitLimit) continue;
                conn.commit();
                commitCount = 0;
            }
            uriidStm.executeBatch();
            uriidStm.clearBatch();
            for (PreparedStatement stm : stmMap.values()) {
                stm.executeBatch();
                stm.clearBatch();
            }
            conn.commit();
        }
        finally {
            uriidStm.close();
            for (PreparedStatement stm : stmMap.values()) {
                stm.close();
            }
        }
        conn.setAutoCommit(oldAutoCommit);
        log.debug("Total successful insertions: " + success + ".");
        int totalFailures = 0;
        for (Map.Entry entry : failures.entrySet()) {
            log.warn("Failed to insert data for predicate {} ({} tuples).", entry.getKey(), entry.getValue());
            totalFailures += ((Integer)entry.getValue()).intValue();
        }
        if (totalFailures > 0) {
            log.warn("Total failed insertions: " + totalFailures + ". (REASON: datatype mismatch between the ontology and database).");
        }
        return success;
    }

    private void process(Connection conn, RDFFact ax, PreparedStatement uriidStm, Map<SemanticIndexViewID, PreparedStatement> stmMap) throws SQLException {
        if (ax.isClassAssertion() && ax.getObject() instanceof IRIConstant) {
            IRI classIRI = ((IRIConstant)ax.getObject()).getIRI();
            OClass cls = (OClass)this.reasonerDag.classes().get(classIRI);
            this.process(conn, ax, cls, uriidStm, stmMap);
        } else {
            RDFConstant object = ax.getObject();
            IRI propertyIri = ax.getProperty().getIRI();
            if (object instanceof ObjectConstant) {
                ObjectPropertyExpression ope = (ObjectPropertyExpression)this.reasonerDag.objectProperties().get(propertyIri);
                this.process(conn, ax, ope, uriidStm, stmMap);
            } else if (object instanceof RDFLiteralConstant) {
                DataPropertyExpression dpe = (DataPropertyExpression)this.reasonerDag.dataProperties().get(propertyIri);
                this.process(conn, ax, dpe, uriidStm, stmMap);
            }
        }
    }

    private void process(Connection conn, RDFFact assertion, ObjectPropertyExpression ope0, PreparedStatement uriidStm, Map<SemanticIndexViewID, PreparedStatement> stmMap) throws SQLException {
        ObjectConstant o2;
        ObjectConstant o1;
        if (ope0.isInverse()) {
            throw new RuntimeException("INVERSE PROPERTIES ARE NOT SUPPORTED IN ABOX:" + assertion);
        }
        ObjectPropertyExpression ope = (ObjectPropertyExpression)this.reasonerDag.objectPropertiesDAG().getCanonicalForm((Object)ope0);
        if (ope.isInverse()) {
            o1 = (ObjectConstant)assertion.getObject();
            o2 = assertion.getSubject();
            ope = ope.getInverse();
        } else {
            o1 = assertion.getSubject();
            o2 = (ObjectConstant)assertion.getObject();
        }
        int idx = this.cacheSI.getEntry(ope).getIndex();
        SemanticIndexView view = this.views.getView(o1.getType(), (RDFTermType)o2.getType());
        PreparedStatement stm = stmMap.get(view.getId());
        if (stm == null) {
            stm = conn.prepareStatement(view.getINSERT());
            stmMap.put(view.getId(), stm);
        }
        int uri_id = this.getObjectConstantUriId(o1, uriidStm);
        int uri2_id = this.getObjectConstantUriId(o2, uriidStm);
        stm.setInt(1, uri_id);
        stm.setInt(2, uri2_id);
        stm.setInt(3, idx);
        stm.addBatch();
        view.addIndex(idx);
    }

    private void process(Connection conn, RDFFact assertion, DataPropertyExpression dpe0, PreparedStatement uriidStm, Map<SemanticIndexViewID, PreparedStatement> stmMap) throws SQLException {
        DataPropertyExpression dpe = (DataPropertyExpression)this.reasonerDag.dataPropertiesDAG().getCanonicalForm((Object)dpe0);
        int idx = this.cacheSI.getEntry(dpe).getIndex();
        ObjectConstant subject = assertion.getSubject();
        int uri_id = this.getObjectConstantUriId(subject, uriidStm);
        RDFLiteralConstant object = (RDFLiteralConstant)assertion.getObject();
        SemanticIndexView view = this.views.getView(subject.getType(), (RDFTermType)object.getType());
        PreparedStatement stm = stmMap.get(view.getId());
        if (stm == null) {
            stm = conn.prepareStatement(view.getINSERT());
            stmMap.put(view.getId(), stm);
        }
        stm.setInt(1, uri_id);
        String value = object.getValue();
        switch (COL_TYPE.getColType(object.getType().getIRI())) {
            case LANG_STRING: {
                stm.setString(2, value);
                stm.setString(4, ((LanguageTag)object.getType().getLanguageTag().get()).getFullString());
                break;
            }
            case STRING: {
                stm.setString(2, value);
                break;
            }
            case INT: {
                stm.setInt(2, Integer.parseInt(value));
                break;
            }
            case UNSIGNED_INT: {
                stm.setInt(2, Integer.parseInt(value));
                break;
            }
            case INTEGER: 
            case NEGATIVE_INTEGER: 
            case POSITIVE_INTEGER: 
            case NON_NEGATIVE_INTEGER: 
            case NON_POSITIVE_INTEGER: 
            case LONG: {
                stm.setLong(2, Long.parseLong(value));
                break;
            }
            case FLOAT: {
                stm.setDouble(2, Float.parseFloat(value));
                break;
            }
            case DOUBLE: {
                stm.setDouble(2, Double.parseDouble(value));
                break;
            }
            case DECIMAL: {
                stm.setBigDecimal(2, new BigDecimal(value));
                break;
            }
            case DATETIME_STAMP: 
            case DATETIME: {
                Timestamp timestamp = XsdDatatypeConverter.parseXsdDateTime(value);
                stm.setTimestamp(2, timestamp);
                break;
            }
            case BOOLEAN: {
                stm.setBoolean(2, XsdDatatypeConverter.parseXsdBoolean(value));
                break;
            }
            default: {
                log.warn("Ignoring assertion: {}", (Object)assertion);
                return;
            }
        }
        stm.setInt(3, idx);
        stm.addBatch();
        view.addIndex(idx);
    }

    private void process(Connection conn, RDFFact assertion, OClass concept0, PreparedStatement uriidStm, Map<SemanticIndexViewID, PreparedStatement> stmMap) throws SQLException {
        OClass concept = (OClass)this.reasonerDag.classesDAG().getCanonicalForm((Object)concept0);
        int conceptIndex = this.cacheSI.getEntry(concept).getIndex();
        ObjectConstant c1 = assertion.getSubject();
        SemanticIndexView view = this.views.getView(c1.getType());
        PreparedStatement stm = stmMap.get(view.getId());
        if (stm == null) {
            stm = conn.prepareStatement(view.getINSERT());
            stmMap.put(view.getId(), stm);
        }
        int uri_id = this.getObjectConstantUriId(c1, uriidStm);
        stm.setInt(1, uri_id);
        stm.setInt(2, conceptIndex);
        stm.addBatch();
        view.addIndex(conceptIndex);
    }

    private int getObjectConstantUriId(ObjectConstant c, PreparedStatement uriidStm) throws SQLException {
        String uri = c instanceof BNode ? ((BNode)c).getInternalLabel() : ((IRIConstant)c).getIRI().getIRIString();
        int uri_id = this.uriMap.getId(uri);
        if (uri_id < 0) {
            uri_id = this.maxURIId + 1;
            this.uriMap.set(uri, uri_id);
            ++this.maxURIId;
            uriidStm.setInt(1, uri_id);
            uriidStm.setString(2, uri);
            uriidStm.addBatch();
        }
        return uri_id;
    }

    public ImmutableList<SQLPPTriplesMap> getMappings() {
        OntopNativeSQLPPTriplesMap basicmapping;
        ImmutableList<TargetAtom> targetQuery;
        SQLPPSourceQuery sourceQuery;
        String intervalsSqlFilter;
        List<Interval> intervals;
        SemanticIndexRange range;
        LinkedList<OntopNativeSQLPPTriplesMap> result = new LinkedList<OntopNativeSQLPPTriplesMap>();
        for (Equivalences set : this.reasonerDag.objectPropertiesDAG()) {
            ObjectPropertyExpression ope = (ObjectPropertyExpression)set.getRepresentative();
            if (ope.isInverse() || !this.reasonerDag.objectProperties().contains(ope.getIRI())) continue;
            range = this.cacheSI.getEntry(ope);
            if (range == null) {
                log.debug("Object property " + ope + " has no SemanticIndexRange");
                return null;
            }
            intervals = range.getIntervals();
            intervalsSqlFilter = RDBMSSIRepositoryManager.getIntervalString(intervals);
            for (SemanticIndexView view : this.views.getPropertyViews()) {
                if (view.isEmptyForIntervals(intervals)) continue;
                sourceQuery = this.sourceQueryFactory.createSourceQuery(view.getSELECT(intervalsSqlFilter));
                targetQuery = this.constructTargetQuery((ImmutableTerm)this.termFactory.getConstantIRI(ope.getIRI()), view.getId().getType1(), view.getId().getType2(), this.getUriMap());
                basicmapping = new OntopNativeSQLPPTriplesMap(IDGenerator.getNextUniqueID((String)"MAPID-"), sourceQuery, targetQuery);
                result.add(basicmapping);
            }
        }
        for (Equivalences set : this.reasonerDag.dataPropertiesDAG()) {
            DataPropertyExpression dpe = (DataPropertyExpression)set.getRepresentative();
            if (!this.reasonerDag.dataProperties().contains(dpe.getIRI())) continue;
            range = this.cacheSI.getEntry(dpe);
            if (range == null) {
                log.debug("Data property " + dpe + " has no SemanticIndexRange");
                return null;
            }
            intervals = range.getIntervals();
            intervalsSqlFilter = RDBMSSIRepositoryManager.getIntervalString(intervals);
            for (SemanticIndexView view : this.views.getPropertyViews()) {
                if (view.isEmptyForIntervals(intervals)) continue;
                sourceQuery = this.sourceQueryFactory.createSourceQuery(view.getSELECT(intervalsSqlFilter));
                targetQuery = this.constructTargetQuery((ImmutableTerm)this.termFactory.getConstantIRI(dpe.getIRI()), view.getId().getType1(), view.getId().getType2(), this.getUriMap());
                basicmapping = new OntopNativeSQLPPTriplesMap(IDGenerator.getNextUniqueID((String)"MAPID-"), sourceQuery, targetQuery);
                result.add(basicmapping);
            }
        }
        for (Equivalences set : this.reasonerDag.classesDAG()) {
            ClassExpression node = (ClassExpression)set.getRepresentative();
            if (!(node instanceof OClass)) continue;
            OClass classNode = (OClass)node;
            SemanticIndexRange range2 = this.cacheSI.getEntry(classNode);
            if (range2 == null) {
                log.debug("Class: " + classNode + " has no SemanticIndexRange");
                continue;
            }
            List<Interval> intervals2 = range2.getIntervals();
            String intervalsSqlFilter2 = RDBMSSIRepositoryManager.getIntervalString(intervals2);
            for (SemanticIndexView view : this.views.getClassViews()) {
                if (view.isEmptyForIntervals(intervals2)) continue;
                SQLPPSourceQuery sourceQuery2 = this.sourceQueryFactory.createSourceQuery(view.getSELECT(intervalsSqlFilter2));
                ImmutableList<TargetAtom> targetQuery2 = this.constructTargetQuery((ImmutableTerm)this.termFactory.getConstantIRI(classNode.getIRI()), view.getId().getType1());
                OntopNativeSQLPPTriplesMap basicmapping2 = new OntopNativeSQLPPTriplesMap(IDGenerator.getNextUniqueID((String)"MAPID-"), sourceQuery2, targetQuery2);
                result.add(basicmapping2);
            }
        }
        log.debug("Total: {} mappings", (Object)result.size());
        return ImmutableList.copyOf(result);
    }

    private ImmutableList<TargetAtom> constructTargetQuery(ImmutableTerm classTerm, ObjectRDFType type) {
        Variable X = this.termFactory.getVariable("X");
        ImmutableFunctionalTerm subjectTerm = !type.isBlankNode() ? this.getEncodedIRIFunctionalTerm((ImmutableTerm)X) : this.termFactory.getRDFFunctionalTerm((ImmutableTerm)X, (ImmutableTerm)this.termFactory.getRDFTermTypeConstant((RDFTermType)type));
        IRIConstant predTerm = this.termFactory.getConstantIRI(RDF.TYPE);
        TargetAtom targetAtom = this.targetAtomFactory.getTripleTargetAtom((ImmutableTerm)subjectTerm, (ImmutableTerm)predTerm, classTerm);
        return ImmutableList.of((Object)targetAtom);
    }

    private ImmutableList<TargetAtom> constructTargetQuery(ImmutableTerm iriTerm, ObjectRDFType type1, RDFTermType type2, IRIDictionary iriDictionary) {
        ImmutableFunctionalTerm objectTerm;
        Variable X = this.termFactory.getVariable("X");
        Variable Y = this.termFactory.getVariable("Y");
        ImmutableFunctionalTerm subjectTerm = !type1.isBlankNode() ? this.getEncodedIRIFunctionalTerm((ImmutableTerm)X) : this.termFactory.getRDFFunctionalTerm((ImmutableTerm)X, (ImmutableTerm)this.termFactory.getRDFTermTypeConstant((RDFTermType)type1));
        if (type2 instanceof ObjectRDFType) {
            objectTerm = ((ObjectRDFType)type2).isBlankNode() ? this.termFactory.getRDFFunctionalTerm((ImmutableTerm)Y, (ImmutableTerm)this.termFactory.getRDFTermTypeConstant(type2)) : this.getEncodedIRIFunctionalTerm((ImmutableTerm)Y);
        } else {
            RDFDatatype datatype = (RDFDatatype)type2;
            if (datatype.getLanguageTag().isPresent()) {
                LanguageTag languageTag = (LanguageTag)datatype.getLanguageTag().get();
                objectTerm = this.termFactory.getRDFLiteralFunctionalTerm((ImmutableTerm)Y, languageTag.getFullString());
            } else {
                objectTerm = this.termFactory.getRDFLiteralFunctionalTerm((ImmutableTerm)Y, datatype);
            }
        }
        TargetAtom targetAtom = this.targetAtomFactory.getTripleTargetAtom((ImmutableTerm)subjectTerm, iriTerm, (ImmutableTerm)objectTerm);
        return ImmutableList.of((Object)targetAtom);
    }

    public ImmutableFunctionalTerm getEncodedIRIFunctionalTerm(ImmutableTerm dbIntegerTerm) {
        ImmutableFunctionalTerm lexicalValue = this.termFactory.getImmutableFunctionalTerm(this.int2IRIStringFunctionSymbol, new ImmutableTerm[]{dbIntegerTerm});
        return this.termFactory.getRDFFunctionalTerm((ImmutableTerm)lexicalValue, (ImmutableTerm)this.iriTypeConstant);
    }

    private static String getIntervalString(final List<Interval> intervals) {
        if (intervals.size() == 1) {
            return RDBMSSIRepositoryManager.getIntervalString(intervals.iterator().next());
        }
        if (intervals.size() > 1) {
            StringBuilder sql = new StringBuilder();
            sql.append("(");
            Joiner.on((String)" OR ").appendTo(sql, (Iterator)new Iterator<String>(){
                private final Iterator<Interval> it;
                {
                    this.it = intervals.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public String next() {
                    Interval interval = this.it.next();
                    return RDBMSSIRepositoryManager.getIntervalString(interval);
                }

                @Override
                public void remove() {
                }
            });
            sql.append(")");
            return sql.toString();
        }
        return "";
    }

    private static String getIntervalString(Interval interval) {
        if (interval.getStart() == interval.getEnd()) {
            return String.format("IDX = %d", interval.getStart());
        }
        return String.format("IDX >= %d AND IDX <= %d", interval.getStart(), interval.getEnd());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertMetadata(Connection conn) throws SQLException {
        log.debug("Inserting semantic index metadata.");
        boolean commitval = conn.getAutoCommit();
        conn.setAutoCommit(false);
        try {
            try (Statement st = conn.createStatement();){
                st.executeUpdate("DELETE FROM " + RDBMSSIRepositoryManager.indexTable.tableName);
                st.executeUpdate("DELETE FROM " + RDBMSSIRepositoryManager.intervalTable.tableName);
                st.executeUpdate("DELETE FROM " + RDBMSSIRepositoryManager.emptinessIndexTable.tableName);
            }
            var4_5 = null;
            try (PreparedStatement stm = conn.prepareStatement(indexTable.getINSERT("?, ?, ?"));){
                for (Map.Entry<OClass, SemanticIndexRange> entry : this.cacheSI.getClassIndexEntries()) {
                    stm.setString(1, entry.getKey().getIRI().getIRIString());
                    stm.setInt(2, entry.getValue().getIndex());
                    stm.setInt(3, 1);
                    stm.addBatch();
                }
                for (Map.Entry<OClass, SemanticIndexRange> entry : this.cacheSI.getObjectPropertyIndexEntries()) {
                    stm.setString(1, ((ObjectPropertyExpression)entry.getKey()).getIRI().getIRIString());
                    stm.setInt(2, entry.getValue().getIndex());
                    stm.setInt(3, 2);
                    stm.addBatch();
                }
                for (Map.Entry<OClass, SemanticIndexRange> entry : this.cacheSI.getDataPropertyIndexEntries()) {
                    stm.setString(1, ((DataPropertyExpression)entry.getKey()).getIRI().getIRIString());
                    stm.setInt(2, entry.getValue().getIndex());
                    stm.setInt(3, 2);
                    stm.addBatch();
                }
                stm.executeBatch();
            }
            catch (Throwable throwable) {
                var4_5 = throwable;
                throw throwable;
            }
            stm = conn.prepareStatement(intervalTable.getINSERT("?, ?, ?, ?"));
            var4_5 = null;
            try {
                for (Map.Entry<OClass, SemanticIndexRange> entry : this.cacheSI.getClassIndexEntries()) {
                    for (Interval it : entry.getValue().getIntervals()) {
                        stm.setString(1, entry.getKey().getIRI().getIRIString());
                        stm.setInt(2, it.getStart());
                        stm.setInt(3, it.getEnd());
                        stm.setInt(4, 1);
                        stm.addBatch();
                    }
                }
                for (Map.Entry<OClass, SemanticIndexRange> entry : this.cacheSI.getObjectPropertyIndexEntries()) {
                    for (Interval it : entry.getValue().getIntervals()) {
                        stm.setString(1, ((ObjectPropertyExpression)entry.getKey()).getIRI().getIRIString());
                        stm.setInt(2, it.getStart());
                        stm.setInt(3, it.getEnd());
                        stm.setInt(4, 2);
                        stm.addBatch();
                    }
                }
                for (Map.Entry<OClass, SemanticIndexRange> entry : this.cacheSI.getDataPropertyIndexEntries()) {
                    for (Interval it : entry.getValue().getIntervals()) {
                        stm.setString(1, ((DataPropertyExpression)entry.getKey()).getIRI().getIRIString());
                        stm.setInt(2, it.getStart());
                        stm.setInt(3, it.getEnd());
                        stm.setInt(4, 2);
                        stm.addBatch();
                    }
                }
                stm.executeBatch();
            }
            catch (Throwable throwable) {
                var4_5 = throwable;
                throw throwable;
            }
            finally {
                if (stm != null) {
                    if (var4_5 != null) {
                        try {
                            stm.close();
                        }
                        catch (Throwable throwable) {
                            var4_5.addSuppressed(throwable);
                        }
                    } else {
                        stm.close();
                    }
                }
            }
            this.views.store(conn);
            conn.commit();
        }
        catch (SQLException e) {
            conn.rollback();
        }
        finally {
            conn.setAutoCommit(commitval);
        }
    }

    static {
        ImmutableList.Builder attributeTableBuilder = ImmutableList.builder();
        classTable.indexOn("idxclassfull", "URI, IDX, ISBNODE");
        classTable.indexOn("idxclassfull2", "URI, IDX");
        ROLE_TABLE = new TableDescription("QUEST_OBJECT_PROPERTY_ASSERTION", (ImmutableMap<String, String>)ImmutableMap.of((Object)"\"URI1\"", (Object)"INTEGER NOT NULL", (Object)"\"URI2\"", (Object)"INTEGER NOT NULL", (Object)"\"IDX\"", (Object)"SMALLINT NOT NULL", (Object)"ISBNODE", (Object)"BOOLEAN NOT NULL DEFAULT FALSE", (Object)"ISBNODE2", (Object)"BOOLEAN NOT NULL DEFAULT FALSE"), "\"URI1\" as X, \"URI2\" as Y");
        attributeTableBuilder.add((Object)ROLE_TABLE);
        ROLE_TABLE.indexOn("idxrolefull1", "URI1, URI2, IDX, ISBNODE, ISBNODE2");
        ROLE_TABLE.indexOn("idxrolefull2", "URI2, URI1, IDX, ISBNODE2, ISBNODE");
        ROLE_TABLE.indexOn("idxrolefull22", "URI1, URI2, IDX");
        ImmutableMap.Builder datatypeTableMapBuilder = ImmutableMap.builder();
        TableDescription LANG_STRING_TABLE = new TableDescription("QUEST_DATA_PROPERTY_LITERAL_ASSERTION", (ImmutableMap<String, String>)ImmutableMap.of((Object)"\"URI\"", (Object)"INTEGER NOT NULL", (Object)"VAL", (Object)"VARCHAR(1000) NOT NULL", (Object)"\"IDX\"", (Object)"SMALLINT NOT NULL", (Object)"LANG", (Object)"VARCHAR(20)", (Object)"ISBNODE", (Object)"BOOLEAN NOT NULL DEFAULT FALSE"), "\"URI\" as X, VAL as Y, LANG as Z");
        attributeTableBuilder.add((Object)LANG_STRING_TABLE);
        datatypeTableMapBuilder.put((Object)RDF.LANGSTRING, (Object)LANG_STRING_TABLE);
        LANG_STRING_TABLE.indexOn("IDX_LITERAL_ATTRIBUTE1", "URI");
        LANG_STRING_TABLE.indexOn("IDX_LITERAL_ATTRIBUTE2", "IDX");
        LANG_STRING_TABLE.indexOn("IDX_LITERAL_ATTRIBUTE3", "VAL");
        ArrayList<AttributeTableDescritpion> attributeDescriptions = new ArrayList<AttributeTableDescritpion>();
        attributeDescriptions.add(new AttributeTableDescritpion(XSD.STRING, "QUEST_DATA_PROPERTY_STRING_ASSERTION", "VARCHAR(1000)", "IDX_STRING_ATTRIBUTE"));
        attributeDescriptions.add(new AttributeTableDescritpion(XSD.INTEGER, "QUEST_DATA_PROPERTY_INTEGER_ASSERTION", "BIGINT", "IDX_INTEGER_ATTRIBUTE"));
        attributeDescriptions.add(new AttributeTableDescritpion(XSD.INT, "QUEST_DATA_PROPERTY_INT_ASSERTION", "INTEGER", "XSD_INT_ATTRIBUTE"));
        attributeDescriptions.add(new AttributeTableDescritpion(XSD.UNSIGNED_INT, "QUEST_DATA_PROPERTY_UNSIGNED_INT_ASSERTION", "INTEGER", "XSD_UNSIGNED_INT_ATTRIBUTE"));
        attributeDescriptions.add(new AttributeTableDescritpion(XSD.NEGATIVE_INTEGER, "QUEST_DATA_PROPERTY_NEGATIVE_INTEGER_ASSERTION", "BIGINT", "XSD_NEGATIVE_INTEGER_ATTRIBUTE"));
        attributeDescriptions.add(new AttributeTableDescritpion(XSD.NON_NEGATIVE_INTEGER, "QUEST_DATA_PROPERTY_NON_NEGATIVE_INTEGER_ASSERTION", "BIGINT", "XSD_NON_NEGATIVE_INTEGER_ATTRIBUTE"));
        attributeDescriptions.add(new AttributeTableDescritpion(XSD.POSITIVE_INTEGER, "QUEST_DATA_PROPERTY_POSITIVE_INTEGER_ASSERTION", "BIGINT", "XSD_POSITIVE_INTEGER_ATTRIBUTE"));
        attributeDescriptions.add(new AttributeTableDescritpion(XSD.NON_POSITIVE_INTEGER, "QUEST_DATA_PROPERTY_NON_POSITIVE_INTEGER_ASSERTION", "BIGINT", "XSD_NON_POSITIVE_INTEGER_ATTRIBUTE"));
        attributeDescriptions.add(new AttributeTableDescritpion(XSD.LONG, "QUEST_DATA_PROPERTY_LONG_ASSERTION", "BIGINT", "IDX_LONG_ATTRIBUTE"));
        attributeDescriptions.add(new AttributeTableDescritpion(XSD.DECIMAL, "QUEST_DATA_PROPERTY_DECIMAL_ASSERTION", "DECIMAL", "IDX_DECIMAL_ATTRIBUTE"));
        attributeDescriptions.add(new AttributeTableDescritpion(XSD.FLOAT, "QUEST_DATA_PROPERTY_FLOAT_ASSERTION", "DOUBLE PRECISION", "XSD_FLOAT_ATTRIBUTE"));
        attributeDescriptions.add(new AttributeTableDescritpion(XSD.DOUBLE, "QUEST_DATA_PROPERTY_DOUBLE_ASSERTION", "DOUBLE PRECISION", "IDX_DOUBLE_ATTRIBUTE"));
        attributeDescriptions.add(new AttributeTableDescritpion(XSD.DATETIME, "QUEST_DATA_PROPERTY_DATETIME_ASSERTION", "TIMESTAMP", "IDX_DATETIME_ATTRIBUTE"));
        attributeDescriptions.add(new AttributeTableDescritpion(XSD.BOOLEAN, "QUEST_DATA_PROPERTY_BOOLEAN_ASSERTION", "BOOLEAN", "IDX_BOOLEAN_ATTRIBUTE"));
        attributeDescriptions.add(new AttributeTableDescritpion(XSD.DATETIMESTAMP, "QUEST_DATA_PROPERTY_DATETIMESTAMP_ASSERTION", "TIMESTAMP", "IDX_DATETIMESTAMP_ATTRIBUTE"));
        for (AttributeTableDescritpion description : attributeDescriptions) {
            TableDescription table = new TableDescription(description.tableName, (ImmutableMap<String, String>)ImmutableMap.of((Object)"\"URI\"", (Object)"INTEGER NOT NULL", (Object)"VAL", (Object)description.sqlTypeName, (Object)"\"IDX\"", (Object)"SMALLINT  NOT NULL", (Object)"ISBNODE", (Object)"BOOLEAN NOT NULL DEFAULT FALSE"), "\"URI\" as X, VAL as Y");
            table.indexOn(description.indexName + "1", "URI");
            table.indexOn(description.indexName + "2", "IDX");
            table.indexOn(description.indexName + "3", "VAL");
            attributeTableBuilder.add((Object)table);
            datatypeTableMapBuilder.put((Object)description.datatypeIRI, (Object)table);
        }
        attributeTables = attributeTableBuilder.build();
        ATTRIBUTE_TABLE_MAP = datatypeTableMapBuilder.build();
    }

    private static final class AttributeTableDescritpion {
        final IRI datatypeIRI;
        final String tableName;
        final String sqlTypeName;
        final String indexName;

        public AttributeTableDescritpion(IRI datatypeIRI, String tableName, String sqlTypeName, String indexName) {
            this.datatypeIRI = datatypeIRI;
            this.tableName = tableName;
            this.sqlTypeName = sqlTypeName;
            this.indexName = indexName;
        }
    }

    static final class TableDescription {
        final String tableName;
        final String createCommand;
        private final String insertCommand;
        private final String selectCommand;
        private final List<String> createIndexCommands = new ArrayList<String>(3);
        private final List<String> dropIndexCommands = new ArrayList<String>(3);

        TableDescription(String tableName, ImmutableMap<String, String> columnDefintions, String selectColumns) {
            this.tableName = tableName;
            this.createCommand = "CREATE TABLE " + tableName + " ( " + Joiner.on((String)", ").withKeyValueSeparator(" ").join(columnDefintions) + " )";
            this.insertCommand = "INSERT INTO " + tableName + " (" + Joiner.on((String)", ").join((Iterable)columnDefintions.keySet()) + ") VALUES (";
            this.selectCommand = "SELECT " + selectColumns + " FROM " + tableName;
        }

        String getINSERT(String values) {
            return this.insertCommand + values + ")";
        }

        String getSELECT(String filter) {
            return this.selectCommand + " WHERE " + filter;
        }

        String getSELECT() {
            return this.selectCommand;
        }

        void indexOn(String indexName, String columns) {
            this.createIndexCommands.add("CREATE INDEX " + indexName + " ON " + this.tableName + " (" + columns + ")");
            this.dropIndexCommands.add("DROP INDEX " + indexName);
        }
    }
}

