/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.si.repository.impl;

import it.unibz.inf.ontop.si.repository.impl.SemanticIndexRange;
import it.unibz.inf.ontop.spec.ontology.ClassExpression;
import it.unibz.inf.ontop.spec.ontology.ClassifiedTBox;
import it.unibz.inf.ontop.spec.ontology.DataPropertyExpression;
import it.unibz.inf.ontop.spec.ontology.Equivalences;
import it.unibz.inf.ontop.spec.ontology.EquivalencesDAG;
import it.unibz.inf.ontop.spec.ontology.OClass;
import it.unibz.inf.ontop.spec.ontology.ObjectPropertyExpression;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.event.ConnectedComponentTraversalEvent;
import org.jgrapht.event.TraversalListenerAdapter;
import org.jgrapht.event.VertexTraversalEvent;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.EdgeReversedGraph;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.jgrapht.traverse.DepthFirstIterator;

public class SemanticIndexBuilder {
    private final Map<ClassExpression, SemanticIndexRange> classRanges;
    private final Map<ObjectPropertyExpression, SemanticIndexRange> opRanges;
    private final Map<DataPropertyExpression, SemanticIndexRange> dpRanges;
    private int index_counter = 1;

    private <T> Map<T, SemanticIndexRange> createSemanticIndex(EquivalencesDAG<T> dag) {
        SimpleDirectedGraph<T, DefaultEdge> namedDag = SemanticIndexBuilder.getNamedDAG(dag);
        EdgeReversedGraph reversed = new EdgeReversedGraph(namedDag);
        LinkedList roots = new LinkedList();
        for (Object n : reversed.vertexSet()) {
            if (!reversed.incomingEdgesOf(n).isEmpty()) continue;
            roots.add(n);
        }
        HashMap ranges = new HashMap();
        for (Object root : roots) {
            DepthFirstIterator orderIterator = new DepthFirstIterator((Graph)reversed, root);
            orderIterator.addTraversalListener(new SemanticIndexer(reversed, ranges));
            while (orderIterator.hasNext()) {
                orderIterator.next();
            }
        }
        return ranges;
    }

    public static <T> SimpleDirectedGraph<T, DefaultEdge> getNamedDAG(EquivalencesDAG<T> dag) {
        SimpleDirectedGraph namedDAG = new SimpleDirectedGraph(DefaultEdge.class);
        for (Equivalences v : dag) {
            namedDAG.addVertex(v.getRepresentative());
        }
        for (Equivalences s : dag) {
            for (Equivalences t : dag.getDirectSuper(s)) {
                namedDAG.addEdge(s.getRepresentative(), t.getRepresentative());
            }
        }
        for (Equivalences v : dag) {
            if (v.isIndexed()) continue;
            for (DefaultEdge incEdge : namedDAG.incomingEdgesOf(v.getRepresentative())) {
                Object source = namedDAG.getEdgeSource((Object)incEdge);
                for (DefaultEdge outEdge : namedDAG.outgoingEdgesOf(v.getRepresentative())) {
                    Object target = namedDAG.getEdgeTarget((Object)outEdge);
                    namedDAG.addEdge(source, target);
                }
            }
            namedDAG.removeVertex(v.getRepresentative());
        }
        return namedDAG;
    }

    public SemanticIndexBuilder(ClassifiedTBox reasoner) {
        this.classRanges = this.createSemanticIndex(reasoner.classesDAG());
        this.opRanges = this.createSemanticIndex(reasoner.objectPropertiesDAG());
        this.dpRanges = this.createSemanticIndex(reasoner.dataPropertiesDAG());
    }

    public Set<Map.Entry<ClassExpression, SemanticIndexRange>> getIndexedClasses() {
        return this.classRanges.entrySet();
    }

    public Set<Map.Entry<ObjectPropertyExpression, SemanticIndexRange>> getIndexedObjectProperties() {
        return this.opRanges.entrySet();
    }

    public Set<Map.Entry<DataPropertyExpression, SemanticIndexRange>> getIndexedDataProperties() {
        return this.dpRanges.entrySet();
    }

    public SemanticIndexRange getRange(OClass d) {
        return this.classRanges.get(d);
    }

    public SemanticIndexRange getRange(ObjectPropertyExpression d) {
        return this.opRanges.get(d);
    }

    public SemanticIndexRange getRange(DataPropertyExpression d) {
        return this.dpRanges.get(d);
    }

    private final class SemanticIndexer<T>
    extends TraversalListenerAdapter<T, DefaultEdge> {
        private T reference;
        private boolean newComponent = true;
        private final DirectedGraph<T, DefaultEdge> namedDAG;
        private final Map<T, SemanticIndexRange> ranges;

        public SemanticIndexer(DirectedGraph<T, DefaultEdge> namedDAG, Map<T, SemanticIndexRange> ranges) {
            this.namedDAG = namedDAG;
            this.ranges = ranges;
        }

        public void connectedComponentStarted(ConnectedComponentTraversalEvent e) {
            this.newComponent = true;
        }

        public void vertexTraversed(VertexTraversalEvent<T> e) {
            Object vertex = e.getVertex();
            if (this.newComponent) {
                this.reference = vertex;
                this.newComponent = false;
            }
            this.ranges.put(vertex, new SemanticIndexRange(SemanticIndexBuilder.this.index_counter));
            SemanticIndexBuilder.this.index_counter++;
        }

        public void connectedComponentFinished(ConnectedComponentTraversalEvent e) {
            this.mergeRangeNode(this.reference);
        }

        private void mergeRangeNode(T d) {
            for (Object ch : Graphs.successorListOf(this.namedDAG, d)) {
                if (ch.equals(d)) continue;
                this.mergeRangeNode(ch);
                this.ranges.get(d).addRange(this.ranges.get(ch).getIntervals());
            }
        }
    }
}

