/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.si.impl;

import it.unibz.inf.ontop.model.term.IRIConstant;
import it.unibz.inf.ontop.model.term.ObjectConstant;
import it.unibz.inf.ontop.model.term.RDFLiteralConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.si.OntopSemanticIndexLoader;
import it.unibz.inf.ontop.si.SemanticIndexException;
import it.unibz.inf.ontop.si.impl.LoadingConfiguration;
import it.unibz.inf.ontop.si.impl.OntopSemanticIndexLoaderImpl;
import it.unibz.inf.ontop.si.repository.impl.SIRepository;
import it.unibz.inf.ontop.spec.ontology.ABoxAssertionSupplier;
import it.unibz.inf.ontop.spec.ontology.Assertion;
import it.unibz.inf.ontop.spec.ontology.InconsistentOntologyException;
import it.unibz.inf.ontop.spec.ontology.Ontology;
import it.unibz.inf.ontop.spec.ontology.OntologyBuilder;
import it.unibz.inf.ontop.spec.ontology.impl.OntologyBuilderImpl;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.rio.ParserConfig;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFHandler;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDF4JGraphLoading {
    private static final Logger LOG = LoggerFactory.getLogger(RDF4JGraphLoading.class);

    public static OntopSemanticIndexLoader loadRDFGraph(Dataset dataset, Properties properties) throws SemanticIndexException {
        HashSet graphURLs = new HashSet();
        graphURLs.addAll(dataset.getDefaultGraphs());
        graphURLs.addAll(dataset.getNamedGraphs());
        LoadingConfiguration loadingConfiguration = new LoadingConfiguration();
        org.apache.commons.rdf.api.RDF rdfFactory = loadingConfiguration.getRdfFactory();
        CollectRDFVocabulary collectVocabulary = new CollectRDFVocabulary(rdfFactory);
        for (IRI graphURL : graphURLs) {
            RDF4JGraphLoading.processRDF(collectVocabulary, graphURL);
        }
        Ontology vocabulary = collectVocabulary.vb.build();
        SIRepository repo = new SIRepository(vocabulary.tbox(), loadingConfiguration);
        Connection connection = repo.createConnection();
        SemanticIndexRDFHandler insertData = new SemanticIndexRDFHandler(repo, connection, loadingConfiguration.getTypeFactory(), loadingConfiguration.getTermFactory(), rdfFactory);
        for (IRI graphURL : graphURLs) {
            RDF4JGraphLoading.processRDF(insertData, graphURL);
        }
        LOG.info("Inserted {} triples", (Object)insertData.count);
        return new OntopSemanticIndexLoaderImpl(repo, connection, properties, Optional.empty());
    }

    private static void processRDF(AbstractRDFHandler rdfHandler, IRI graphURL) throws SemanticIndexException {
        RDFFormat rdfFormat = (RDFFormat)Rio.getParserFormatForFileName((String)graphURL.toString()).get();
        RDFParser rdfParser = Rio.createParser((RDFFormat)rdfFormat);
        ParserConfig config = rdfParser.getParserConfig();
        config.addNonFatalError(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES);
        config.addNonFatalError(BasicParserSettings.VERIFY_DATATYPE_VALUES);
        config.addNonFatalError(BasicParserSettings.NORMALIZE_DATATYPE_VALUES);
        rdfParser.setRDFHandler((RDFHandler)rdfHandler);
        InputStream in = null;
        try {
            URL url = new URL(graphURL.toString());
            in = url.openStream();
            rdfParser.parse(in, graphURL.toString());
        }
        catch (IOException e) {
            throw new SemanticIndexException(e.getMessage());
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                throw new SemanticIndexException(e.getMessage());
            }
        }
    }

    private static final class SemanticIndexRDFHandler
    extends AbstractRDFHandler {
        private final SIRepository repository;
        private final Connection connection;
        private final ABoxAssertionSupplier builder;
        private final TypeFactory typeFactory;
        private final TermFactory termFactory;
        private static final int MAX_BUFFER_SIZE = 5000;
        private List<Statement> buffer = new ArrayList<Statement>(5000);
        private int count = 0;
        private final org.apache.commons.rdf.api.RDF rdfFactory;

        public SemanticIndexRDFHandler(SIRepository repository, Connection connection, TypeFactory typeFactory, TermFactory termFactory, org.apache.commons.rdf.api.RDF rdfFactory) {
            this.repository = repository;
            this.typeFactory = typeFactory;
            this.termFactory = termFactory;
            this.builder = OntologyBuilderImpl.assertionSupplier((org.apache.commons.rdf.api.RDF)rdfFactory);
            this.connection = connection;
            this.rdfFactory = rdfFactory;
        }

        public void endRDF() throws RDFHandlerException {
            this.loadBuffer();
        }

        public void handleStatement(Statement st) throws RDFHandlerException {
            this.buffer.add(st);
            if (this.buffer.size() == 5000) {
                this.loadBuffer();
            }
        }

        private void loadBuffer() throws RDFHandlerException {
            try {
                Iterator<Assertion> assertionIterator = this.buffer.stream().map(st -> this.constructAssertion((Statement)st, this.builder)).iterator();
                this.count += this.repository.insertData(this.connection, assertionIterator);
                this.buffer.clear();
            }
            catch (Exception e) {
                throw new RDFHandlerException((Throwable)e);
            }
        }

        private Assertion constructAssertion(Statement st, ABoxAssertionSupplier builder) {
            IRIConstant c;
            Resource subject = st.getSubject();
            if (subject instanceof IRI) {
                c = this.termFactory.getConstantIRI(this.rdfFactory.createIRI(subject.stringValue()));
            } else if (subject instanceof BNode) {
                c = this.termFactory.getConstantBNode(subject.stringValue());
            } else {
                throw new RuntimeException("Unsupported subject found in triple: " + st + " (Required URI or BNode)");
            }
            String predicateName = st.getPredicate().stringValue();
            Value object = st.getObject();
            try {
                if (predicateName.equals(RDF.TYPE.stringValue())) {
                    return builder.createClassAssertion(object.stringValue(), (ObjectConstant)c);
                }
                if (object instanceof IRI) {
                    IRIConstant c2 = this.termFactory.getConstantIRI(this.rdfFactory.createIRI(object.stringValue()));
                    return builder.createObjectPropertyAssertion(predicateName, (ObjectConstant)c, (ObjectConstant)c2);
                }
                if (object instanceof BNode) {
                    it.unibz.inf.ontop.model.term.BNode c2 = this.termFactory.getConstantBNode(object.stringValue());
                    return builder.createObjectPropertyAssertion(predicateName, (ObjectConstant)c, (ObjectConstant)c2);
                }
                if (object instanceof Literal) {
                    RDFLiteralConstant c2;
                    Literal l = (Literal)object;
                    Optional lang = l.getLanguage();
                    if (!lang.isPresent()) {
                        IRI datatype = l.getDatatype();
                        RDFDatatype type = datatype == null ? this.typeFactory.getXsdStringDatatype() : this.typeFactory.getDatatype(this.rdfFactory.createIRI(datatype.stringValue()));
                        c2 = this.termFactory.getRDFLiteralConstant(l.getLabel(), type);
                    } else {
                        c2 = this.termFactory.getRDFLiteralConstant(l.getLabel(), (String)lang.get());
                    }
                    return builder.createDataPropertyAssertion(predicateName, (ObjectConstant)c, c2);
                }
                throw new RuntimeException("Unsupported object found in triple: " + st + " (Required URI, BNode or Literal)");
            }
            catch (InconsistentOntologyException e) {
                throw new RuntimeException("InconsistentOntologyException: " + st);
            }
        }
    }

    private static final class CollectRDFVocabulary
    extends AbstractRDFHandler {
        private final OntologyBuilder vb;
        private final org.apache.commons.rdf.api.RDF rdfFactory;

        CollectRDFVocabulary(org.apache.commons.rdf.api.RDF rdfFactory) {
            this.rdfFactory = rdfFactory;
            this.vb = OntologyBuilderImpl.builder((org.apache.commons.rdf.api.RDF)rdfFactory);
        }

        public void handleStatement(Statement st) throws RDFHandlerException {
            String predicateName = st.getPredicate().stringValue();
            Value obj = st.getObject();
            if (predicateName.equals(RDF.TYPE.stringValue())) {
                this.vb.declareClass(this.rdfFactory.createIRI(obj.stringValue()));
            } else if (obj instanceof Literal) {
                this.vb.declareDataProperty(this.rdfFactory.createIRI(predicateName));
            } else {
                this.vb.declareObjectProperty(this.rdfFactory.createIRI(predicateName));
            }
        }
    }
}

