/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.si.impl;

import it.unibz.inf.ontop.injection.OntopSQLOWLAPIConfiguration;
import it.unibz.inf.ontop.si.OntopSemanticIndexLoader;
import it.unibz.inf.ontop.si.repository.impl.SIRepository;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.semanticweb.owlapi.model.OWLOntology;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OntopSemanticIndexLoaderImpl
implements OntopSemanticIndexLoader {
    private static final Logger LOG = LoggerFactory.getLogger(OntopSemanticIndexLoaderImpl.class);
    private final OntopSQLOWLAPIConfiguration configuration;
    private final Connection connection;

    OntopSemanticIndexLoaderImpl(SIRepository repo, Connection connection, Properties properties, Optional<OWLOntology> tbox) {
        this.connection = connection;
        Properties newProperties = new Properties();
        newProperties.putAll((Map<?, ?>)properties);
        newProperties.putIfAbsent("ontop.cardinalityMode", "LOOSE");
        OntopSQLOWLAPIConfiguration.Builder builder = (OntopSQLOWLAPIConfiguration.Builder)((OntopSQLOWLAPIConfiguration.Builder)((OntopSQLOWLAPIConfiguration.Builder)((OntopSQLOWLAPIConfiguration.Builder)((OntopSQLOWLAPIConfiguration.Builder)((OntopSQLOWLAPIConfiguration.Builder)((OntopSQLOWLAPIConfiguration.Builder)OntopSQLOWLAPIConfiguration.defaultBuilder().ppMapping(repo.createMappings())).properties(newProperties)).jdbcUrl(repo.getJdbcUrl())).jdbcUser(repo.getUser())).jdbcPassword(repo.getPassword())).jdbcDriver(repo.getJdbcDriver())).keepPermanentDBConnection(true);
        tbox.ifPresent(arg_0 -> ((OntopSQLOWLAPIConfiguration.Builder)builder).ontology(arg_0));
        this.configuration = builder.build();
    }

    @Override
    public OntopSQLOWLAPIConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void close() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            LOG.error("Error while closing the DB: " + e.getMessage());
        }
    }
}

