/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.si;

import it.unibz.inf.ontop.injection.OntopSQLOWLAPIConfiguration;
import it.unibz.inf.ontop.si.SemanticIndexException;
import it.unibz.inf.ontop.si.impl.OWLAPIABoxLoading;
import it.unibz.inf.ontop.si.impl.OntopRDFMaterializerLoading;
import it.unibz.inf.ontop.si.impl.RDF4JGraphLoading;
import java.io.File;
import java.util.Properties;
import org.eclipse.rdf4j.query.Dataset;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;

public interface OntopSemanticIndexLoader
extends AutoCloseable {
    public OntopSQLOWLAPIConfiguration getConfiguration();

    @Override
    public void close();

    public static OntopSemanticIndexLoader loadOntologyIndividuals(OWLOntology ontology, Properties properties) throws SemanticIndexException {
        return OWLAPIABoxLoading.loadOntologyIndividuals(ontology, properties);
    }

    public static OntopSemanticIndexLoader loadOntologyIndividuals(String ontologyFilePath, Properties properties) throws SemanticIndexException {
        try {
            OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
            OWLOntology ontology = manager.loadOntologyFromOntologyDocument(new File(ontologyFilePath));
            return OWLAPIABoxLoading.loadOntologyIndividuals(ontology, properties);
        }
        catch (OWLOntologyCreationException e) {
            throw new SemanticIndexException(e.getMessage());
        }
    }

    public static OntopSemanticIndexLoader loadRDFGraph(Dataset dataset, Properties properties) throws SemanticIndexException {
        return RDF4JGraphLoading.loadRDFGraph(dataset, properties);
    }

    public static OntopSemanticIndexLoader loadVirtualAbox(OntopSQLOWLAPIConfiguration obdaConfiguration, Properties properties) throws SemanticIndexException {
        return OntopRDFMaterializerLoading.loadVirtualAbox(obdaConfiguration, properties);
    }
}

