/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.si.repository.impl;

import it.unibz.inf.ontop.si.repository.impl.SemanticIndexBuilder;
import it.unibz.inf.ontop.si.repository.impl.SemanticIndexRange;
import it.unibz.inf.ontop.spec.ontology.ClassExpression;
import it.unibz.inf.ontop.spec.ontology.ClassifiedTBox;
import it.unibz.inf.ontop.spec.ontology.DataPropertyExpression;
import it.unibz.inf.ontop.spec.ontology.OClass;
import it.unibz.inf.ontop.spec.ontology.ObjectPropertyExpression;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SemanticIndexCache {
    private final Map<OClass, SemanticIndexRange> classRanges = new HashMap<OClass, SemanticIndexRange>();
    private final Map<ObjectPropertyExpression, SemanticIndexRange> opeRanges = new HashMap<ObjectPropertyExpression, SemanticIndexRange>();
    private final Map<DataPropertyExpression, SemanticIndexRange> dpeRanges = new HashMap<DataPropertyExpression, SemanticIndexRange>();
    private final ClassifiedTBox reasonerDag;

    public SemanticIndexCache(ClassifiedTBox reasonerDag) {
        this.reasonerDag = reasonerDag;
    }

    public void buildSemanticIndexFromReasoner() {
        SemanticIndexBuilder engine = new SemanticIndexBuilder(this.reasonerDag);
        for (Map.Entry<ClassExpression, SemanticIndexRange> entry : engine.getIndexedClasses()) {
            OClass cdesc = (OClass)entry.getKey();
            this.classRanges.put(cdesc, entry.getValue());
        }
        for (Map.Entry<ClassExpression, SemanticIndexRange> entry : engine.getIndexedObjectProperties()) {
            this.opeRanges.put((ObjectPropertyExpression)entry.getKey(), entry.getValue());
        }
        for (Map.Entry<ClassExpression, SemanticIndexRange> entry : engine.getIndexedDataProperties()) {
            this.dpeRanges.put((DataPropertyExpression)entry.getKey(), entry.getValue());
        }
    }

    public SemanticIndexRange getEntry(OClass concept) {
        return this.classRanges.get(concept);
    }

    public SemanticIndexRange getEntry(ObjectPropertyExpression ope) {
        return this.opeRanges.get(ope);
    }

    public SemanticIndexRange getEntry(DataPropertyExpression dpe) {
        return this.dpeRanges.get(dpe);
    }

    public void setIndex(OClass concept, int idx) {
        SemanticIndexRange range = new SemanticIndexRange(idx);
        this.classRanges.put(concept, range);
    }

    public void setIndex(ObjectPropertyExpression ope, Integer idx) {
        SemanticIndexRange range = new SemanticIndexRange(idx);
        this.opeRanges.put(ope, range);
    }

    public void setIndex(DataPropertyExpression dpe, Integer idx) {
        SemanticIndexRange range = new SemanticIndexRange(idx);
        this.dpeRanges.put(dpe, range);
    }

    public Set<Map.Entry<OClass, SemanticIndexRange>> getClassIndexEntries() {
        return this.classRanges.entrySet();
    }

    public Set<Map.Entry<ObjectPropertyExpression, SemanticIndexRange>> getObjectPropertyIndexEntries() {
        return this.opeRanges.entrySet();
    }

    public Set<Map.Entry<DataPropertyExpression, SemanticIndexRange>> getDataPropertyIndexEntries() {
        return this.dpeRanges.entrySet();
    }
}

