/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.si.impl;

import com.google.inject.Injector;
import it.unibz.inf.ontop.injection.OntopSQLCoreConfiguration;
import it.unibz.inf.ontop.model.atom.TargetAtomFactory;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.spec.ontology.owlapi.OWLAPITranslatorOWL2QL;
import java.util.UUID;
import org.apache.commons.rdf.api.RDF;

public class LoadingConfiguration {
    private final OWLAPITranslatorOWL2QL translatorOWL2QL;
    private final String jdbcUrl = "jdbc:h2:mem:questrepository:" + UUID.randomUUID() + ";LOG=0;CACHE_SIZE=65536;LOCK_MODE=0;UNDO_LOG=0";
    private static final String H2_DRIVER = "org.h2.Driver";
    private final TermFactory termFactory;
    private final TypeFactory typeFactory;
    private final TargetAtomFactory targetAtomFactory;
    private final RDF rdfFactory;

    public LoadingConfiguration() {
        OntopSQLCoreConfiguration defaultConfiguration = OntopSQLCoreConfiguration.defaultBuilder().jdbcDriver(H2_DRIVER).jdbcUrl(this.jdbcUrl).build();
        Injector injector = defaultConfiguration.getInjector();
        this.termFactory = defaultConfiguration.getTermFactory();
        this.typeFactory = defaultConfiguration.getTypeFactory();
        this.translatorOWL2QL = (OWLAPITranslatorOWL2QL)injector.getInstance(OWLAPITranslatorOWL2QL.class);
        this.targetAtomFactory = (TargetAtomFactory)defaultConfiguration.getInjector().getInstance(TargetAtomFactory.class);
        this.rdfFactory = (RDF)injector.getInstance(RDF.class);
    }

    public OWLAPITranslatorOWL2QL getTranslatorOWL2QL() {
        return this.translatorOWL2QL;
    }

    public TermFactory getTermFactory() {
        return this.termFactory;
    }

    public TypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    public TargetAtomFactory getTargetAtomFactory() {
        return this.targetAtomFactory;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getJdbcDriver() {
        return H2_DRIVER;
    }

    public RDF getRdfFactory() {
        return this.rdfFactory;
    }
}

