/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.impl;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.IncrementalEvaluation;
import it.unibz.inf.ontop.model.term.NonNullConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.IRIDictionary;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.FunctionSymbolImpl;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TermTypeInference;
import java.util.Optional;
import javax.annotation.Nonnull;

public class Int2IRIStringFunctionSymbolImpl
extends FunctionSymbolImpl {
    private final DBTermType dbStringType;
    private final IRIDictionary iriDictionary;

    public Int2IRIStringFunctionSymbolImpl(@Nonnull DBTermType integerType, @Nonnull DBTermType dbStringType, @Nonnull IRIDictionary iriDictionary) {
        super("int2IRIString-" + iriDictionary.toString(), ImmutableList.of((Object)integerType));
        this.dbStringType = dbStringType;
        this.iriDictionary = iriDictionary;
    }

    protected boolean tolerateNulls() {
        return false;
    }

    protected boolean mayReturnNullWithoutNullArguments() {
        return false;
    }

    public boolean isAlwaysInjectiveInTheAbsenceOfNonInjectiveFunctionalTerms() {
        return true;
    }

    public Optional<TermTypeInference> inferType(ImmutableList<? extends ImmutableTerm> terms) {
        return Optional.of(TermTypeInference.declareTermType((TermType)this.dbStringType));
    }

    public boolean canBePostProcessed(ImmutableList<? extends ImmutableTerm> arguments) {
        return true;
    }

    protected ImmutableTerm buildTermAfterEvaluation(ImmutableList<ImmutableTerm> newTerms, TermFactory termFactory, VariableNullability variableNullability) {
        ImmutableTerm newTerm = (ImmutableTerm)newTerms.get(0);
        if (newTerm instanceof DBConstant) {
            try {
                int id = Integer.parseInt(((DBConstant)newTerm).getValue());
                return (ImmutableTerm)Optional.ofNullable(this.iriDictionary.getURI(id)).map(arg_0 -> ((TermFactory)termFactory).getDBStringConstant(arg_0)).orElseThrow(() -> new MinorOntopInternalBugException("Unknown encoded ID used: " + id));
            }
            catch (NumberFormatException e) {
                throw new MinorOntopInternalBugException(this.getName() + " was expecting an integer, not " + newTerm);
            }
        }
        return termFactory.getImmutableFunctionalTerm((FunctionSymbol)this, new ImmutableTerm[]{newTerm});
    }

    protected IncrementalEvaluation evaluateStrictEqWithNonNullConstant(ImmutableList<? extends ImmutableTerm> terms, NonNullConstant otherTerm, TermFactory termFactory, VariableNullability variableNullability) {
        ImmutableTerm subTerm = (ImmutableTerm)terms.get(0);
        return Optional.ofNullable(this.iriDictionary.getId(otherTerm.getValue())).filter(id -> id >= 0).map(arg_0 -> ((TermFactory)termFactory).getDBIntegerConstant(arg_0)).map(i -> termFactory.getStrictEquality(subTerm, (ImmutableTerm)i, new ImmutableTerm[0])).map(IncrementalEvaluation::declareSimplifiedExpression).orElseGet(IncrementalEvaluation::declareIsFalse);
    }
}

