/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.injection.impl;

import com.google.inject.Module;
import it.unibz.inf.ontop.exception.InvalidOntopConfigurationException;
import it.unibz.inf.ontop.injection.OntopModelConfiguration;
import it.unibz.inf.ontop.injection.OntopReformulationSQLConfiguration;
import it.unibz.inf.ontop.injection.OntopReformulationSQLSettings;
import it.unibz.inf.ontop.injection.OntopReformulationSettings;
import it.unibz.inf.ontop.injection.OntopSQLCoreConfiguration;
import it.unibz.inf.ontop.injection.OntopSQLCoreSettings;
import it.unibz.inf.ontop.injection.impl.OntopAbstractModule;
import it.unibz.inf.ontop.injection.impl.OntopModelConfigurationImpl;
import it.unibz.inf.ontop.injection.impl.OntopReformulationConfigurationImpl;
import it.unibz.inf.ontop.injection.impl.OntopReformulationPostModule;
import it.unibz.inf.ontop.injection.impl.OntopReformulationSQLModule;
import it.unibz.inf.ontop.injection.impl.OntopReformulationSQLSettingsImpl;
import it.unibz.inf.ontop.injection.impl.OntopSQLCoreConfigurationImpl;
import it.unibz.inf.ontop.injection.impl.SpecificationLoader;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class OntopReformulationSQLConfigurationImpl
extends OntopReformulationConfigurationImpl
implements OntopReformulationSQLConfiguration {
    private final OntopReformulationSQLSettings settings;
    private final OntopSQLCoreConfigurationImpl sqlConfiguration;

    OntopReformulationSQLConfigurationImpl(OntopReformulationSQLSettings settings, OntopReformulationSQLOptions options, SpecificationLoader specificationLoader) {
        super((OntopReformulationSettings)settings, options.reformulationOptions, specificationLoader);
        this.settings = settings;
        this.sqlConfiguration = new OntopSQLCoreConfigurationImpl((OntopSQLCoreSettings)settings, options.sqlOptions);
    }

    OntopReformulationSQLConfigurationImpl(OntopReformulationSQLSettings settings, OntopReformulationSQLOptions options) {
        super((OntopReformulationSettings)settings, options.reformulationOptions);
        this.settings = settings;
        this.sqlConfiguration = new OntopSQLCoreConfigurationImpl((OntopSQLCoreSettings)settings, options.sqlOptions);
    }

    @Override
    public OntopReformulationSQLSettings getSettings() {
        return this.settings;
    }

    protected Stream<Module> buildGuiceModules() {
        return Stream.concat(Stream.concat(super.buildGuiceModules(), this.sqlConfiguration.buildGuiceModules()), Stream.of(new OntopAbstractModule[]{new OntopReformulationSQLModule(this), new OntopReformulationPostModule((OntopReformulationSettings)this.getSettings())}));
    }

    public static class BuilderImpl<B extends OntopReformulationSQLConfiguration.Builder<B>>
    extends OntopReformulationSQLBuilderMixin<B> {
        @Override
        public OntopReformulationSQLConfiguration build() {
            if (!this.isOBDASpecificationAssigned()) {
                throw new InvalidOntopConfigurationException("An OBDA specification must be assigned to directly instantiate such a OntopReformulationSQLConfiguration");
            }
            OntopReformulationSQLSettingsImpl settings = new OntopReformulationSQLSettingsImpl(this.generateProperties());
            OntopReformulationSQLOptions options = this.generateSQLReformulationOptions();
            return new OntopReformulationSQLConfigurationImpl(settings, options);
        }
    }

    static abstract class OntopReformulationSQLBuilderMixin<B extends OntopReformulationSQLConfiguration.Builder<B>>
    extends OntopReformulationConfigurationImpl.OntopReformulationBuilderMixin<B>
    implements OntopReformulationSQLConfiguration.Builder<B> {
        private final DefaultOntopReformulationSQLBuilderFragment<B> localBuilderFragment;
        private final OntopSQLCoreConfigurationImpl.DefaultOntopSQLCoreBuilderFragment<B> sqlBuilderFragment;
        private final OntopModelConfigurationImpl.DefaultOntopModelBuilderFragment<B> modelBuilderFragment;

        OntopReformulationSQLBuilderMixin() {
            OntopReformulationSQLBuilderMixin builder = this;
            this.localBuilderFragment = new DefaultOntopReformulationSQLBuilderFragment<OntopReformulationSQLBuilderMixin>(builder);
            this.sqlBuilderFragment = new OntopSQLCoreConfigurationImpl.DefaultOntopSQLCoreBuilderFragment((OntopSQLCoreConfiguration.Builder)builder);
            this.modelBuilderFragment = new OntopModelConfigurationImpl.DefaultOntopModelBuilderFragment((OntopModelConfiguration.Builder)builder);
        }

        protected Properties generateProperties() {
            Properties properties = super.generateProperties();
            properties.putAll((Map<?, ?>)this.modelBuilderFragment.generateProperties());
            properties.putAll((Map<?, ?>)this.sqlBuilderFragment.generateProperties());
            properties.putAll((Map<?, ?>)this.localBuilderFragment.generateProperties());
            return properties;
        }

        OntopReformulationSQLOptions generateSQLReformulationOptions() {
            OntopReformulationConfigurationImpl.OntopReformulationOptions reformulationOptions = this.generateReformulationOptions();
            OntopSQLCoreConfigurationImpl.OntopSQLCoreOptions sqlOptions = this.sqlBuilderFragment.generateSQLCoreOptions(reformulationOptions.obdaOptions.modelOptions);
            return new OntopReformulationSQLOptions(reformulationOptions, sqlOptions);
        }

        public B jdbcName(String dbName) {
            return (B)((OntopReformulationSQLConfiguration.Builder)this.sqlBuilderFragment.jdbcName(dbName));
        }

        public B jdbcUrl(String jdbcUrl) {
            return (B)((OntopReformulationSQLConfiguration.Builder)this.sqlBuilderFragment.jdbcUrl(jdbcUrl));
        }

        public B jdbcDriver(String jdbcDriver) {
            return (B)((OntopReformulationSQLConfiguration.Builder)this.sqlBuilderFragment.jdbcDriver(jdbcDriver));
        }

        public B properties(@Nonnull Properties properties) {
            return (B)((OntopReformulationSQLConfiguration.Builder)this.modelBuilderFragment.properties(properties));
        }

        public B propertyFile(String propertyFilePath) {
            return (B)((OntopReformulationSQLConfiguration.Builder)this.modelBuilderFragment.propertyFile(propertyFilePath));
        }

        public B propertyFile(File propertyFile) {
            return (B)((OntopReformulationSQLConfiguration.Builder)this.modelBuilderFragment.propertyFile(propertyFile));
        }

        public B enableTestMode() {
            return (B)((OntopReformulationSQLConfiguration.Builder)this.modelBuilderFragment.enableTestMode());
        }
    }

    static class DefaultOntopReformulationSQLBuilderFragment<B extends OntopReformulationSQLConfiguration.Builder<B>>
    implements OntopReformulationSQLConfiguration.OntopReformulationSQLBuilderFragment<B> {
        private final B builder;

        DefaultOntopReformulationSQLBuilderFragment(B builder) {
            this.builder = builder;
        }

        OntopReformulationSQLOptions generateSQLReformulationOptions(OntopReformulationConfigurationImpl.OntopReformulationOptions qaOptions, OntopSQLCoreConfigurationImpl.OntopSQLCoreOptions sqlOptions) {
            return new OntopReformulationSQLOptions(qaOptions, sqlOptions);
        }

        Properties generateProperties() {
            return new Properties();
        }
    }

    static class OntopReformulationSQLOptions {
        final OntopReformulationConfigurationImpl.OntopReformulationOptions reformulationOptions;
        final OntopSQLCoreConfigurationImpl.OntopSQLCoreOptions sqlOptions;

        private OntopReformulationSQLOptions(OntopReformulationConfigurationImpl.OntopReformulationOptions reformulationOptions, OntopSQLCoreConfigurationImpl.OntopSQLCoreOptions sqlOptions) {
            this.reformulationOptions = reformulationOptions;
            this.sqlOptions = sqlOptions;
        }
    }
}

