/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.injection.impl;

import it.unibz.inf.ontop.answering.reformulation.generation.dialect.SQLDialectAdapter;
import it.unibz.inf.ontop.answering.reformulation.generation.normalization.DialectExtraNormalizer;
import it.unibz.inf.ontop.answering.reformulation.generation.serializer.SelectFromWhereSerializer;
import it.unibz.inf.ontop.exception.InvalidOntopConfigurationException;
import it.unibz.inf.ontop.injection.OntopReformulationSQLSettings;
import it.unibz.inf.ontop.injection.OntopSQLCoreSettings;
import it.unibz.inf.ontop.injection.impl.OntopReformulationSettingsImpl;
import it.unibz.inf.ontop.injection.impl.OntopSQLCoreSettingsImpl;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;

public class OntopReformulationSQLSettingsImpl
extends OntopReformulationSettingsImpl
implements OntopReformulationSQLSettings {
    private static final String DEFAULT_FILE = "reformulation-sql-default.properties";
    private static final String DIALECT_ADAPTER_SUFFIX = "-adapter";
    private static final String DIALECT_NORMALIZER_SUFFIX = "-normalizer";
    private static final String DIALECT_SERIALIZER_SUFFIX = "-serializer";
    private final OntopSQLCoreSettings sqlSettings = new OntopSQLCoreSettingsImpl(this.copyProperties());

    OntopReformulationSQLSettingsImpl(Properties userProperties) {
        super(OntopReformulationSQLSettingsImpl.loadProperties(userProperties));
    }

    private static Properties loadProperties(Properties userProperties) {
        Properties properties = OntopReformulationSQLSettingsImpl.loadDefaultQASQLProperties();
        properties.putAll((Map<?, ?>)userProperties);
        String jdbcUrl = Optional.ofNullable(userProperties.getProperty("jdbc.url")).orElseThrow(() -> new InvalidOntopConfigurationException("jdbc.url is required"));
        String jdbcDriver = Optional.ofNullable(userProperties.getProperty("jdbc.driver")).orElseGet(() -> {
            try {
                return DriverManager.getDriver(jdbcUrl).getClass().getCanonicalName();
            }
            catch (SQLException e) {
                throw new InvalidOntopConfigurationException("Impossible to get the JDBC driver. Reason: " + e.getMessage());
            }
        });
        properties.setProperty("jdbc.driver", jdbcDriver);
        properties.putAll((Map<?, ?>)userProperties);
        String adapterKey = jdbcDriver + DIALECT_ADAPTER_SUFFIX;
        String adapterName = SQLDialectAdapter.class.getCanonicalName();
        Optional.ofNullable(properties.getProperty(adapterKey)).filter(v -> !userProperties.containsKey(adapterName)).ifPresent(v -> properties.setProperty(adapterName, (String)v));
        String normalizerKey = jdbcDriver + DIALECT_NORMALIZER_SUFFIX;
        String normalizerName = DialectExtraNormalizer.class.getCanonicalName();
        Optional.ofNullable(properties.getProperty(normalizerKey)).filter(v -> !userProperties.containsKey(normalizerName)).ifPresent(v -> properties.setProperty(normalizerName, (String)v));
        String serializerKey = jdbcDriver + DIALECT_SERIALIZER_SUFFIX;
        String serializerName = SelectFromWhereSerializer.class.getCanonicalName();
        Optional.ofNullable(properties.getProperty(serializerKey)).filter(v -> !userProperties.containsKey(serializerName)).ifPresent(v -> properties.setProperty(serializerName, (String)v));
        return OntopSQLCoreSettingsImpl.loadSQLCoreProperties((Properties)properties);
    }

    static Properties loadDefaultQASQLProperties() {
        return OntopReformulationSQLSettingsImpl.loadDefaultPropertiesFromFile(OntopReformulationSQLSettings.class, (String)DEFAULT_FILE);
    }

    public String getJdbcUrl() {
        return this.sqlSettings.getJdbcUrl();
    }

    public String getJdbcName() {
        return this.sqlSettings.getJdbcName();
    }

    public String getJdbcDriver() {
        return this.sqlSettings.getJdbcDriver();
    }
}

