/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.answering.reformulation.generation.serializer.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.answering.reformulation.generation.algebra.BinaryJoinExpression;
import it.unibz.inf.ontop.answering.reformulation.generation.algebra.SQLExpression;
import it.unibz.inf.ontop.answering.reformulation.generation.algebra.SQLInnerJoinExpression;
import it.unibz.inf.ontop.answering.reformulation.generation.algebra.SQLLeftJoinExpression;
import it.unibz.inf.ontop.answering.reformulation.generation.algebra.SQLNaryJoinExpression;
import it.unibz.inf.ontop.answering.reformulation.generation.algebra.SQLOneTupleDummyQueryExpression;
import it.unibz.inf.ontop.answering.reformulation.generation.algebra.SQLOrderComparator;
import it.unibz.inf.ontop.answering.reformulation.generation.algebra.SQLRelationVisitor;
import it.unibz.inf.ontop.answering.reformulation.generation.algebra.SQLSerializedQuery;
import it.unibz.inf.ontop.answering.reformulation.generation.algebra.SQLTable;
import it.unibz.inf.ontop.answering.reformulation.generation.algebra.SQLUnionExpression;
import it.unibz.inf.ontop.answering.reformulation.generation.algebra.SelectFromWhereWithModifiers;
import it.unibz.inf.ontop.answering.reformulation.generation.dialect.SQLDialectAdapter;
import it.unibz.inf.ontop.answering.reformulation.generation.serializer.SQLTermSerializer;
import it.unibz.inf.ontop.answering.reformulation.generation.serializer.SelectFromWhereSerializer;
import it.unibz.inf.ontop.dbschema.DBParameters;
import it.unibz.inf.ontop.dbschema.ParserViewDefinition;
import it.unibz.inf.ontop.dbschema.QualifiedAttributeID;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.model.atom.DataAtom;
import it.unibz.inf.ontop.model.atom.RelationPredicate;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

@Singleton
public class DefaultSelectFromWhereSerializer
implements SelectFromWhereSerializer {
    private final SQLTermSerializer sqlTermSerializer;
    private final SQLDialectAdapter dialectAdapter;

    @Inject
    protected DefaultSelectFromWhereSerializer(SQLTermSerializer sqlTermSerializer, SQLDialectAdapter dialectAdapter) {
        this.sqlTermSerializer = sqlTermSerializer;
        this.dialectAdapter = dialectAdapter;
    }

    @Override
    public SelectFromWhereSerializer.QuerySerialization serialize(SelectFromWhereWithModifiers selectFromWhere, DBParameters dbParameters) {
        return selectFromWhere.acceptVisitor(new DefaultSQLRelationVisitingSerializer(this.sqlTermSerializer, this.dialectAdapter, dbParameters.getQuotedIDFactory()));
    }

    protected static class QuerySerializationImpl
    implements SelectFromWhereSerializer.QuerySerialization {
        private final String string;
        private final ImmutableMap<Variable, QualifiedAttributeID> columnIDs;

        public QuerySerializationImpl(String string, ImmutableMap<Variable, QualifiedAttributeID> columnIDs) {
            this.string = string;
            this.columnIDs = columnIDs;
        }

        @Override
        public String getString() {
            return this.string;
        }

        @Override
        public ImmutableMap<Variable, QualifiedAttributeID> getColumnIDs() {
            return this.columnIDs;
        }
    }

    protected static class DefaultSQLRelationVisitingSerializer
    implements SQLRelationVisitor<SelectFromWhereSerializer.QuerySerialization> {
        protected static final String VIEW_PREFIX = "v";
        private static final String SELECT_FROM_WHERE_MODIFIERS_TEMPLATE = "SELECT %s%s\nFROM %s\n%s%s%s%s";
        private final AtomicInteger viewCounter;
        protected final SQLTermSerializer sqlTermSerializer;
        protected final SQLDialectAdapter dialectAdapter;
        protected final QuotedIDFactory idFactory;

        protected DefaultSQLRelationVisitingSerializer(SQLTermSerializer sqlTermSerializer, SQLDialectAdapter dialectAdapter, QuotedIDFactory idFactory) {
            this.sqlTermSerializer = sqlTermSerializer;
            this.dialectAdapter = dialectAdapter;
            this.idFactory = idFactory;
            this.viewCounter = new AtomicInteger(0);
        }

        @Override
        public SelectFromWhereSerializer.QuerySerialization visit(SelectFromWhereWithModifiers selectFromWhere) {
            SelectFromWhereSerializer.QuerySerialization fromQuerySerialization = this.getSQLSerializationForChild(selectFromWhere.getFromSQLExpression());
            ImmutableMap<Variable, QualifiedAttributeID> fromColumnIDs = fromQuerySerialization.getColumnIDs();
            ImmutableMap<Variable, QualifiedAttributeID> columnsInProjectionIds = this.extractProjectionColumnMap(selectFromWhere.getProjectedVariables(), fromColumnIDs);
            String distinctString = selectFromWhere.isDistinct() ? "DISTINCT " : "";
            String projectionString = this.serializeProjection(selectFromWhere.getProjectedVariables(), columnsInProjectionIds, selectFromWhere.getSubstitution(), fromColumnIDs);
            String fromString = fromQuerySerialization.getString();
            String whereString = selectFromWhere.getWhereExpression().map(e -> this.sqlTermSerializer.serialize((ImmutableTerm)e, fromColumnIDs)).map(s -> String.format("WHERE %s\n", s)).orElse("");
            String groupByString = this.serializeGroupBy(selectFromWhere.getGroupByVariables(), fromColumnIDs);
            String orderByString = this.serializeOrderBy(selectFromWhere.getSortConditions(), fromColumnIDs);
            String sliceString = this.serializeSlice(selectFromWhere.getLimit(), selectFromWhere.getOffset());
            String sql = String.format(SELECT_FROM_WHERE_MODIFIERS_TEMPLATE, distinctString, projectionString, fromString, whereString, groupByString, orderByString, sliceString);
            RelationID alias = this.generateFreshViewAlias();
            ImmutableMap aliasedProjectedColumnIds = (ImmutableMap)columnsInProjectionIds.entrySet().stream().collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> this.createQualifiedAttributeId(alias, this.dialectAdapter.sqlQuote(((Variable)e.getKey()).getName()))));
            return new QuerySerializationImpl(sql, (ImmutableMap<Variable, QualifiedAttributeID>)aliasedProjectedColumnIds);
        }

        protected RelationID generateFreshViewAlias() {
            return this.idFactory.createRelationID(null, VIEW_PREFIX + this.viewCounter.incrementAndGet());
        }

        private QualifiedAttributeID createQualifiedAttributeId(RelationID relationID, String columnName) {
            return new QualifiedAttributeID(relationID, this.idFactory.createAttributeID(columnName));
        }

        private ImmutableMap<Variable, QualifiedAttributeID> extractProjectionColumnMap(ImmutableSortedSet<Variable> projectedVariables, ImmutableMap<Variable, QualifiedAttributeID> fromColumnMap) {
            Set quotedColumnNames = fromColumnMap.values().stream().map(QualifiedAttributeID::getSQLRendering).collect(Collectors.toSet());
            return (ImmutableMap)projectedVariables.stream().collect(ImmutableCollectors.toMap(v -> v, v -> {
                if (fromColumnMap.containsKey(v)) {
                    return (QualifiedAttributeID)fromColumnMap.get(v);
                }
                String newColumnName = this.dialectAdapter.nameTopVariable(v.getName(), quotedColumnNames);
                quotedColumnNames.add(newColumnName);
                return this.createQualifiedAttributeId(null, newColumnName);
            }));
        }

        protected String serializeProjection(ImmutableSortedSet<Variable> projectedVariables, ImmutableMap<Variable, QualifiedAttributeID> projectedColumnMap, ImmutableSubstitution<? extends ImmutableTerm> substitution, ImmutableMap<Variable, QualifiedAttributeID> fromColumnMap) {
            if (projectedVariables.isEmpty()) {
                return "1 AS uselessVariable";
            }
            return projectedVariables.stream().map(v -> Optional.ofNullable(substitution.get(v)).map(d -> this.sqlTermSerializer.serialize((ImmutableTerm)d, fromColumnMap)).map(s -> s + " AS " + projectedColumnMap.get(v)).orElseGet(() -> ((QualifiedAttributeID)projectedColumnMap.get(v)).getSQLRendering() + " AS " + this.dialectAdapter.sqlQuote(v.getName()))).collect(Collectors.joining(", "));
        }

        protected String serializeGroupBy(ImmutableSet<Variable> groupByVariables, ImmutableMap<Variable, QualifiedAttributeID> fromColumnMap) {
            if (groupByVariables.isEmpty()) {
                return "";
            }
            String variableString = groupByVariables.stream().map(v -> this.sqlTermSerializer.serialize((ImmutableTerm)v, fromColumnMap)).collect(Collectors.joining(", "));
            return String.format("GROUP BY %s\n", variableString);
        }

        protected String serializeOrderBy(ImmutableList<SQLOrderComparator> sortConditions, ImmutableMap<Variable, QualifiedAttributeID> fromColumnMap) {
            if (sortConditions.isEmpty()) {
                return "";
            }
            String conditionString = sortConditions.stream().map(c -> this.sqlTermSerializer.serialize((ImmutableTerm)c.getTerm(), fromColumnMap) + (c.isAscending() ? " NULLS FIRST" : " DESC NULLS LAST")).collect(Collectors.joining(", "));
            return String.format("ORDER BY %s\n", conditionString);
        }

        private String serializeSlice(Optional<Long> limit, Optional<Long> offset) {
            return this.dialectAdapter.sqlSlice(limit.orElse(-1L), offset.orElse(-1L));
        }

        @Override
        public SelectFromWhereSerializer.QuerySerialization visit(SQLSerializedQuery sqlSerializedQuery) {
            RelationID alias = this.generateFreshViewAlias();
            ImmutableMap columnIDs = (ImmutableMap)sqlSerializedQuery.getColumnNames().entrySet().stream().collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> this.createQualifiedAttributeId(alias, (String)e.getValue())));
            String sqlSubString = String.format("(%s) %s", sqlSerializedQuery.getSQLString(), alias.getSQLRendering());
            return new QuerySerializationImpl(sqlSubString, (ImmutableMap<Variable, QualifiedAttributeID>)columnIDs);
        }

        @Override
        public SelectFromWhereSerializer.QuerySerialization visit(SQLTable sqlTable) {
            DataAtom<RelationPredicate> atom = sqlTable.getAtom();
            RelationID aliasId = this.generateFreshViewAlias();
            RelationDefinition relationDefinition = ((RelationPredicate)atom.getPredicate()).getRelationDefinition();
            String relationRendering = Optional.of(relationDefinition).filter(r -> r instanceof ParserViewDefinition).map(r -> ((ParserViewDefinition)r).getStatement()).map(s -> String.format("(%s)", s)).orElseGet(() -> relationDefinition.getID().getSQLRendering());
            String sqlSubString = String.format("%s %s", relationRendering, aliasId.getSQLRendering());
            return new QuerySerializationImpl(sqlSubString, (ImmutableMap<Variable, QualifiedAttributeID>)((ImmutableMap)atom.getArguments().stream().map(a -> (Variable)a).collect(ImmutableCollectors.toMap(v -> v, v -> this.createQualifiedAttributeId(aliasId, relationDefinition.getAttribute(atom.getArguments().indexOf(v) + 1).getID().getSQLRendering())))));
        }

        @Override
        public SelectFromWhereSerializer.QuerySerialization visit(SQLNaryJoinExpression sqlNaryJoinExpression) {
            ImmutableList querySerializationList = (ImmutableList)sqlNaryJoinExpression.getJoinedExpressions().stream().map(this::getSQLSerializationForChild).collect(ImmutableCollectors.toList());
            String sqlSubString = querySerializationList.stream().map(SelectFromWhereSerializer.QuerySerialization::getString).collect(Collectors.joining(", "));
            ImmutableMap columnIDs = ImmutableMap.copyOf(querySerializationList.stream().flatMap(m -> m.getColumnIDs().entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
            return new QuerySerializationImpl(sqlSubString, (ImmutableMap<Variable, QualifiedAttributeID>)columnIDs);
        }

        @Override
        public SelectFromWhereSerializer.QuerySerialization visit(SQLUnionExpression sqlUnionExpression) {
            ImmutableList querySerializationList = (ImmutableList)sqlUnionExpression.getSubExpressions().stream().map(e -> e.acceptVisitor(this)).collect(ImmutableCollectors.toList());
            String sqlSubString = querySerializationList.stream().map(SelectFromWhereSerializer.QuerySerialization::getString).collect(Collectors.joining("UNION ALL \n"));
            RelationID alias = this.generateFreshViewAlias();
            ImmutableMap columnIDs = (ImmutableMap)sqlUnionExpression.getProjectedVariables().stream().collect(ImmutableCollectors.toMap(v -> v, v -> this.createQualifiedAttributeId(alias, this.dialectAdapter.sqlQuote(v.getName()))));
            sqlSubString = String.format("(%s) %s", sqlSubString, alias.getSQLRendering());
            return new QuerySerializationImpl(sqlSubString, (ImmutableMap<Variable, QualifiedAttributeID>)columnIDs);
        }

        private SelectFromWhereSerializer.QuerySerialization getSQLSerializationForChild(SQLExpression expression) {
            if (expression instanceof SelectFromWhereWithModifiers) {
                SelectFromWhereSerializer.QuerySerialization serialization = expression.acceptVisitor(this);
                RelationID alias = this.generateFreshViewAlias();
                ImmutableMap aliasedColumnIds = (ImmutableMap)serialization.getColumnIDs().entrySet().stream().collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> this.createQualifiedAttributeId(alias, this.dialectAdapter.sqlQuote(((Variable)e.getKey()).getName()))));
                String sql = String.format("(%s) %s", serialization.getString(), alias.getSQLRendering());
                return new QuerySerializationImpl(sql, (ImmutableMap<Variable, QualifiedAttributeID>)aliasedColumnIds);
            }
            return expression.acceptVisitor(this);
        }

        @Override
        public SelectFromWhereSerializer.QuerySerialization visit(SQLInnerJoinExpression sqlInnerJoinExpression) {
            return this.visit(sqlInnerJoinExpression, "JOIN");
        }

        @Override
        public SelectFromWhereSerializer.QuerySerialization visit(SQLLeftJoinExpression sqlLeftJoinExpression) {
            return this.visit(sqlLeftJoinExpression, "LEFT OUTER JOIN");
        }

        protected SelectFromWhereSerializer.QuerySerialization visit(BinaryJoinExpression binaryJoinExpression, String operatorString) {
            SelectFromWhereSerializer.QuerySerialization left = this.getSQLSerializationForChild(binaryJoinExpression.getLeft());
            SelectFromWhereSerializer.QuerySerialization right = this.getSQLSerializationForChild(binaryJoinExpression.getRight());
            String sqlSubString = String.format("%s\n %s \n%s ", left.getString(), operatorString, right.getString());
            ImmutableList querySerializationList = ImmutableList.of((Object)left, (Object)right);
            ImmutableMap columnIDs = (ImmutableMap)querySerializationList.stream().flatMap(m -> m.getColumnIDs().entrySet().stream()).collect(ImmutableCollectors.toMap());
            String onString = binaryJoinExpression.getFilterCondition().map(e -> this.sqlTermSerializer.serialize((ImmutableTerm)e, (ImmutableMap<Variable, QualifiedAttributeID>)columnIDs)).map(s -> String.format("ON %s ", s)).orElse("ON 1 = 1 ");
            sqlSubString = sqlSubString + onString;
            return new QuerySerializationImpl(sqlSubString, (ImmutableMap<Variable, QualifiedAttributeID>)columnIDs);
        }

        @Override
        public SelectFromWhereSerializer.QuerySerialization visit(SQLOneTupleDummyQueryExpression sqlOneTupleDummyQueryExpression) {
            Optional<String> trueTable = this.dialectAdapter.getTrueTable();
            String fromString = "";
            if (trueTable.isPresent()) {
                fromString = "FROM " + trueTable;
            }
            String sqlSubString = String.format("(SELECT 1 %s) tdummy", fromString);
            return new QuerySerializationImpl(sqlSubString, (ImmutableMap<Variable, QualifiedAttributeID>)ImmutableMap.of());
        }
    }
}

