/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.answering.reformulation.generation.dialect.impl;

import it.unibz.inf.ontop.answering.reformulation.generation.dialect.SQLDialectAdapter;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.type.DBTermType;
import java.util.Optional;
import java.util.Set;

public class SQL99DialectAdapter
implements SQLDialectAdapter {
    protected String escapedSingleQuote() {
        return "''";
    }

    @Override
    public String sqlQuote(String name) {
        return String.format("\"%s\"", name);
    }

    @Override
    public String sqlSlice(long limit, long offset) {
        if (limit < 0L && offset < 0L) {
            return "";
        }
        if (limit >= 0L && offset >= 0L) {
            return String.format("LIMIT %d, %d", offset, limit);
        }
        if (offset < 0L) {
            return String.format("LIMIT %d", limit);
        }
        return String.format("OFFSET %d", offset);
    }

    @Override
    public String nameTopVariable(String signatureVariableName, Set<String> sqlVariableNames) {
        return this.sqlQuote(this.buildDefaultName("", signatureVariableName, ""));
    }

    @Override
    public String render(DBConstant constant) {
        DBTermType dbType = constant.getType();
        switch (dbType.getCategory()) {
            case INTEGER: 
            case DECIMAL: 
            case FLOAT_DOUBLE: 
            case BOOLEAN: {
                return constant.getValue();
            }
        }
        return this.getSQLLexicalFormString(constant.getValue());
    }

    protected final String buildDefaultName(String prefix, String intermediateName, String suffix) {
        return prefix + intermediateName + suffix;
    }

    @Override
    public Optional<String> getTrueTable() {
        return Optional.empty();
    }

    protected String getSQLLexicalFormString(String constant) {
        return "'" + constant.replaceAll("(?<!')'(?!')", this.escapedSingleQuote()) + "'";
    }
}

