/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.answering.reformulation.generation.dialect.impl;

import it.unibz.inf.ontop.answering.reformulation.generation.dialect.impl.SQL99DialectAdapter;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.type.DBTermType;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;

public class OracleSQLDialectAdapter
extends SQL99DialectAdapter {
    public static final int NAME_MAX_LENGTH = 30;
    public static final int NAME_NUMBER_LENGTH = 3;
    private String databaseVersion;

    public OracleSQLDialectAdapter() {
        this.databaseVersion = "";
    }

    public OracleSQLDialectAdapter(String databaseVersion) {
        this.databaseVersion = databaseVersion;
    }

    @Override
    public String sqlSlice(long limit, long offset) {
        if (limit < 0L && offset < 0L) {
            return "";
        }
        String version = this.databaseVersion.split("\\.")[0];
        try {
            int versionInt = Integer.parseInt(version);
            if (versionInt < 12) {
                throw new UnsupportedOperationException("LIMIT and OFFSET are not supported for Oracle DBs prior to 12.1");
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (offset <= 0L) {
            return String.format("FETCH NEXT %d ROWS ONLY", limit);
        }
        if (limit < 0L) {
            return String.format("OFFSET %d ROWS\nFETCH NEXT 99999999 ROWS ONLY", limit);
        }
        return String.format("OFFSET %d ROWS\nFETCH NEXT %d ROWS ONLY", offset, limit);
    }

    @Override
    public Optional<String> getTrueTable() {
        return Optional.of("dual");
    }

    @Override
    public String nameTopVariable(String signatureVariableName, Set<String> sqlVariableNames) {
        return this.nameViewOrVariable("", signatureVariableName, "", sqlVariableNames, true);
    }

    @Override
    public String render(DBConstant constant) {
        DBTermType dbType = constant.getType();
        switch (dbType.getCategory()) {
            case DATETIME: {
                return String.format("TIMESTAMP '%s'", constant.getValue());
            }
        }
        return super.render(constant);
    }

    private String nameViewOrVariable(String prefix, String intermediateName, String suffix, Collection<String> alreadyDefinedNames, boolean putQuote) {
        int borderLength = prefix.length() + suffix.length();
        int signatureVarLength = intermediateName.length();
        if (borderLength >= 27) {
            throw new IllegalArgumentException("The prefix and the suffix are too long (their accumulated length must be less than 27)");
        }
        if (signatureVarLength + borderLength <= 30) {
            String unquotedName = this.buildDefaultName(prefix, intermediateName, suffix);
            String name = putQuote ? this.sqlQuote(unquotedName) : unquotedName;
            return name;
        }
        String shortenIntermediateNamePrefix = intermediateName.substring(0, 30 - borderLength - 3);
        int i = 0;
        while ((double)i < Math.pow(10.0, 3.0)) {
            String mainVarName;
            String unquotedVarName = this.buildDefaultName(prefix, shortenIntermediateNamePrefix + i, suffix);
            String string = mainVarName = putQuote ? this.sqlQuote(unquotedVarName) : unquotedVarName;
            if (!alreadyDefinedNames.contains(mainVarName)) {
                return mainVarName;
            }
            ++i;
        }
        throw new RuntimeException("Impossible to create a new variable/view " + prefix + shortenIntermediateNamePrefix + "???" + suffix + " : already " + Math.pow(10.0, 3.0) + " of them.");
    }
}

