/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.answering.reformulation.generation.dialect;

import it.unibz.inf.ontop.answering.reformulation.generation.dialect.SQLDialectAdapter;
import it.unibz.inf.ontop.answering.reformulation.generation.dialect.impl.AdpSQLDialectAdapter;
import it.unibz.inf.ontop.answering.reformulation.generation.dialect.impl.DB2SQLDialectAdapter;
import it.unibz.inf.ontop.answering.reformulation.generation.dialect.impl.DenodoSQLDialectAdapter;
import it.unibz.inf.ontop.answering.reformulation.generation.dialect.impl.DremioSQLDialectAdapter;
import it.unibz.inf.ontop.answering.reformulation.generation.dialect.impl.H2SQLDialectAdapter;
import it.unibz.inf.ontop.answering.reformulation.generation.dialect.impl.HSQLDBDialectAdapter;
import it.unibz.inf.ontop.answering.reformulation.generation.dialect.impl.MonetDBSQLDialectAdapter;
import it.unibz.inf.ontop.answering.reformulation.generation.dialect.impl.Mysql2SQLDialectAdapter;
import it.unibz.inf.ontop.answering.reformulation.generation.dialect.impl.OracleSQLDialectAdapter;
import it.unibz.inf.ontop.answering.reformulation.generation.dialect.impl.PostgreSQLDialectAdapter;
import it.unibz.inf.ontop.answering.reformulation.generation.dialect.impl.SAPHANASQLDialectAdapter;
import it.unibz.inf.ontop.answering.reformulation.generation.dialect.impl.SQLServerSQLDialectAdapter;
import it.unibz.inf.ontop.answering.reformulation.generation.dialect.impl.TeiidSQLDialectAdapter;
import it.unibz.inf.ontop.injection.OntopReformulationSQLSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLAdapterFactory {
    private static Logger log = LoggerFactory.getLogger(SQLAdapterFactory.class);

    public static SQLDialectAdapter getSQLDialectAdapter(String className, String databaseName, OntopReformulationSQLSettings preferences) {
        switch (className) {
            case "org.postgresql.Driver": {
                return new PostgreSQLDialectAdapter();
            }
            case "com.mysql.jdbc.Driver": 
            case "com.mysql.cj.jdbc.Driver": {
                return new Mysql2SQLDialectAdapter();
            }
            case "org.h2.Driver": {
                return new H2SQLDialectAdapter();
            }
            case "org.hsqldb.jdbc.JDBCDriver": {
                return new HSQLDBDialectAdapter();
            }
            case "com.ibm.db2.jcc.DB2Driver": {
                return new DB2SQLDialectAdapter();
            }
            case "oracle.jdbc.driver.OracleDriver": 
            case "oracle.jdbc.OracleDriver": {
                return new OracleSQLDialectAdapter(databaseName);
            }
            case "org.teiid.jdbc.TeiidDriver": {
                return new TeiidSQLDialectAdapter();
            }
            case "net.sourceforge.jtds.jdbc.Driver": 
            case "com.microsoft.sqlserver.jdbc.SQLServerDriver": {
                return new SQLServerSQLDialectAdapter();
            }
            case "madgik.adp.federatedjdbc.AdpDriver": {
                return new AdpSQLDialectAdapter();
            }
            case "nl.cwi.monetdb.jdbc.MonetDriver": {
                return new MonetDBSQLDialectAdapter();
            }
            case "com.sap.db.jdbc.Driver": {
                return new SAPHANASQLDialectAdapter();
            }
            case "com.dremio.jdbc.Driver": {
                return new DremioSQLDialectAdapter();
            }
            case "com.denodo.vdb.jdbcdriver.VDBJDBCDriver": 
            case "com.denodo.vdp.jdbc.Driver": {
                return new DenodoSQLDialectAdapter();
            }
        }
        log.warn("WARNING: the specified driver doesn't correspond to any of the drivers officially supported by Ontop.");
        log.warn("WARNING: Contact the authors for further support.");
        String adapterClassName = (String)preferences.getProperty(SQLDialectAdapter.class.getCanonicalName()).orElseThrow(() -> new IllegalStateException("No default SQLDialectAdapter provided"));
        try {
            Class<?> adapterClass = Class.forName(adapterClassName);
            return (SQLDialectAdapter)adapterClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Impossible to initialize the SQL adapter: " + e.getMessage());
        }
    }
}

