/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.rdf4j.query.impl;

import it.unibz.inf.ontop.answering.connection.OntopConnection;
import it.unibz.inf.ontop.answering.connection.OntopStatement;
import it.unibz.inf.ontop.answering.reformulation.input.InputQuery;
import it.unibz.inf.ontop.answering.reformulation.input.RDF4JConstructQuery;
import it.unibz.inf.ontop.answering.reformulation.input.RDF4JInputQueryFactory;
import it.unibz.inf.ontop.answering.resultset.GraphResultSet;
import it.unibz.inf.ontop.answering.resultset.OntopCloseableIterator;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMultimap;
import it.unibz.inf.ontop.exception.OntopConnectionException;
import it.unibz.inf.ontop.injection.OntopSystemSettings;
import it.unibz.inf.ontop.rdf4j.query.OntopCloseableStatementIteration;
import it.unibz.inf.ontop.rdf4j.query.impl.AbstractOntopQuery;
import it.unibz.inf.ontop.spec.ontology.RDFFact;
import java.util.Collections;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.impl.IteratingGraphQueryResult;
import org.eclipse.rdf4j.query.parser.ParsedDescribeQuery;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;

public class OntopGraphQuery
extends AbstractOntopQuery
implements GraphQuery {
    private final RDF4JInputQueryFactory inputQueryFactory;
    private final boolean isConstruct;

    public OntopGraphQuery(String queryString, ParsedQuery parsedQuery, String baseIRI, OntopConnection ontopConnection, ImmutableMultimap<String, String> httpHeaders, RDF4JInputQueryFactory inputQueryFactory, OntopSystemSettings settings) {
        super(queryString, baseIRI, parsedQuery, ontopConnection, httpHeaders, settings);
        this.isConstruct = !(parsedQuery instanceof ParsedDescribeQuery);
        this.inputQueryFactory = inputQueryFactory;
    }

    public GraphQueryResult evaluate() throws QueryEvaluationException {
        ParsedQuery parsedQuery = this.getParsedQuery();
        RDF4JConstructQuery query = this.isConstruct ? this.inputQueryFactory.createConstructQuery(this.getQueryString(), parsedQuery, (BindingSet)this.bindings) : this.inputQueryFactory.createDescribeQuery(this.getQueryString(), parsedQuery, (BindingSet)this.bindings);
        try {
            OntopStatement stm = this.conn.createStatement();
            if (this.queryTimeout > 0) {
                stm.setQueryTimeout(this.queryTimeout);
            }
            GraphResultSet res = (GraphResultSet)stm.execute((InputQuery)query, this.getHttpHeaders());
            return new IteratingGraphQueryResult(Collections.emptyMap(), (CloseableIteration)new OntopCloseableStatementIteration((OntopCloseableIterator<RDFFact, OntopConnectionException>)res.iterator()));
        }
        catch (Exception e) {
            throw new QueryEvaluationException((Throwable)e);
        }
    }

    public void evaluate(RDFHandler handler) throws QueryEvaluationException, RDFHandlerException {
        try (GraphQueryResult result = this.evaluate();){
            handler.startRDF();
            while (result.hasNext()) {
                handler.handleStatement((Statement)result.next());
            }
            handler.endRDF();
        }
    }
}

