/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.rdf4j.predefined.parsing.impl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Injector;
import com.moandjiezana.toml.Toml;
import it.unibz.inf.ontop.answering.reformulation.input.RDF4JConstructQuery;
import it.unibz.inf.ontop.answering.reformulation.input.RDF4JInputQueryFactory;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.Maps;
import it.unibz.inf.ontop.com.google.common.collect.Sets;
import it.unibz.inf.ontop.injection.OntopSystemConfiguration;
import it.unibz.inf.ontop.rdf4j.predefined.PredefinedGraphQuery;
import it.unibz.inf.ontop.rdf4j.predefined.PredefinedQueries;
import it.unibz.inf.ontop.rdf4j.predefined.PredefinedTupleQuery;
import it.unibz.inf.ontop.rdf4j.predefined.impl.PredefinedGraphQueryImpl;
import it.unibz.inf.ontop.rdf4j.predefined.parsing.PredefinedQueryConfigEntry;
import it.unibz.inf.ontop.rdf4j.predefined.parsing.PredefinedQueryConfigException;
import it.unibz.inf.ontop.rdf4j.predefined.parsing.PredefinedQueryParser;
import it.unibz.inf.ontop.rdf4j.predefined.parsing.impl.ParsedPredefinedQueryConfigEntry;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Query;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.impl.MapBindingSet;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.QueryParserUtil;

public class PredefinedQueryParserImpl
implements PredefinedQueryParser {
    private final RDF4JInputQueryFactory inputQueryFactory;

    public PredefinedQueryParserImpl(OntopSystemConfiguration configuration) {
        Injector injector = configuration.getInjector();
        this.inputQueryFactory = (RDF4JInputQueryFactory)injector.getInstance(RDF4JInputQueryFactory.class);
    }

    @Override
    public PredefinedQueries parse(@Nonnull Reader configReader, @Nonnull Reader queryReader) throws PredefinedQueryConfigException {
        return this.parse(configReader, queryReader, null);
    }

    @Override
    public PredefinedQueries parse(@Nonnull Reader configReader, @Nonnull Reader queryReader, @Nullable Reader contextReader) throws PredefinedQueryConfigException {
        try {
            Toml toml = new Toml().read(queryReader);
            ImmutableMap queryMap = (ImmutableMap)toml.entrySet().stream().filter(e -> e.getValue() instanceof Toml).flatMap(e -> Optional.ofNullable(((Toml)e.getValue()).getString("query")).map(v -> Maps.immutableEntry(e.getKey(), (Object)v)).map(Stream::of).orElseGet(Stream::empty)).collect(ImmutableCollectors.toMap());
            ObjectMapper mapper = new ObjectMapper();
            ImmutableMap<String, PredefinedQueryConfigEntry> configEntries = ((Config)mapper.readValue(configReader, Config.class)).getQueries();
            Sets.SetView missingQueries = Sets.difference((Set)configEntries.keySet(), (Set)queryMap.keySet());
            if (!missingQueries.isEmpty()) {
                throw new PredefinedQueryConfigException("Missing query entries for " + missingQueries);
            }
            ImmutableMap contextMap = contextReader == null ? ImmutableMap.of() : ImmutableMap.copyOf((Map)((Map)mapper.readValue(contextReader, (TypeReference)new TypeReference<HashMap<String, Object>>(){})));
            ImmutableMap graphQueries = (ImmutableMap)configEntries.entrySet().stream().filter(e -> ((PredefinedQueryConfigEntry)e.getValue()).getQueryType().equals((Object)Query.QueryType.GRAPH)).collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> this.createPredefinedGraphQuery((String)e.getKey(), (PredefinedQueryConfigEntry)e.getValue(), (String)queryMap.get(e.getKey()))));
            ImmutableMap tupleQueries = (ImmutableMap)configEntries.entrySet().stream().filter(e -> ((PredefinedQueryConfigEntry)e.getValue()).getQueryType().equals((Object)Query.QueryType.TUPLE)).collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> this.createPredefinedTupleQuery((String)e.getKey(), (PredefinedQueryConfigEntry)e.getValue(), (String)queryMap.get(e.getKey()))));
            return PredefinedQueries.defaultPredefinedQueries((ImmutableMap<String, PredefinedTupleQuery>)tupleQueries, (ImmutableMap<String, PredefinedGraphQuery>)graphQueries, (ImmutableMap<String, Object>)contextMap);
        }
        catch (IOException e2) {
            throw new PredefinedQueryConfigException(e2);
        }
    }

    private PredefinedGraphQuery createPredefinedGraphQuery(String id, PredefinedQueryConfigEntry queryConfigEntry, String queryString) {
        ParsedQuery parsedTree = QueryParserUtil.parseQuery((QueryLanguage)QueryLanguage.SPARQL, (String)queryString, null);
        RDF4JConstructQuery graphQuery = this.inputQueryFactory.createConstructQuery(queryString, parsedTree, (BindingSet)new MapBindingSet());
        return new PredefinedGraphQueryImpl(id, graphQuery, queryConfigEntry);
    }

    private PredefinedTupleQuery createPredefinedTupleQuery(String id, PredefinedQueryConfigEntry queryConfigEntry, String queryString) {
        throw new RuntimeException("TODO: support tuple queries");
    }

    private static class Config {
        private final ImmutableMap<String, PredefinedQueryConfigEntry> queries;

        @JsonCreator
        public Config(@JsonProperty(value="queries") Map<String, ParsedPredefinedQueryConfigEntry> queries) {
            this.queries = ImmutableMap.copyOf(queries);
        }

        public ImmutableMap<String, PredefinedQueryConfigEntry> getQueries() {
            return this.queries;
        }
    }
}

