/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.rdf4j.predefined.parsing.impl;

import com.fasterxml.jackson.annotation.JsonProperty;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.rdf4j.predefined.parsing.PredefinedQueryConfigEntry;
import it.unibz.inf.ontop.rdf4j.predefined.parsing.impl.QueryParameterTypeImpl;
import java.util.Map;
import java.util.Optional;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.Query;

public class ParsedPredefinedQueryConfigEntry
implements PredefinedQueryConfigEntry {
    @JsonProperty(value="queryType", required=true)
    private String queryTypeString;
    private Query.QueryType queryType;
    @JsonProperty(value="name", required=false)
    private String name;
    @JsonProperty(value="description", required=false)
    private String description;
    @JsonProperty(value="frame", required=false)
    private Map<String, Object> frame;
    @JsonProperty(value="parameters", required=true)
    private Map<String, ParsedQueryParameter> parameters;
    private ImmutableMap<String, PredefinedQueryConfigEntry.QueryParameter> typedParameters;
    @JsonProperty(value="return404IfEmpty", required=false)
    private Boolean return404IfEmpty;
    @JsonProperty(value="resultStreaming", required=false)
    private Boolean resultStreaming;

    @Override
    public Query.QueryType getQueryType() {
        if (this.queryType == null) {
            this.queryType = Query.QueryType.valueOf((String)this.queryTypeString.toUpperCase());
        }
        return this.queryType;
    }

    @Override
    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    @Override
    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    @Override
    public Optional<Map<String, Object>> getFrame() {
        return Optional.ofNullable(this.frame);
    }

    @Override
    public ImmutableMap<String, PredefinedQueryConfigEntry.QueryParameter> getParameters() {
        if (this.typedParameters == null) {
            this.typedParameters = ImmutableMap.copyOf(this.parameters);
        }
        return this.typedParameters;
    }

    @Override
    public boolean shouldReturn404IfEmpty() {
        if (this.return404IfEmpty == null) {
            this.return404IfEmpty = false;
        }
        return this.return404IfEmpty;
    }

    @Override
    public boolean isResultStreamingEnabled() {
        if (this.resultStreaming == null) {
            this.resultStreaming = false;
        }
        return this.resultStreaming;
    }

    protected static class ParsedQueryParameter
    implements PredefinedQueryConfigEntry.QueryParameter {
        @JsonProperty(value="description", required=false)
        private String description;
        @JsonProperty(value="type", required=true)
        private String type;
        private PredefinedQueryConfigEntry.QueryParameterType parameterType;
        @JsonProperty(value="safeForRandomGeneration", required=true)
        private Boolean safeForRandomGeneration;
        @JsonProperty(value="required", required=true)
        private Boolean required;

        protected ParsedQueryParameter() {
        }

        @Override
        public Optional<String> getDescription() {
            return Optional.ofNullable(this.description);
        }

        @Override
        public Boolean isSafeForRandomGeneration() {
            return this.safeForRandomGeneration;
        }

        @Override
        public Boolean getRequired() {
            return this.required;
        }

        @Override
        public PredefinedQueryConfigEntry.QueryParameterType getType() {
            if (this.parameterType == null) {
                if (this.type.toUpperCase().equals("IRI")) {
                    return new QueryParameterTypeImpl(PredefinedQueryConfigEntry.QueryParameterCategory.IRI);
                }
                String typeString = this.type.startsWith("xsd:") ? "http://www.w3.org/2001/XMLSchema#" + this.type.substring(4) : this.type;
                return new QueryParameterTypeImpl(PredefinedQueryConfigEntry.QueryParameterCategory.TYPED_LITERAL, SimpleValueFactory.getInstance().createIRI(typeString));
            }
            return this.parameterType;
        }
    }
}

