/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.rdf4j.predefined.impl;

import it.unibz.inf.ontop.answering.reformulation.input.RDF4JInputQuery;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.model.vocabulary.XSD;
import it.unibz.inf.ontop.rdf4j.predefined.InvalidBindingSetException;
import it.unibz.inf.ontop.rdf4j.predefined.PredefinedQuery;
import it.unibz.inf.ontop.rdf4j.predefined.parsing.PredefinedQueryConfigEntry;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.impl.MapBindingSet;

public class AbstractPredefinedQuery<Q extends RDF4JInputQuery>
implements PredefinedQuery<Q> {
    private final String id;
    protected final PredefinedQueryConfigEntry queryConfig;
    private final Q inputQuery;
    private final ConcurrentMap<String, String> referenceValues;

    public AbstractPredefinedQuery(String id, Q inputQuery, PredefinedQueryConfigEntry queryConfig) {
        this.id = id;
        this.queryConfig = queryConfig;
        this.inputQuery = inputQuery;
        this.referenceValues = new ConcurrentHashMap<String, String>();
    }

    @Override
    public Q getInputQuery() {
        return this.inputQuery;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Optional<String> getName() {
        return this.queryConfig.getName();
    }

    @Override
    public Optional<String> getDescription() {
        return this.queryConfig.getDescription();
    }

    @Override
    public boolean shouldReturn404IfEmpty() {
        return this.queryConfig.shouldReturn404IfEmpty();
    }

    @Override
    public boolean isResultStreamingEnabled() {
        return this.queryConfig.isResultStreamingEnabled();
    }

    @Override
    public void validate(ImmutableMap<String, String> bindings) throws InvalidBindingSetException {
        ImmutableMap<String, PredefinedQueryConfigEntry.QueryParameter> parameterConfigMap = this.queryConfig.getParameters();
        ImmutableList.Builder problemBuilder = ImmutableList.builder();
        for (Map.Entry parameterEntry : parameterConfigMap.entrySet()) {
            String parameterId = (String)parameterEntry.getKey();
            PredefinedQueryConfigEntry.QueryParameter queryParameter = (PredefinedQueryConfigEntry.QueryParameter)parameterEntry.getValue();
            if (!bindings.containsKey((Object)parameterId)) {
                if (!queryParameter.getRequired().booleanValue()) continue;
                problemBuilder.add((Object)("The required parameter " + parameterId + " is missing"));
                continue;
            }
            this.validate((String)bindings.get((Object)parameterId), ((PredefinedQueryConfigEntry.QueryParameter)parameterEntry.getValue()).getType()).ifPresent(arg_0 -> ((ImmutableList.Builder)problemBuilder).add(arg_0));
        }
        ImmutableList problems = problemBuilder.build();
        switch (problems.size()) {
            case 0: {
                return;
            }
            case 1: {
                throw new InvalidBindingSetException((String)problems.get(0));
            }
        }
        throw new InvalidBindingSetException("Invalid parameters: \n - " + String.join((CharSequence)"\n - ", (Iterable<? extends CharSequence>)problems));
    }

    @Override
    public BindingSet convertBindings(ImmutableMap<String, String> bindings) {
        SimpleValueFactory valueFactory = SimpleValueFactory.getInstance();
        ImmutableMap<String, PredefinedQueryConfigEntry.QueryParameter> parameterConfigMap = this.queryConfig.getParameters();
        MapBindingSet bindingSet = new MapBindingSet();
        for (Map.Entry parameterEntry : parameterConfigMap.entrySet()) {
            String parameterId = (String)parameterEntry.getKey();
            if (!bindings.containsKey((Object)parameterId)) continue;
            String lexicalValue = (String)bindings.get((Object)parameterId);
            PredefinedQueryConfigEntry.QueryParameter queryParameter = (PredefinedQueryConfigEntry.QueryParameter)parameterEntry.getValue();
            bindingSet.addBinding(parameterId, this.convertAndValidate(lexicalValue, queryParameter.getType(), (ValueFactory)valueFactory));
        }
        return bindingSet;
    }

    @Override
    public ImmutableMap<String, String> replaceWithReferenceValues(ImmutableMap<String, String> bindings) {
        ImmutableMap<String, PredefinedQueryConfigEntry.QueryParameter> parameterMap = this.queryConfig.getParameters();
        return (ImmutableMap)bindings.entrySet().stream().filter(e -> parameterMap.containsKey(e.getKey())).collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> this.getReferenceValue((String)e.getKey(), (PredefinedQueryConfigEntry.QueryParameter)parameterMap.get(e.getKey())).orElseGet(e::getValue)));
    }

    private Value convertAndValidate(String lexicalValue, PredefinedQueryConfigEntry.QueryParameterType parameterType, ValueFactory valueFactory) {
        switch (parameterType.getCategory()) {
            case IRI: {
                return valueFactory.createIRI(lexicalValue);
            }
            case TYPED_LITERAL: {
                return valueFactory.createLiteral(lexicalValue, parameterType.getDatatypeIRI().orElseThrow(() -> new MinorOntopInternalBugException("A typed literal must have a datatype IRI")));
            }
        }
        throw new MinorOntopInternalBugException("Not supported category: " + (Object)((Object)parameterType.getCategory()));
    }

    private Optional<String> validate(String lexicalValue, PredefinedQueryConfigEntry.QueryParameterType parameterType) {
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<String> getReferenceValue(String paramId, PredefinedQueryConfigEntry.QueryParameter queryParameter) {
        if (!queryParameter.isSafeForRandomGeneration().booleanValue()) {
            return Optional.empty();
        }
        if (!this.referenceValues.containsKey(paramId)) {
            AbstractPredefinedQuery abstractPredefinedQuery = this;
            synchronized (abstractPredefinedQuery) {
                return Optional.of(this.referenceValues.computeIfAbsent(paramId, k -> AbstractPredefinedQuery.generateReferenceValue(queryParameter.getType())));
            }
        }
        return Optional.of(this.referenceValues.get(paramId));
    }

    private static String generateReferenceValue(PredefinedQueryConfigEntry.QueryParameterType paramType) {
        switch (paramType.getCategory()) {
            case IRI: {
                return String.format("http://%s.example.org/fake", UUID.randomUUID().toString());
            }
            case TYPED_LITERAL: {
                return AbstractPredefinedQuery.generateReferenceLiteralValue(paramType.getDatatypeIRI().orElseThrow(() -> new MinorOntopInternalBugException("Invalid typed literal")));
            }
        }
        throw new MinorOntopInternalBugException("Unexpected parameter type: " + (Object)((Object)paramType.getCategory()));
    }

    private static String generateReferenceLiteralValue(IRI datatype) {
        String iriString = datatype.stringValue();
        if (iriString.equals(XSD.STRING.getIRIString())) {
            return UUID.randomUUID().toString();
        }
        throw new RuntimeException("TODO: support random generation of " + datatype);
    }
}

