/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.rdf4j.jsonld;

import com.github.jsonldjava.core.DocumentLoader;
import it.unibz.inf.ontop.rdf4j.jsonld.FramedJSONLDWriter;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.Map;
import javax.annotation.Nullable;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.RDFWriterFactory;

public class FramedJSONLDWriterFactory
implements RDFWriterFactory {
    private final Map<String, Object> jsonLDFrame;
    @Nullable
    private final DocumentLoader documentLoader;
    private final boolean throwExceptionIfEmpty;

    public FramedJSONLDWriterFactory(Map<String, Object> jsonLDFrame) {
        this.jsonLDFrame = jsonLDFrame;
        this.documentLoader = null;
        this.throwExceptionIfEmpty = false;
    }

    public FramedJSONLDWriterFactory(Map<String, Object> jsonLdFrame, DocumentLoader documentLoader, boolean throwExceptionIfEmpty) {
        this.jsonLDFrame = jsonLdFrame;
        this.documentLoader = documentLoader;
        this.throwExceptionIfEmpty = throwExceptionIfEmpty;
    }

    public RDFFormat getRDFFormat() {
        return RDFFormat.JSONLD;
    }

    public RDFWriter getWriter(OutputStream out) {
        return new FramedJSONLDWriter(this.jsonLDFrame, this.documentLoader, out, this.throwExceptionIfEmpty);
    }

    public RDFWriter getWriter(OutputStream out, String baseURI) throws URISyntaxException {
        return new FramedJSONLDWriter(this.jsonLDFrame, this.documentLoader, out, baseURI, this.throwExceptionIfEmpty);
    }

    public RDFWriter getWriter(Writer writer) {
        return new FramedJSONLDWriter(this.jsonLDFrame, this.documentLoader, writer, this.throwExceptionIfEmpty);
    }

    public RDFWriter getWriter(Writer writer, String baseURI) throws URISyntaxException {
        return new FramedJSONLDWriter(this.jsonLDFrame, this.documentLoader, writer, baseURI, this.throwExceptionIfEmpty);
    }
}

