/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.rdf4j.query.impl;

import it.unibz.inf.ontop.answering.connection.OntopConnection;
import it.unibz.inf.ontop.injection.OntopSystemSettings;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.Query;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.impl.MapBindingSet;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.QueryParserUtil;

public abstract class AbstractOntopQuery
implements Query {
    private final String queryString;
    private final ParsedQuery initialParsedQuery;
    private final String baseIRI;
    protected final OntopConnection conn;
    protected int queryTimeout;
    protected MapBindingSet bindings = new MapBindingSet();

    protected AbstractOntopQuery(String queryString, String baseIRI, ParsedQuery initialParsedQuery, OntopConnection conn, OntopSystemSettings settings) {
        this.queryString = queryString;
        this.baseIRI = baseIRI;
        this.conn = conn;
        this.queryTimeout = settings.getDefaultQueryTimeout().orElse(0);
        this.initialParsedQuery = initialParsedQuery;
    }

    public void setBinding(String s, Value value) {
        this.bindings.addBinding(s, value);
    }

    public void removeBinding(String s) {
        this.bindings.removeBinding(s);
    }

    public void clearBindings() {
        this.bindings.clear();
    }

    public BindingSet getBindings() {
        return this.bindings;
    }

    public Dataset getDataset() {
        throw new UnsupportedOperationException();
    }

    public void setDataset(Dataset dataset) {
        throw new UnsupportedOperationException();
    }

    public boolean getIncludeInferred() {
        return true;
    }

    public void setIncludeInferred(boolean includeInferred) {
        if (!includeInferred) {
            throw new UnsupportedOperationException("Inference can't be disabled.");
        }
    }

    public int getMaxQueryTime() {
        return this.queryTimeout;
    }

    public void setMaxQueryTime(int maxQueryTime) {
        this.queryTimeout = maxQueryTime;
    }

    public void setMaxExecutionTime(int maxExecTime) {
        this.setMaxQueryTime(maxExecTime);
    }

    public int getMaxExecutionTime() {
        return this.getMaxQueryTime();
    }

    protected String getQueryString() {
        if (this.bindings.size() == 0) {
            return this.queryString;
        }
        String qry = this.queryString;
        int b = qry.indexOf(123);
        String select = qry.substring(0, b);
        String where = qry.substring(b);
        for (String name : this.bindings.getBindingNames()) {
            String replacement = this.getReplacement(this.bindings.getValue(name));
            if (replacement == null) continue;
            String pattern = "[\\?\\$]" + name + "(?=\\W)";
            select = select.replaceAll(pattern, "");
            where = where.replaceAll(pattern, replacement);
        }
        return select + where;
    }

    protected ParsedQuery getParsedQuery() {
        if (this.bindings.size() == 0) {
            return this.initialParsedQuery;
        }
        return QueryParserUtil.parseQuery((QueryLanguage)QueryLanguage.SPARQL, (String)this.getQueryString(), (String)this.baseIRI);
    }

    private String getReplacement(Value value) {
        StringBuilder sb = new StringBuilder();
        if (value instanceof IRI) {
            return this.appendValue(sb, (IRI)value).toString();
        }
        if (value instanceof Literal) {
            return this.appendValue(sb, (Literal)value).toString();
        }
        throw new IllegalArgumentException("BNode references not supported by SPARQL end-points");
    }

    private StringBuilder appendValue(StringBuilder sb, IRI uri) {
        sb.append("<").append(uri.stringValue()).append(">");
        return sb;
    }

    private StringBuilder appendValue(StringBuilder sb, Literal lit) {
        sb.append('\"');
        sb.append(lit.getLabel().replace("\"", "\\\""));
        sb.append('\"');
        if (lit.getLanguage() != null) {
            sb.append('@');
            sb.append(lit.getLanguage());
        } else if (lit.getDatatype() != null) {
            sb.append("^^<");
            sb.append(lit.getDatatype().stringValue());
            sb.append('>');
        }
        return sb;
    }
}

