/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.rdf4j.materialization.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.answering.resultset.MaterializedGraphResultSet;
import it.unibz.inf.ontop.exception.OBDASpecificationException;
import it.unibz.inf.ontop.exception.OntopConnectionException;
import it.unibz.inf.ontop.exception.OntopQueryAnsweringException;
import it.unibz.inf.ontop.injection.OntopSystemConfiguration;
import it.unibz.inf.ontop.materialization.MaterializationParams;
import it.unibz.inf.ontop.materialization.OntopRDFMaterializer;
import it.unibz.inf.ontop.materialization.impl.DefaultOntopRDFMaterializer;
import it.unibz.inf.ontop.rdf4j.materialization.RDF4JMaterializer;
import it.unibz.inf.ontop.rdf4j.query.MaterializationGraphQuery;
import it.unibz.inf.ontop.rdf4j.utils.RDF4JHelper;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.rdf.api.IRI;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.impl.IteratingGraphQueryResult;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;

public class DefaultRDF4JMaterializer
implements RDF4JMaterializer {
    private final OntopRDFMaterializer materializer;

    public DefaultRDF4JMaterializer(OntopSystemConfiguration configuration, MaterializationParams materializationParams) throws OBDASpecificationException {
        this.materializer = new DefaultOntopRDFMaterializer(configuration, materializationParams);
    }

    public DefaultRDF4JMaterializer(OntopSystemConfiguration configuration) throws OBDASpecificationException {
        this(configuration, MaterializationParams.defaultBuilder().build());
    }

    @Override
    public MaterializationGraphQuery materialize() throws RepositoryException {
        try {
            MaterializedGraphResultSet graphResultSet = this.materializer.materialize();
            return new DefaultMaterializedGraphQuery(graphResultSet);
        }
        catch (OBDASpecificationException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    public MaterializationGraphQuery materialize(@Nonnull ImmutableSet<IRI> selectedVocabulary) throws RepositoryException {
        try {
            MaterializedGraphResultSet graphResultSet = this.materializer.materialize(selectedVocabulary);
            return new DefaultMaterializedGraphQuery(graphResultSet);
        }
        catch (OBDASpecificationException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    public ImmutableSet<IRI> getClasses() {
        return this.materializer.getClasses();
    }

    @Override
    public ImmutableSet<IRI> getProperties() {
        return this.materializer.getProperties();
    }

    private static class GraphMaterializationIteration
    implements CloseableIteration<Statement, QueryEvaluationException> {
        private final MaterializedGraphResultSet graphResultSet;

        GraphMaterializationIteration(MaterializedGraphResultSet graphResultSet) {
            this.graphResultSet = graphResultSet;
        }

        public void close() throws QueryEvaluationException {
            try {
                this.graphResultSet.close();
            }
            catch (OntopConnectionException e) {
                throw new QueryEvaluationException((Throwable)e);
            }
        }

        public boolean hasNext() throws QueryEvaluationException {
            try {
                return this.graphResultSet.hasNext();
            }
            catch (OntopConnectionException | OntopQueryAnsweringException e) {
                throw new QueryEvaluationException(e);
            }
        }

        public Statement next() throws QueryEvaluationException {
            try {
                return RDF4JHelper.createStatement(this.graphResultSet.next());
            }
            catch (OntopQueryAnsweringException e) {
                throw new QueryEvaluationException((Throwable)e);
            }
        }

        public void remove() throws QueryEvaluationException {
            throw new UnsupportedOperationException("TODO: support remove()");
        }
    }

    private static class DefaultMaterializedGraphQuery
    implements MaterializationGraphQuery {
        private static final String NOT_AVAILABLE_OPTION = "This option is not available for materialization";
        private static final String NOT_AVAILABLE_INFO = "This information is not available for materialization";
        private final MaterializedGraphResultSet graphResultSet;
        private boolean hasStarted;

        DefaultMaterializedGraphQuery(MaterializedGraphResultSet graphResultSet) {
            this.graphResultSet = graphResultSet;
            this.hasStarted = false;
        }

        public GraphQueryResult evaluate() throws QueryEvaluationException {
            if (this.hasStarted) {
                throw new QueryEvaluationException("A materialization GraphQuery can only be evaluated once");
            }
            this.hasStarted = true;
            return new IteratingGraphQueryResult((Map)ImmutableMap.of(), (CloseableIteration)new GraphMaterializationIteration(this.graphResultSet));
        }

        public void evaluate(RDFHandler handler) throws QueryEvaluationException, RDFHandlerException {
            try (GraphQueryResult result = this.evaluate();){
                handler.startRDF();
                while (result.hasNext()) {
                    handler.handleStatement((Statement)result.next());
                }
                handler.endRDF();
            }
        }

        public void setMaxQueryTime(int maxQueryTime) {
            throw new UnsupportedOperationException(NOT_AVAILABLE_OPTION);
        }

        public int getMaxQueryTime() {
            throw new UnsupportedOperationException(NOT_AVAILABLE_INFO);
        }

        public void setBinding(String name, Value value) {
            throw new UnsupportedOperationException(NOT_AVAILABLE_OPTION);
        }

        public void removeBinding(String name) {
            throw new UnsupportedOperationException(NOT_AVAILABLE_OPTION);
        }

        public void clearBindings() {
            throw new UnsupportedOperationException(NOT_AVAILABLE_OPTION);
        }

        public BindingSet getBindings() {
            throw new UnsupportedOperationException(NOT_AVAILABLE_INFO);
        }

        public void setDataset(Dataset dataset) {
            throw new UnsupportedOperationException(NOT_AVAILABLE_OPTION);
        }

        public Dataset getDataset() {
            throw new UnsupportedOperationException(NOT_AVAILABLE_INFO);
        }

        public void setIncludeInferred(boolean includeInferred) {
            throw new UnsupportedOperationException(NOT_AVAILABLE_OPTION);
        }

        public boolean getIncludeInferred() {
            throw new UnsupportedOperationException(NOT_AVAILABLE_INFO);
        }

        public void setMaxExecutionTime(int maxExecTime) {
            throw new UnsupportedOperationException(NOT_AVAILABLE_OPTION);
        }

        public int getMaxExecutionTime() {
            throw new UnsupportedOperationException(NOT_AVAILABLE_INFO);
        }

        @Override
        public long getTripleCountSoFar() {
            return this.graphResultSet.getTripleCountSoFar();
        }

        @Override
        public boolean hasEncounteredProblemsSoFar() {
            return this.graphResultSet.hasEncounteredProblemsSoFar();
        }

        @Override
        public ImmutableList<IRI> getPossiblyIncompleteRDFPropertiesAndClassesSoFar() {
            return this.graphResultSet.getPossiblyIncompleteRDFPropertiesAndClassesSoFar();
        }

        @Override
        public ImmutableSet<IRI> getSelectedVocabulary() {
            return this.graphResultSet.getSelectedVocabulary();
        }
    }
}

