/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.rdf4j.utils;

import it.unibz.inf.ontop.model.term.BNode;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.IRIConstant;
import it.unibz.inf.ontop.model.term.ObjectConstant;
import it.unibz.inf.ontop.model.term.RDFLiteralConstant;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.spec.ontology.AnnotationAssertion;
import it.unibz.inf.ontop.spec.ontology.Assertion;
import it.unibz.inf.ontop.spec.ontology.ClassAssertion;
import it.unibz.inf.ontop.spec.ontology.DataPropertyAssertion;
import it.unibz.inf.ontop.spec.ontology.ObjectPropertyAssertion;
import java.util.Objects;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;

public class RDF4JHelper {
    private static final ValueFactory fact = SimpleValueFactory.getInstance();

    public static Resource getResource(ObjectConstant obj) {
        if (obj instanceof BNode) {
            return fact.createBNode(((BNode)obj).getName());
        }
        if (obj instanceof IRIConstant) {
            return fact.createIRI(((IRIConstant)obj).getIRI().getIRIString());
        }
        return null;
    }

    public static Literal getLiteral(RDFLiteralConstant literal) {
        Objects.requireNonNull(literal);
        RDFDatatype type = literal.getType();
        if (!(type instanceof RDFDatatype)) {
            throw new IllegalStateException("A ValueConstant given to OWLAPI must have a RDF datatype");
        }
        RDFDatatype datatype = type;
        return datatype.getLanguageTag().map(lang -> fact.createLiteral(literal.getValue(), lang.getFullString())).orElseGet(() -> fact.createLiteral(literal.getValue(), fact.createIRI(datatype.getIRI().getIRIString())));
    }

    public static Value getValue(Constant c) {
        if (c == null) {
            return null;
        }
        Literal value = null;
        if (c instanceof RDFLiteralConstant) {
            value = RDF4JHelper.getLiteral((RDFLiteralConstant)c);
        } else if (c instanceof ObjectConstant) {
            value = RDF4JHelper.getResource((ObjectConstant)c);
        }
        return value;
    }

    private static IRI createURI(String uri) {
        return fact.createIRI(uri);
    }

    public static Statement createStatement(Assertion assertion) {
        if (assertion instanceof ObjectPropertyAssertion) {
            return RDF4JHelper.createStatement((ObjectPropertyAssertion)assertion);
        }
        if (assertion instanceof DataPropertyAssertion) {
            return RDF4JHelper.createStatement((DataPropertyAssertion)assertion);
        }
        if (assertion instanceof ClassAssertion) {
            return RDF4JHelper.createStatement((ClassAssertion)assertion);
        }
        if (assertion instanceof AnnotationAssertion) {
            return RDF4JHelper.createStatement((AnnotationAssertion)assertion);
        }
        throw new RuntimeException("Unsupported assertion: " + assertion);
    }

    private static Statement createStatement(ObjectPropertyAssertion assertion) {
        return fact.createStatement(RDF4JHelper.getResource(assertion.getSubject()), RDF4JHelper.createURI(assertion.getProperty().getIRI().getIRIString()), (Value)RDF4JHelper.getResource(assertion.getObject()));
    }

    private static Statement createStatement(DataPropertyAssertion assertion) {
        return fact.createStatement(RDF4JHelper.getResource(assertion.getSubject()), RDF4JHelper.createURI(assertion.getProperty().getIRI().getIRIString()), (Value)RDF4JHelper.getLiteral(assertion.getValue()));
    }

    private static Statement createStatement(AnnotationAssertion assertion) {
        Constant constant = assertion.getValue();
        if (constant instanceof RDFLiteralConstant) {
            return fact.createStatement(RDF4JHelper.getResource(assertion.getSubject()), RDF4JHelper.createURI(assertion.getProperty().getIRI().getIRIString()), (Value)RDF4JHelper.getLiteral((RDFLiteralConstant)constant));
        }
        if (constant instanceof ObjectConstant) {
            return fact.createStatement(RDF4JHelper.getResource(assertion.getSubject()), RDF4JHelper.createURI(assertion.getProperty().getIRI().getIRIString()), (Value)RDF4JHelper.getResource((ObjectConstant)constant));
        }
        throw new RuntimeException("Unsupported constant for an annotation property!" + constant);
    }

    private static Statement createStatement(ClassAssertion assertion) {
        return fact.createStatement(RDF4JHelper.getResource(assertion.getIndividual()), RDF.TYPE, (Value)RDF4JHelper.createURI(assertion.getConcept().getIRI().getIRIString()));
    }
}

