/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.rdf4j.query.impl;

import it.unibz.inf.ontop.answering.connection.OntopConnection;
import it.unibz.inf.ontop.answering.connection.OntopStatement;
import it.unibz.inf.ontop.answering.reformulation.input.InputQuery;
import it.unibz.inf.ontop.answering.reformulation.input.RDF4JInputQueryFactory;
import it.unibz.inf.ontop.answering.reformulation.input.SelectQuery;
import it.unibz.inf.ontop.answering.resultset.TupleResultSet;
import it.unibz.inf.ontop.exception.OntopQueryAnsweringException;
import it.unibz.inf.ontop.injection.OntopSystemSettings;
import it.unibz.inf.ontop.rdf4j.query.impl.AbstractOntopQuery;
import it.unibz.inf.ontop.rdf4j.query.impl.OntopTupleQueryResult;
import java.util.List;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.query.parser.ParsedQuery;

public class OntopTupleQuery
extends AbstractOntopQuery
implements TupleQuery {
    private final RDF4JInputQueryFactory factory;

    public OntopTupleQuery(String queryString, ParsedQuery parsedQuery, String baseIRI, OntopConnection conn, RDF4JInputQueryFactory factory, OntopSystemSettings settings) {
        super(queryString, baseIRI, parsedQuery, conn, settings);
        this.factory = factory;
    }

    public TupleQueryResult evaluate() throws QueryEvaluationException {
        long start = System.currentTimeMillis();
        try {
            TupleResultSet res;
            OntopStatement stm = this.conn.createStatement();
            if (this.queryTimeout > 0) {
                stm.setQueryTimeout(this.queryTimeout);
            }
            try {
                SelectQuery inputQuery = this.factory.createSelectQuery(this.getQueryString(), this.getParsedQuery());
                res = (TupleResultSet)stm.execute((InputQuery)inputQuery);
            }
            catch (OntopQueryAnsweringException e) {
                long end = System.currentTimeMillis();
                if (this.queryTimeout > 0 && end - start >= (long)(this.queryTimeout * 1000)) {
                    throw new QueryEvaluationException("OntopTupleQuery timed out. More than " + this.queryTimeout + " seconds passed", (Throwable)e);
                }
                throw e;
            }
            List signature = res.getSignature();
            return new OntopTupleQueryResult(res, signature);
        }
        catch (QueryEvaluationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QueryEvaluationException((Throwable)e);
        }
    }

    public void evaluate(TupleQueryResultHandler handler) throws QueryEvaluationException, TupleQueryResultHandlerException {
        TupleQueryResult result = this.evaluate();
        handler.startQueryResult(result.getBindingNames());
        while (result.hasNext()) {
            handler.handleSolution((BindingSet)result.next());
        }
        handler.endQueryResult();
    }
}

